/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.internal;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.server.frontend.EndpointGeneratorTaskFactory;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateEndpoint;
import com.vaadin.flow.server.frontend.TaskGenerateOpenAPI;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.hilla.engine.ParserProcessor;
import com.vaadin.hilla.internal.TaskGenerateEndpointImpl;
import com.vaadin.hilla.internal.TaskGenerateOpenAPIImpl;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointGeneratorTaskFactoryImpl
implements EndpointGeneratorTaskFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserProcessor.class);

    private static FrontendTools buildTools(Options options) {
        FrontendToolsSettings settings = new FrontendToolsSettings(options.getNpmFolder().getAbsolutePath(), (SerializableSupplier & Serializable)() -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setNodeDownloadRoot(options.getNodeDownloadRoot());
        settings.setForceAlternativeNode(options.isRequireHomeNodeExec());
        settings.setUseGlobalPnpm(options.isUseGlobalPnpm());
        settings.setAutoUpdate(options.isNodeAutoUpdate());
        settings.setNodeVersion(options.getNodeVersion());
        return new FrontendTools(settings);
    }

    public TaskGenerateEndpoint createTaskGenerateEndpoint(Options options) {
        if (!(options.isRunNpmInstall() || options.isDevBundleBuild() || options.isProductionMode())) {
            return new SkipTaskGenerateEndpoint();
        }
        String nodeExecutable = EndpointGeneratorTaskFactoryImpl.buildTools(options).getNodeExecutable();
        return new TaskGenerateEndpointImpl(options.getNpmFolder(), options.getBuildDirectoryName(), options.getFrontendGeneratedFolder(), arg_0 -> ((ClassFinder)options.getClassFinder()).getResource(arg_0), options.isProductionMode(), nodeExecutable);
    }

    public TaskGenerateOpenAPI createTaskGenerateOpenAPI(Options options) {
        if (!(options.isRunNpmInstall() || options.isDevBundleBuild() || options.isProductionMode())) {
            return new SkipTaskGenerateOpenAPI();
        }
        return new TaskGenerateOpenAPIImpl(options.getNpmFolder(), options.getBuildDirectoryName(), options.getFrontendGeneratedFolder(), arg_0 -> ((ClassFinder)options.getClassFinder()).getResource(arg_0), options.getClassFinder().getClassLoader(), options.isProductionMode());
    }

    private static class SkipTaskGenerateEndpoint
    implements TaskGenerateEndpoint {
        private SkipTaskGenerateEndpoint() {
        }

        public void execute() {
            LOGGER.debug("Skipping generating TypeScript endpoints");
        }
    }

    private static class SkipTaskGenerateOpenAPI
    implements TaskGenerateOpenAPI {
        private SkipTaskGenerateOpenAPI() {
        }

        public void execute() {
            LOGGER.debug("Skipping generating OpenAPI spec");
        }
    }
}

