/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.EnvironmentVariables;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;

public class LocalProKey {
    private static ProKey read(File proKeyLocation) throws IOException {
        if (!proKeyLocation.exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(proKeyLocation);){
            ProKey proKey = ProKey.fromJson(Util.toString(is));
            return proKey;
        }
    }

    public static File getVaadinFolder() {
        String userHome = System.getProperty("user.home");
        return new File(userHome, ".vaadin");
    }

    public static File getLocation() {
        return new File(LocalProKey.getVaadinFolder(), "proKey");
    }

    public static ProKey get() {
        ProKey proKey = LocalProKey.getSystemProperty();
        if (proKey != null) {
            LocalProKey.getLogger().debug("Using proKey from system property");
            return proKey;
        }
        proKey = LocalProKey.getEnvironmentVariable();
        if (proKey != null) {
            LocalProKey.getLogger().debug("Using proKey from environment variable");
            return proKey;
        }
        File proKeyLocation = LocalProKey.getLocation();
        try {
            proKey = LocalProKey.read(proKeyLocation);
            if (proKey != null) {
                LocalProKey.getLogger().debug("Found proKey in " + proKeyLocation);
            }
            return proKey;
        }
        catch (IOException e) {
            LocalProKey.getLogger().debug("Unable to read proKey", (Throwable)e);
            return null;
        }
    }

    private static ProKey getSystemProperty() {
        String value = System.getProperty("vaadin.proKey");
        if (value == null) {
            return null;
        }
        String[] parts = value.split("/");
        if (parts.length != 2) {
            LocalProKey.getLogger().warn("Unable to read pro key from the vaadin.proKey system property. The property must be of type -Dvaadin.proKey=[vaadin.com login email]/[prokey]");
            return null;
        }
        return new ProKey(parts[0], parts[1]);
    }

    private static ProKey getEnvironmentVariable() {
        String value = EnvironmentVariables.get("VAADIN_PRO_KEY");
        if (value == null) {
            return null;
        }
        String[] parts = value.split("/");
        if (parts.length != 2) {
            LocalProKey.getLogger().warn("Unable to read pro key from the VAADIN_PRO_KEY environment variable. The value must be of type VAADIN_PRO_KEY=[vaadin.com login email]/[prokey]");
            return null;
        }
        return new ProKey(parts[0], parts[1]);
    }

    public static void write(ProKey proKey) {
        File proKeyLocation = LocalProKey.getLocation();
        File proKeyDirectory = LocalProKey.getLocation().getParentFile();
        if (!proKeyDirectory.exists()) {
            proKeyDirectory.mkdirs();
        }
        LocalProKey.getLogger().debug("Writing pro key to " + proKeyLocation);
        try (FileWriter writer = new FileWriter(proKeyLocation);){
            writer.write(proKey.toJson());
        }
        catch (IOException e) {
            LocalProKey.getLogger().error("Unable to write key to " + proKeyLocation, (Throwable)e);
        }
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

