package com.vaadin.mpr.core.client;

import java.io.Serializable;

/**
 * Component settings class containing target node id and application id.
 */
public class ComponentSettings implements Serializable {
    private String appId;
    private int nodeId;

    /**
     * Component settings constructor.
     */
    public ComponentSettings() {
    }

    /**
     * Set the Flow application id.
     *
     * @param appId
     *         Flow application id
     */
    public void setAppId(String appId) {
        this.appId = appId;
    }

    /**
     * Set the node id of the wrapping node.
     *
     * @param nodeId
     *         wrapper node id
     */
    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    /**
     * Get the Flow application id.
     *
     * @return target application id
     */
    public String getAppId() {
        return appId;
    }

    /**
     * Get wrapper element node id.
     *
     * @return wrapper node id
     */
    public int getNodeId() {
        return nodeId;
    }
}
