/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 5806 $
//  type=root
//  date=$Date: 2011-05-02 14:42:02 -0400 (Mon, 02 May 2011) $


/**
 * Localized names for the "eo" locale.
 */
public class LocalizedNamesImpl_eo extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AS",
        "AU",
        "AT",
        "AX",
        "AZ",
        "BS",
        "BD",
        "BB",
        "BH",
        "PW",
        "BE",
        "BZ",
        "BY",
        "BJ",
        "BM",
        "BL",
        "BW",
        "BO",
        "BA",
        "BQ",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "BV",
        "TD",
        "CC",
        "CD",
        "CZ",
        "CF",
        "CL",
        "CN",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DO",
        "DM",
        "EA",
        "CI",
        "EG",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "GF",
        "PF",
        "FR",
        "GA",
        "GM",
        "GH",
        "DE",
        "GG",
        "GI",
        "DJ",
        "GR",
        "GD",
        "GL",
        "GY",
        "GP",
        "GU",
        "GT",
        "GN",
        "GW",
        "HT",
        "HM",
        "IN",
        "ES",
        "HK",
        "HN",
        "HU",
        "IC",
        "IM",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "YE",
        "JO",
        "CV",
        "KH",
        "CM",
        "CA",
        "GE",
        "QA",
        "KZ",
        "KY",
        "KE",
        "CY",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "CR",
        "HR",
        "CU",
        "CK",
        "KW",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "YT",
        "MK",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MU",
        "MR",
        "ME",
        "MX",
        "MF",
        "FM",
        "MM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MZ",
        "MS",
        "NA",
        "NR",
        "AN",
        "NL",
        "NP",
        "NG",
        "NE",
        "NI",
        "NU",
        "KP",
        "MP",
        "NF",
        "NO",
        "NC",
        "NZ",
        "EH",
        "OM",
        "PK",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PS",
        "PR",
        "QO",
        "RE",
        "RS",
        "RW",
        "RO",
        "RU",
        "SB",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SC",
        "SN",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "CS",
        "SL",
        "SG",
        "SY",
        "SK",
        "SI",
        "SO",
        "LK",
        "SS",
        "ZA",
        "SD",
        "GS",
        "KR",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "SX",
        "TA",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TC",
        "TF",
        "TK",
        "TL",
        "TG",
        "TO",
        "TT",
        "TN",
        "TM",
        "TR",
        "TV",
        "UG",
        "UA",
        "AE",
        "GB",
        "UY",
        "UM",
        "VI",
        "US",
        "UZ",
        "WF",
        "VU",
        "VA",
        "VE",
        "VN",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andoro");
    namesMap.put("AE", "Unuiĝintaj Arabaj Emirlandos");
    namesMap.put("AF", "Afganujo");
    namesMap.put("AG", "Antigvo-Barbudo");
    namesMap.put("AI", "Angvilo");
    namesMap.put("AL", "Albanujo");
    namesMap.put("AM", "Armenujo");
    namesMap.put("AN", "Nederlandaj Antiloj");
    namesMap.put("AO", "Angolo");
    namesMap.put("AQ", "Antarkto");
    namesMap.put("AR", "Argentino");
    namesMap.put("AT", "Aŭstrujo");
    namesMap.put("AU", "Aŭstralio");
    namesMap.put("AW", "Arubo");
    namesMap.put("AZ", "Azerbajĝano");
    namesMap.put("BA", "Bosnio-Hercegovino");
    namesMap.put("BB", "Barbado");
    namesMap.put("BD", "Bangladeŝo");
    namesMap.put("BE", "Belgujo");
    namesMap.put("BF", "Burkino");
    namesMap.put("BG", "Bulgarujo");
    namesMap.put("BH", "Barejno");
    namesMap.put("BI", "Burundo");
    namesMap.put("BJ", "Benino");
    namesMap.put("BM", "Bermudoj");
    namesMap.put("BN", "Brunejo");
    namesMap.put("BO", "Bolivio");
    namesMap.put("BR", "Brazilo");
    namesMap.put("BS", "Bahamoj");
    namesMap.put("BT", "Butano");
    namesMap.put("BW", "Bocvano");
    namesMap.put("BY", "Belorusujo");
    namesMap.put("BZ", "Belizo");
    namesMap.put("CA", "Kanado");
    namesMap.put("CF", "Centr-Afrika Respubliko");
    namesMap.put("CG", "Kongolo");
    namesMap.put("CH", "Svisujo");
    namesMap.put("CI", "Ebur-Bordo");
    namesMap.put("CK", "Kukinsuloj");
    namesMap.put("CL", "Ĉilio");
    namesMap.put("CM", "Kameruno");
    namesMap.put("CN", "Ĉinujo");
    namesMap.put("CO", "Kolombio");
    namesMap.put("CR", "Kostariko");
    namesMap.put("CS", "Serbujo");
    namesMap.put("CU", "Kubo");
    namesMap.put("CV", "Kabo-Verdo");
    namesMap.put("CY", "Kipro");
    namesMap.put("CZ", "Ĉeĥujo");
    namesMap.put("DE", "Germanujo");
    namesMap.put("DJ", "Ĝibutio");
    namesMap.put("DK", "Danujo");
    namesMap.put("DM", "Dominiko");
    namesMap.put("DO", "Domingo");
    namesMap.put("DZ", "Alĝerio");
    namesMap.put("EC", "Ekvadoro");
    namesMap.put("EE", "Estonujo");
    namesMap.put("EG", "Egipto");
    namesMap.put("EH", "Okcidenta Saharo");
    namesMap.put("ER", "Eritreo");
    namesMap.put("ES", "Hispanujo");
    namesMap.put("ET", "Etiopujo");
    namesMap.put("FI", "Finnlando");
    namesMap.put("FJ", "Fiĝoj");
    namesMap.put("FM", "Mikronezio");
    namesMap.put("FO", "Ferooj");
    namesMap.put("FR", "Francujo");
    namesMap.put("GA", "Gabono");
    namesMap.put("GB", "Unuiĝinta Reĝlando");
    namesMap.put("GD", "Grenado");
    namesMap.put("GE", "Kartvelujo");
    namesMap.put("GF", "Franca Gviano");
    namesMap.put("GH", "Ganao");
    namesMap.put("GI", "Ĝibraltaro");
    namesMap.put("GL", "Gronlando");
    namesMap.put("GM", "Gambio");
    namesMap.put("GN", "Gvineo");
    namesMap.put("GP", "Gvadelupo");
    namesMap.put("GQ", "Ekvatora Gvineo");
    namesMap.put("GR", "Grekujo");
    namesMap.put("GS", "Sud-Georgio kaj Sud-Sandviĉinsuloj");
    namesMap.put("GT", "Gvatemalo");
    namesMap.put("GU", "Gvamo");
    namesMap.put("GW", "Gvineo-Bisaŭo");
    namesMap.put("GY", "Gujano");
    namesMap.put("HM", "Herda kaj Makdonaldaj Insuloj");
    namesMap.put("HN", "Honduro");
    namesMap.put("HR", "Kroatujo");
    namesMap.put("HT", "Haitio");
    namesMap.put("HU", "Hungarujo");
    namesMap.put("ID", "Indonezio");
    namesMap.put("IE", "Irlando");
    namesMap.put("IL", "Israelo");
    namesMap.put("IN", "Hindujo");
    namesMap.put("IO", "Brita Hindoceana Teritorio");
    namesMap.put("IQ", "Irako");
    namesMap.put("IR", "Irano");
    namesMap.put("IS", "Islando");
    namesMap.put("IT", "Italujo");
    namesMap.put("JM", "Jamajko");
    namesMap.put("JO", "Jordanio");
    namesMap.put("JP", "Japanujo");
    namesMap.put("KE", "Kenjo");
    namesMap.put("KG", "Kirgizistano");
    namesMap.put("KH", "Kamboĝo");
    namesMap.put("KI", "Kiribato");
    namesMap.put("KM", "Komoroj");
    namesMap.put("KN", "Sent-Kristofo kaj Neviso");
    namesMap.put("KP", "Nord-Koreo");
    namesMap.put("KR", "Sud-Koreo");
    namesMap.put("KW", "Kuvajto");
    namesMap.put("KY", "Kejmanoj");
    namesMap.put("KZ", "Kazaĥstano");
    namesMap.put("LA", "Laoso");
    namesMap.put("LB", "Libano");
    namesMap.put("LC", "Sent-Lucio");
    namesMap.put("LI", "Liĥtenŝtejno");
    namesMap.put("LK", "Sri-Lanko");
    namesMap.put("LR", "Liberio");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litovujo");
    namesMap.put("LU", "Luksemburgo");
    namesMap.put("LV", "Latvujo");
    namesMap.put("LY", "Libio");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldavujo");
    namesMap.put("MG", "Madagaskaro");
    namesMap.put("MH", "Marŝaloj");
    namesMap.put("MK", "Makedonujo");
    namesMap.put("ML", "Malio");
    namesMap.put("MM", "Mjanmao");
    namesMap.put("MN", "Mongolujo");
    namesMap.put("MP", "Nord-Marianoj");
    namesMap.put("MQ", "Martiniko");
    namesMap.put("MR", "Maŭritanujo");
    namesMap.put("MT", "Malto");
    namesMap.put("MU", "Maŭricio");
    namesMap.put("MV", "Maldivoj");
    namesMap.put("MW", "Malavio");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malajzio");
    namesMap.put("MZ", "Mozambiko");
    namesMap.put("NA", "Namibio");
    namesMap.put("NC", "Nov-Kaledonio");
    namesMap.put("NE", "Niĝero");
    namesMap.put("NF", "Norfolkinsulo");
    namesMap.put("NG", "Niĝerio");
    namesMap.put("NI", "Nikaragvo");
    namesMap.put("NL", "Nederlando");
    namesMap.put("NO", "Norvegujo");
    namesMap.put("NP", "Nepalo");
    namesMap.put("NR", "Nauro");
    namesMap.put("NU", "Niuo");
    namesMap.put("NZ", "Nov-Zelando");
    namesMap.put("OM", "Omano");
    namesMap.put("PA", "Panamo");
    namesMap.put("PE", "Peruo");
    namesMap.put("PF", "Franca Polinezio");
    namesMap.put("PG", "Papuo-Nov-Gvineo");
    namesMap.put("PH", "Filipinoj");
    namesMap.put("PK", "Pakistano");
    namesMap.put("PL", "Pollando");
    namesMap.put("PM", "Sent-Piero kaj Mikelono");
    namesMap.put("PN", "Pitkarna Insulo");
    namesMap.put("PR", "Puerto-Riko");
    namesMap.put("PT", "Portugalujo");
    namesMap.put("PW", "Belaŭo");
    namesMap.put("PY", "Paragvajo");
    namesMap.put("QA", "Kataro");
    namesMap.put("RE", "Reunio");
    namesMap.put("RO", "Rumanujo");
    namesMap.put("RU", "Rusujo");
    namesMap.put("RW", "Ruando");
    namesMap.put("SA", "Saŭda Arabujo");
    namesMap.put("SB", "Salomonoj");
    namesMap.put("SC", "Sejŝeloj");
    namesMap.put("SD", "Sudano");
    namesMap.put("SE", "Svedujo");
    namesMap.put("SG", "Singapuro");
    namesMap.put("SH", "Sent-Heleno");
    namesMap.put("SI", "Slovenujo");
    namesMap.put("SJ", "Svalbardo kaj Jan-Majen-insulo");
    namesMap.put("SK", "Slovakujo");
    namesMap.put("SL", "Siera-Leono");
    namesMap.put("SM", "San-Marino");
    namesMap.put("SN", "Senegalo");
    namesMap.put("SO", "Somalujo");
    namesMap.put("SR", "Surinamo");
    namesMap.put("ST", "Sao-Tomeo kaj Principeo");
    namesMap.put("SV", "Salvadoro");
    namesMap.put("SY", "Sirio");
    namesMap.put("SZ", "Svazilando");
    namesMap.put("TD", "Ĉado");
    namesMap.put("TG", "Togolo");
    namesMap.put("TH", "Tajlando");
    namesMap.put("TJ", "Taĝikujo");
    namesMap.put("TM", "Turkmenujo");
    namesMap.put("TN", "Tunizio");
    namesMap.put("TO", "Tongo");
    namesMap.put("TR", "Turkujo");
    namesMap.put("TT", "Trinidado kaj Tobago");
    namesMap.put("TV", "Tuvalo");
    namesMap.put("TW", "Tajvano");
    namesMap.put("TZ", "Tanzanio");
    namesMap.put("UA", "Ukrajno");
    namesMap.put("UG", "Ugando");
    namesMap.put("UM", "Usonaj malgrandaj insuloj");
    namesMap.put("US", "Usono");
    namesMap.put("UY", "Urugvajo");
    namesMap.put("UZ", "Uzbekujo");
    namesMap.put("VA", "Vatikano");
    namesMap.put("VC", "Sent-Vincento kaj la Grenadinoj");
    namesMap.put("VE", "Venezuelo");
    namesMap.put("VG", "Britaj Virgulininsuloj");
    namesMap.put("VI", "Usonaj Virgulininsuloj");
    namesMap.put("VN", "Vjetnamo");
    namesMap.put("VU", "Vanuatuo");
    namesMap.put("WF", "Valiso kaj Futuno");
    namesMap.put("WS", "Samoo");
    namesMap.put("YE", "Jemeno");
    namesMap.put("YT", "Majoto");
    namesMap.put("ZA", "Sud-Afriko");
    namesMap.put("ZM", "Zambio");
    namesMap.put("ZW", "Zimbabvo");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andoro",
        "AE": "Unuiĝintaj Arabaj Emirlandos",
        "AF": "Afganujo",
        "AG": "Antigvo-Barbudo",
        "AI": "Angvilo",
        "AL": "Albanujo",
        "AM": "Armenujo",
        "AN": "Nederlandaj Antiloj",
        "AO": "Angolo",
        "AQ": "Antarkto",
        "AR": "Argentino",
        "AT": "Aŭstrujo",
        "AU": "Aŭstralio",
        "AW": "Arubo",
        "AZ": "Azerbajĝano",
        "BA": "Bosnio-Hercegovino",
        "BB": "Barbado",
        "BD": "Bangladeŝo",
        "BE": "Belgujo",
        "BF": "Burkino",
        "BG": "Bulgarujo",
        "BH": "Barejno",
        "BI": "Burundo",
        "BJ": "Benino",
        "BM": "Bermudoj",
        "BN": "Brunejo",
        "BO": "Bolivio",
        "BR": "Brazilo",
        "BS": "Bahamoj",
        "BT": "Butano",
        "BW": "Bocvano",
        "BY": "Belorusujo",
        "BZ": "Belizo",
        "CA": "Kanado",
        "CF": "Centr-Afrika Respubliko",
        "CG": "Kongolo",
        "CH": "Svisujo",
        "CI": "Ebur-Bordo",
        "CK": "Kukinsuloj",
        "CL": "Ĉilio",
        "CM": "Kameruno",
        "CN": "Ĉinujo",
        "CO": "Kolombio",
        "CR": "Kostariko",
        "CS": "Serbujo",
        "CU": "Kubo",
        "CV": "Kabo-Verdo",
        "CY": "Kipro",
        "CZ": "Ĉeĥujo",
        "DE": "Germanujo",
        "DJ": "Ĝibutio",
        "DK": "Danujo",
        "DM": "Dominiko",
        "DO": "Domingo",
        "DZ": "Alĝerio",
        "EC": "Ekvadoro",
        "EE": "Estonujo",
        "EG": "Egipto",
        "EH": "Okcidenta Saharo",
        "ER": "Eritreo",
        "ES": "Hispanujo",
        "ET": "Etiopujo",
        "FI": "Finnlando",
        "FJ": "Fiĝoj",
        "FM": "Mikronezio",
        "FO": "Ferooj",
        "FR": "Francujo",
        "GA": "Gabono",
        "GB": "Unuiĝinta Reĝlando",
        "GD": "Grenado",
        "GE": "Kartvelujo",
        "GF": "Franca Gviano",
        "GH": "Ganao",
        "GI": "Ĝibraltaro",
        "GL": "Gronlando",
        "GM": "Gambio",
        "GN": "Gvineo",
        "GP": "Gvadelupo",
        "GQ": "Ekvatora Gvineo",
        "GR": "Grekujo",
        "GS": "Sud-Georgio kaj Sud-Sandviĉinsuloj",
        "GT": "Gvatemalo",
        "GU": "Gvamo",
        "GW": "Gvineo-Bisaŭo",
        "GY": "Gujano",
        "HM": "Herda kaj Makdonaldaj Insuloj",
        "HN": "Honduro",
        "HR": "Kroatujo",
        "HT": "Haitio",
        "HU": "Hungarujo",
        "ID": "Indonezio",
        "IE": "Irlando",
        "IL": "Israelo",
        "IN": "Hindujo",
        "IO": "Brita Hindoceana Teritorio",
        "IQ": "Irako",
        "IR": "Irano",
        "IS": "Islando",
        "IT": "Italujo",
        "JM": "Jamajko",
        "JO": "Jordanio",
        "JP": "Japanujo",
        "KE": "Kenjo",
        "KG": "Kirgizistano",
        "KH": "Kamboĝo",
        "KI": "Kiribato",
        "KM": "Komoroj",
        "KN": "Sent-Kristofo kaj Neviso",
        "KP": "Nord-Koreo",
        "KR": "Sud-Koreo",
        "KW": "Kuvajto",
        "KY": "Kejmanoj",
        "KZ": "Kazaĥstano",
        "LA": "Laoso",
        "LB": "Libano",
        "LC": "Sent-Lucio",
        "LI": "Liĥtenŝtejno",
        "LK": "Sri-Lanko",
        "LR": "Liberio",
        "LS": "Lesoto",
        "LT": "Litovujo",
        "LU": "Luksemburgo",
        "LV": "Latvujo",
        "LY": "Libio",
        "MA": "Maroko",
        "MC": "Monako",
        "MD": "Moldavujo",
        "MG": "Madagaskaro",
        "MH": "Marŝaloj",
        "MK": "Makedonujo",
        "ML": "Malio",
        "MM": "Mjanmao",
        "MN": "Mongolujo",
        "MP": "Nord-Marianoj",
        "MQ": "Martiniko",
        "MR": "Maŭritanujo",
        "MT": "Malto",
        "MU": "Maŭricio",
        "MV": "Maldivoj",
        "MW": "Malavio",
        "MX": "Meksiko",
        "MY": "Malajzio",
        "MZ": "Mozambiko",
        "NA": "Namibio",
        "NC": "Nov-Kaledonio",
        "NE": "Niĝero",
        "NF": "Norfolkinsulo",
        "NG": "Niĝerio",
        "NI": "Nikaragvo",
        "NL": "Nederlando",
        "NO": "Norvegujo",
        "NP": "Nepalo",
        "NR": "Nauro",
        "NU": "Niuo",
        "NZ": "Nov-Zelando",
        "OM": "Omano",
        "PA": "Panamo",
        "PE": "Peruo",
        "PF": "Franca Polinezio",
        "PG": "Papuo-Nov-Gvineo",
        "PH": "Filipinoj",
        "PK": "Pakistano",
        "PL": "Pollando",
        "PM": "Sent-Piero kaj Mikelono",
        "PN": "Pitkarna Insulo",
        "PR": "Puerto-Riko",
        "PT": "Portugalujo",
        "PW": "Belaŭo",
        "PY": "Paragvajo",
        "QA": "Kataro",
        "RE": "Reunio",
        "RO": "Rumanujo",
        "RU": "Rusujo",
        "RW": "Ruando",
        "SA": "Saŭda Arabujo",
        "SB": "Salomonoj",
        "SC": "Sejŝeloj",
        "SD": "Sudano",
        "SE": "Svedujo",
        "SG": "Singapuro",
        "SH": "Sent-Heleno",
        "SI": "Slovenujo",
        "SJ": "Svalbardo kaj Jan-Majen-insulo",
        "SK": "Slovakujo",
        "SL": "Siera-Leono",
        "SM": "San-Marino",
        "SN": "Senegalo",
        "SO": "Somalujo",
        "SR": "Surinamo",
        "ST": "Sao-Tomeo kaj Principeo",
        "SV": "Salvadoro",
        "SY": "Sirio",
        "SZ": "Svazilando",
        "TD": "Ĉado",
        "TG": "Togolo",
        "TH": "Tajlando",
        "TJ": "Taĝikujo",
        "TM": "Turkmenujo",
        "TN": "Tunizio",
        "TO": "Tongo",
        "TR": "Turkujo",
        "TT": "Trinidado kaj Tobago",
        "TV": "Tuvalo",
        "TW": "Tajvano",
        "TZ": "Tanzanio",
        "UA": "Ukrajno",
        "UG": "Ugando",
        "UM": "Usonaj malgrandaj insuloj",
        "US": "Usono",
        "UY": "Urugvajo",
        "UZ": "Uzbekujo",
        "VA": "Vatikano",
        "VC": "Sent-Vincento kaj la Grenadinoj",
        "VE": "Venezuelo",
        "VG": "Britaj Virgulininsuloj",
        "VI": "Usonaj Virgulininsuloj",
        "VN": "Vjetnamo",
        "VU": "Vanuatuo",
        "WF": "Valiso kaj Futuno",
        "WS": "Samoo",
        "YE": "Jemeno",
        "YT": "Majoto",
        "ZA": "Sud-Afriko",
        "ZM": "Zambio",
        "ZW": "Zimbabvo"
    };
  }-*/;
}
