/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $
//  type=root


/**
 * Localized names for the "ml" locale.
 */
public class LocalizedNamesImpl_ml extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "BQ",
        "CW",
        "SS",
        "SX",
        "AO",
        "AQ",
        "AD",
        "AF",
        "US",
        "AS",
        "IE",
        "AR",
        "AM",
        "AW",
        "AX",
        "AL",
        "DZ",
        "AC",
        "AZ",
        "AI",
        "AG",
        "EC",
        "GQ",
        "ID",
        "IN",
        "IQ",
        "IR",
        "IT",
        "IL",
        "EG",
        "UA",
        "UG",
        "KP",
        "MP",
        "UY",
        "UZ",
        "ET",
        "ER",
        "SV",
        "EE",
        "IM",
        "CI",
        "IS",
        "OM",
        "AT",
        "AU",
        "KH",
        "KZ",
        "CA",
        "IC",
        "CM",
        "KI",
        "KG",
        "TL",
        "KW",
        "CK",
        "KE",
        "CV",
        "KY",
        "CO",
        "CD",
        "CG",
        "CC",
        "KM",
        "CR",
        "CU",
        "CX",
        "HR",
        "CP",
        "QA",
        "GY",
        "GM",
        "GA",
        "GW",
        "GP",
        "GG",
        "GD",
        "GL",
        "GR",
        "GU",
        "GT",
        "GN",
        "GH",
        "TD",
        "CL",
        "CZ",
        "CN",
        "JP",
        "JM",
        "DE",
        "DJ",
        "GI",
        "JE",
        "GE",
        "JO",
        "TC",
        "TZ",
        "TN",
        "TK",
        "TO",
        "TG",
        "TA",
        "TT",
        "DG",
        "DK",
        "DM",
        "DO",
        "TJ",
        "TH",
        "TW",
        "TR",
        "TM",
        "TV",
        "KR",
        "GS",
        "ZA",
        "NA",
        "NI",
        "NL",
        "AN",
        "NP",
        "NE",
        "NG",
        "NF",
        "NO",
        "NU",
        "NZ",
        "NR",
        "PA",
        "PG",
        "PY",
        "PW",
        "EH",
        "PK",
        "PS",
        "PN",
        "NC",
        "QO",
        "PE",
        "PT",
        "PR",
        "PL",
        "FO",
        "FK",
        "FJ",
        "FI",
        "PH",
        "GF",
        "TF",
        "PF",
        "FR",
        "BD",
        "BM",
        "BG",
        "BS",
        "BH",
        "BB",
        "BF",
        "BI",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BO",
        "BW",
        "BA",
        "BR",
        "GB",
        "IO",
        "VG",
        "BN",
        "BV",
        "BT",
        "MN",
        "MO",
        "MG",
        "YT",
        "MW",
        "MY",
        "MD",
        "MQ",
        "MH",
        "ML",
        "MV",
        "MT",
        "MK",
        "MX",
        "FM",
        "MC",
        "MA",
        "MZ",
        "ME",
        "MS",
        "MM",
        "MR",
        "MU",
        "YE",
        "VI",
        "UM",
        "EU",
        "RU",
        "RE",
        "RO",
        "RW",
        "LU",
        "LB",
        "LV",
        "LA",
        "LT",
        "LY",
        "LS",
        "LI",
        "LR",
        "VA",
        "VU",
        "WF",
        "VN",
        "VE",
        "LK",
        "AE",
        "ZM",
        "SM",
        "WS",
        "ST",
        "SG",
        "ZW",
        "SL",
        "SY",
        "SD",
        "SR",
        "SN",
        "CF",
        "PM",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "EA",
        "KN",
        "SC",
        "RS",
        "CS",
        "CY",
        "SO",
        "SB",
        "ES",
        "SK",
        "SI",
        "SJ",
        "SZ",
        "CH",
        "SE",
        "SA",
        "HU",
        "HM",
        "HT",
        "HK",
        "HN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ലോകം");
    namesMap.put("002", "ആഫ്രിക്ക");
    namesMap.put("003", "വടക്കേ അമേരിക്കന്‍ ഭൂഖണ്ഡം");
    namesMap.put("005", "തെക്കേ അമേരിക്കന്‍ ഭൂഖണ്ഡം");
    namesMap.put("009", "ഓഷ്യാനിയ");
    namesMap.put("011", "പശ്ചിമ ആഫ്രിക്ക");
    namesMap.put("013", "മദ്ധ്യഅമേരിക്ക");
    namesMap.put("014", "കിഴക്കന്‍ ആഫ്രിക്ക");
    namesMap.put("015", "വടക്കേ ആഫ്രിക്ക");
    namesMap.put("017", "മദ്ധ്യആഫ്രിക്ക");
    namesMap.put("018", "തെക്കേ ആഫ്രിക്ക");
    namesMap.put("019", "അമേരിക്കന്‍ ഭൂഖണ്ഡം");
    namesMap.put("021", "വടക്കേ അമേരിക്ക");
    namesMap.put("029", "കരീബിയന്‍");
    namesMap.put("030", "കിഴക്കന്‍ ഏഷ്യ");
    namesMap.put("034", "തെക്കേ ഏഷ്യ");
    namesMap.put("035", "തെക്ക്-കിഴക്കന്‍ ഏഷ്യ");
    namesMap.put("039", "തെക്കേ യൂറോപ്പ്");
    namesMap.put("053", "ഓസ്ട്രേലിയയും ന്യൂസിലാന്‍ഡും");
    namesMap.put("054", "മെലനേഷ്യ");
    namesMap.put("057", "മൈക്രോനേഷ്യന്‍ പ്രദേശം");
    namesMap.put("061", "പോളിനേഷ്യ");
    namesMap.put("142", "ഏഷ്യ");
    namesMap.put("143", "മദ്ധ്യേഷ്യ");
    namesMap.put("145", "പശ്ചിമേഷ്യ");
    namesMap.put("150", "യൂറോപ്പ്");
    namesMap.put("151", "കിഴക്കന്‍ യൂറോപ്പ്");
    namesMap.put("154", "വടക്കേ യൂറോപ്പ്");
    namesMap.put("155", "പശ്ചിമ യൂറോപ്പ്");
    namesMap.put("419", "ലാറ്റിനമേരിക്കയും കരീബിയനും");
    namesMap.put("AC", "അസന്‍ഷന്‍ ദ്വീപ്");
    namesMap.put("AD", "അന്‍റോറ");
    namesMap.put("AE", "സംയുക്ത അറബ് രാഷ്ട്രം");
    namesMap.put("AF", "അഫ്ഗാനിസ്ഥാന്‍");
    namesMap.put("AG", "ആന്‍റിഗ്വയും ബര്‍ബുഡയും");
    namesMap.put("AI", "ആന്‍ഗ്വില്ല");
    namesMap.put("AL", "അല്‍ബേനിയ");
    namesMap.put("AM", "അര്‍മേനിയ");
    namesMap.put("AN", "നെതര്‍ലന്‍ഡ്സ് ആന്‍റിലിസ്");
    namesMap.put("AO", "അംഗോള");
    namesMap.put("AQ", "അന്‍റാര്‍ട്ടിക്ക");
    namesMap.put("AR", "അര്‍ജന്‍റീന");
    namesMap.put("AS", "അമേരിക്കന്‍ സാമോവ");
    namesMap.put("AT", "ഓസ്ട്രിയ");
    namesMap.put("AU", "ഓസ്ട്രേലിയ");
    namesMap.put("AW", "അറുബ");
    namesMap.put("AX", "അലന്‍ഡ് ദ്വീപുകള്‍");
    namesMap.put("AZ", "അസര്‍ബൈജാന്‍");
    namesMap.put("BA", "ബോസ്നിയയും ഹെര്‍സഗോവിനയും");
    namesMap.put("BB", "ബാര്‍ബഡോസ്");
    namesMap.put("BD", "ബംഗ്ലാദേശ്");
    namesMap.put("BE", "ബെല്‍ജിയം");
    namesMap.put("BF", "ബുര്‍ക്കിനാ ഫാസോ");
    namesMap.put("BG", "ബള്‍ഗേറിയ");
    namesMap.put("BH", "ബഹ്റൈന്‍");
    namesMap.put("BI", "ബുറുണ്ടി");
    namesMap.put("BJ", "ബെനിന്‍");
    namesMap.put("BL", "സെന്‍റ് ബാര്‍ത്തെല്‍മി");
    namesMap.put("BM", "ബര്‍മുഡ");
    namesMap.put("BN", "ബ്രൂണൈ");
    namesMap.put("BO", "ബൊളീവിയ");
    namesMap.put("BR", "ബ്രസീല്‍");
    namesMap.put("BS", "ബഹാമാസ്");
    namesMap.put("BT", "ഭൂട്ടാന്‍");
    namesMap.put("BV", "ബൗവെറ്റ് ദ്വീപ്");
    namesMap.put("BW", "ബോട്സ്വാന");
    namesMap.put("BY", "ബെലറൂസ്");
    namesMap.put("BZ", "ബെലീസ്");
    namesMap.put("CA", "കാനഡ");
    namesMap.put("CC", "കോക്കസ്");
    namesMap.put("CD", "കോംഗോ - കിന്‍ഷാസ");
    namesMap.put("CF", "സെന്‍ട്രല്‍ ആഫ്രിക്കന്‍ റിപ്പബ്ലിക്");
    namesMap.put("CG", "കോംഗോ - ബ്രാസാവില്‍");
    namesMap.put("CH", "സ്വിറ്റ്സര്‍ലാന്‍ഡ്");
    namesMap.put("CI", "ഐവറി കോസ്റ്റ്");
    namesMap.put("CK", "കൂക്ക് ദ്വീപുകള്‍");
    namesMap.put("CL", "ചിലി");
    namesMap.put("CM", "കാമറൂണ്‍");
    namesMap.put("CN", "ചൈന");
    namesMap.put("CO", "കൊളംബിയ");
    namesMap.put("CP", "ക്ലിപ്പെര്‍ട്ടന്‍ ദ്വീപ്");
    namesMap.put("CR", "കോസ്റ്ററിക്ക");
    namesMap.put("CS", "സെര്‍ബിയയും മോണ്ടനേഗ്രോയും");
    namesMap.put("CU", "ക്യൂബ");
    namesMap.put("CV", "കേപ്പ് വെര്‍ഡെ");
    namesMap.put("CX", "ക്രിസ്മസ് ദ്വീപ്");
    namesMap.put("CY", "സൈപ്രസ്സ്");
    namesMap.put("CZ", "ചെക്ക് റിപ്പബ്ലിക്");
    namesMap.put("DE", "ജര്‍മനി");
    namesMap.put("DG", "ഡീഗോ ഗ്രാഷ്യ");
    namesMap.put("DJ", "ജിബൂട്ടി");
    namesMap.put("DK", "ഡെന്‍മാര്‍ക്ക്");
    namesMap.put("DM", "ഡൊമിനിക്ക");
    namesMap.put("DO", "ഡൊമിനിക്കന്‍ റിപ്പബ്ലിക്");
    namesMap.put("DZ", "അള്‍ജീരിയ");
    namesMap.put("EA", "സെയൂത്ത ആന്‍ഡ് മെലിയ");
    namesMap.put("EC", "ഇക്വഡോര്‍");
    namesMap.put("EE", "എസ്റ്റോണിയ‍");
    namesMap.put("EG", "ഈജിപ്ത്");
    namesMap.put("EH", "പശ്ചിമ സഹാറ");
    namesMap.put("ER", "എറിത്രിയ");
    namesMap.put("ES", "സ്പെയിന്‍");
    namesMap.put("ET", "എത്യോപ്യ");
    namesMap.put("EU", "യൂറോപ്യന്‍ യൂണിയന്‍");
    namesMap.put("FI", "ഫിന്‍ലാന്‍ഡ്");
    namesMap.put("FJ", "ഫിജി");
    namesMap.put("FK", "ഫാക്ക്‌ലാന്റ് ഐലന്റ്");
    namesMap.put("FM", "മൈക്രോനേഷ്യ");
    namesMap.put("FO", "ഫറോയി ദ്വീപുകള്‍");
    namesMap.put("FR", "ഫ്രാന്‍സ്");
    namesMap.put("GA", "ഗാബോണ്‍");
    namesMap.put("GB", "ബ്രിട്ടന്‍");
    namesMap.put("GD", "ഗ്രനേഡ");
    namesMap.put("GE", "ജോര്‍ജിയ");
    namesMap.put("GF", "ഫ്രഞ്ച് ഗയാന");
    namesMap.put("GG", "ഗേണ്‍സി");
    namesMap.put("GH", "ഘാന");
    namesMap.put("GI", "ജിബ്രാള്‍ട്ടര്‍");
    namesMap.put("GL", "ഗ്രീന്‍ലാന്‍റ്");
    namesMap.put("GM", "ഗാംബിയ");
    namesMap.put("GN", "ഗ്വിനിയ");
    namesMap.put("GP", "ഗുവാഡെലോപ്");
    namesMap.put("GQ", "ഇക്വിറ്റോറിയല്‍ ഗ്വിനിയ");
    namesMap.put("GR", "ഗ്രീസ്");
    namesMap.put("GS", "ദക്ഷിണ ജോര്‍ജ്ജിയയും ദക്ഷിണ സാന്‍ഡ്‌വിച്ച് ദ്വീപുകളും");
    namesMap.put("GT", "ഗ്വാട്ടിമാലാ");
    namesMap.put("GU", "ഗ്വാം");
    namesMap.put("GW", "ഗിനി-ബിസോ");
    namesMap.put("GY", "ഗയാന");
    namesMap.put("HK", "ഹോങ് കോങ്");
    namesMap.put("HM", "ഹിയേര്‍ഡ് ദ്വീപും മക്ഡൊണാള്ഡ് ദ്വീപുകളും");
    namesMap.put("HN", "ഹോണ്ടുറാസ്");
    namesMap.put("HR", "ക്രൊയേഷ്യ");
    namesMap.put("HT", "ഹെയ്തി");
    namesMap.put("HU", "ഹംഗറി");
    namesMap.put("IC", "കാനറി ദ്വീപുകള്‍");
    namesMap.put("ID", "ഇന്‍ഡോനേഷ്യ");
    namesMap.put("IE", "അയര്‍ലാന്‍ഡ്");
    namesMap.put("IL", "ഇസ്രായേല്‍");
    namesMap.put("IM", "ഐല്‍ ഓഫ് മാന്‍");
    namesMap.put("IN", "ഇന്ത്യ");
    namesMap.put("IO", "ബ്രിട്ടീഷ് ഇന്ത്യന്‍ മഹാസമുദ്ര പ്രദേശം");
    namesMap.put("IQ", "ഇറാക്ക്");
    namesMap.put("IR", "ഇറാന്‍");
    namesMap.put("IS", "ഐസ്‌ലാന്റ്");
    namesMap.put("IT", "ഇറ്റലി");
    namesMap.put("JE", "ജേഴ്സി");
    namesMap.put("JM", "ജമൈക്ക");
    namesMap.put("JO", "ജോര്‍ദ്ദാന്‍");
    namesMap.put("JP", "ജപ്പാന്‍");
    namesMap.put("KE", "കെനിയ");
    namesMap.put("KG", "കിര്‍ഗിസ്ഥാന്‍");
    namesMap.put("KH", "കംബോഡിയ");
    namesMap.put("KI", "കിരിബാത്തി");
    namesMap.put("KM", "കോമറോസ്");
    namesMap.put("KN", "സെയ്ന്‍റ് കിറ്റ്സും നെവിസും");
    namesMap.put("KP", "ഉത്തരകൊറിയ");
    namesMap.put("KR", "ദക്ഷിണകൊറിയ");
    namesMap.put("KW", "കുവൈറ്റ്");
    namesMap.put("KY", "കേയ്മാന്‍ ദ്വീപുകള്‍");
    namesMap.put("KZ", "കസാഖിസ്ഥാന്‍");
    namesMap.put("LA", "ലാവോസ്");
    namesMap.put("LB", "ലബനോണ്‍");
    namesMap.put("LC", "സെന്‍റ് ലൂസിയ");
    namesMap.put("LI", "ലൈച്ടെസ്റ്റിന്‍");
    namesMap.put("LK", "ശ്രീലങ്ക");
    namesMap.put("LR", "ലൈബീരിയ");
    namesMap.put("LS", "ലെസോത്തോ");
    namesMap.put("LT", "ലിത്വാനിയ");
    namesMap.put("LU", "ലക്സംബര്‍ഗ്");
    namesMap.put("LV", "ലാത്വിയ");
    namesMap.put("LY", "ലിബിയ");
    namesMap.put("MA", "മൊറോക്കൊ");
    namesMap.put("MC", "മൊണോക്കൊ");
    namesMap.put("MD", "മള്‍ഡോവ");
    namesMap.put("ME", "മോണ്ടേനേഗ്രോ");
    namesMap.put("MF", "സെന്‍റ് മാര്‍ട്ടിന്‍");
    namesMap.put("MG", "മഡഗാസ്കര്‍");
    namesMap.put("MH", "മാര്‍ഷല്‍‍‍ ദ്വീപുകള്‍");
    namesMap.put("MK", "മാസിഡോണിയ");
    namesMap.put("ML", "മാലി");
    namesMap.put("MM", "മ്യാന്‍മാര്‍");
    namesMap.put("MN", "മംഗോളിയ");
    namesMap.put("MO", "മക്കാവോ");
    namesMap.put("MP", "ഉത്തര മറിയാനാ ദ്വീപുകള്‍");
    namesMap.put("MQ", "മാര്‍ട്ടീനിക്");
    namesMap.put("MR", "മൗറിറ്റാനിയ");
    namesMap.put("MS", "മോണ്ട്സെറാറ്റ്");
    namesMap.put("MT", "മാള്‍ട്ട");
    namesMap.put("MU", "മൗറീഷ്യസ്");
    namesMap.put("MV", "മാലിദ്വീപ്");
    namesMap.put("MW", "മലാവി");
    namesMap.put("MX", "മെക്സിക്കോ");
    namesMap.put("MY", "മലേഷ്യ");
    namesMap.put("MZ", "മൊസാംബിക്ക്");
    namesMap.put("NA", "നമീബിയ");
    namesMap.put("NC", "പുതിയ കാലിഡോണിയ");
    namesMap.put("NE", "നൈജര്‍");
    namesMap.put("NF", "നോര്‍ഫോക് ദ്വീപ്");
    namesMap.put("NG", "നൈജീരിയ");
    namesMap.put("NI", "നിക്കാരഗ്വ");
    namesMap.put("NL", "നെതര്‍ലന്‍ഡ്സ്");
    namesMap.put("NO", "നോര്‍വെ");
    namesMap.put("NP", "നേപ്പാള്‍");
    namesMap.put("NR", "നൗറൂ");
    namesMap.put("NU", "ന്യൂവേ");
    namesMap.put("NZ", "ന്യൂസിലാന്‍റ്");
    namesMap.put("OM", "ഒമാന്‍");
    namesMap.put("PA", "പനാമ");
    namesMap.put("PE", "പെറു");
    namesMap.put("PF", "ഫ്രഞ്ച് പോളിനേഷ്യ");
    namesMap.put("PG", "പപ്പുവ ന്യൂ ഗ്വിനി");
    namesMap.put("PH", "ഫിലിപ്പൈന്‍സ്");
    namesMap.put("PK", "പാക്കിസ്ഥാന്‍");
    namesMap.put("PL", "പോളണ്ട്");
    namesMap.put("PM", "സെന്‍റ് പിറേയും മിക്വലണും");
    namesMap.put("PN", "പിറ്റ്കെയ്ന്‍");
    namesMap.put("PR", "പോര്‍ട്ടോ റിക്കോ");
    namesMap.put("PS", "പാലസ്തീന്‍ പ്രദേശങ്ങള്‍");
    namesMap.put("PT", "പോര്‍ച്ചുഗല്‍");
    namesMap.put("PW", "പലാവു");
    namesMap.put("PY", "പരാഗ്വേ");
    namesMap.put("QA", "ഖത്തര്‍");
    namesMap.put("QO", "പുറംദ്വീപുകള്‍");
    namesMap.put("RE", "റീയൂണിയന്‍");
    namesMap.put("RO", "റുമേനിയ");
    namesMap.put("RS", "സെര്‍ബിയ");
    namesMap.put("RU", "റഷ്യ");
    namesMap.put("RW", "റുവാണ്ട");
    namesMap.put("SA", "സൗദി അറേബ്യ");
    namesMap.put("SB", "സോളമന്‍‍ ദ്വീപുകള്‍");
    namesMap.put("SC", "സെയ്ഷെല്‍സ്");
    namesMap.put("SD", "സുഡാന്‍");
    namesMap.put("SE", "സ്വീഡന്‍");
    namesMap.put("SG", "സിംഗപ്പുര്‍");
    namesMap.put("SH", "സെന്‍റ് ഹെലീന");
    namesMap.put("SI", "സ്ലോവേനിയ");
    namesMap.put("SJ", "സ്വാല്‍ബാഡും ജാന്‍ മായേനും");
    namesMap.put("SK", "സ്ലോവാക്യ");
    namesMap.put("SL", "സിയേറാ ലിയോണ്‍");
    namesMap.put("SM", "സാന്‍ മറിനോ");
    namesMap.put("SN", "സെനഗല്‍");
    namesMap.put("SO", "സോമാലിയ");
    namesMap.put("SR", "സുറിനാം");
    namesMap.put("ST", "സാവോ റ്റമെ ആന്‍ഡ് പ്രിന്‍സിപ്പി");
    namesMap.put("SV", "എല്‍ സാല്‍വദോര്‍");
    namesMap.put("SY", "സിറിയ");
    namesMap.put("SZ", "സ്വാസിലാന്‍റ്");
    namesMap.put("TA", "ട്രസ്റ്റന്‍ ഡ കൂന");
    namesMap.put("TC", "ടര്‍ക്ക്സും കൈക്കോ ദ്വീപുകളും");
    namesMap.put("TD", "ചാഡ്");
    namesMap.put("TF", "ഫ്രഞ്ച് ദക്ഷിണ ഭൂപ്രദേശം");
    namesMap.put("TG", "ടോഗോ");
    namesMap.put("TH", "തായ്‌ലാന്‍ഡ്");
    namesMap.put("TJ", "താജിക്കിസ്ഥാന്‍");
    namesMap.put("TK", "ടൊകെലാവു");
    namesMap.put("TL", "കിഴക്കന്‍ തിമൂര്‍");
    namesMap.put("TM", "തുര്‍ക്ക്മെനിസ്ഥാന്‍");
    namesMap.put("TN", "ടുണീഷ്യ");
    namesMap.put("TO", "ടോംഗ");
    namesMap.put("TR", "തുര്‍ക്കി");
    namesMap.put("TT", "ട്രിനിഡാഡും റ്റൊബാഗോയും");
    namesMap.put("TV", "തുവാലു");
    namesMap.put("TW", "തായ്‌വാന്‍");
    namesMap.put("TZ", "ടാന്‍സാനിയ");
    namesMap.put("UA", "ഉക്രൈന്‍");
    namesMap.put("UG", "ഉഗാണ്ട");
    namesMap.put("UM", "യുണൈറ്റഡ് സ്റ്റേറ്റ്സും ചെറിയ പുറംദ്വീപുകളും");
    namesMap.put("US", "അമേരിക്കന്‍ ഐക്യനാടുകള്‍");
    namesMap.put("UY", "ഉറുഗ്വേ");
    namesMap.put("UZ", "ഉസ്ബെക്കിസ്ഥാന്‍");
    namesMap.put("VA", "വത്തിക്കാന്‍");
    namesMap.put("VC", "സെന്‍റ് വിന്‍സന്‍റും ഗ്രനഡൈന്‍സും");
    namesMap.put("VE", "വെനിസ്വേല");
    namesMap.put("VG", "ബ്രിട്ടീഷ് വിര്‍ജിന്‍ ദ്വീപുകള്‍");
    namesMap.put("VI", "യു.എസ്. വെര്‍ജിന്‍ ദ്വീപുകള്‍");
    namesMap.put("VN", "വിയറ്റ്നാം");
    namesMap.put("VU", "വന്വാത്തു");
    namesMap.put("WF", "വാലിസ് ആന്‍ഡ് ഫ്യുചൂന");
    namesMap.put("WS", "സാമോവ");
    namesMap.put("YE", "യമന്‍");
    namesMap.put("YT", "മയോട്ട്");
    namesMap.put("ZA", "ദക്ഷിണാഫ്രിക്ക");
    namesMap.put("ZM", "സാംബിയ");
    namesMap.put("ZW", "സിംബാബ്വേ");
    namesMap.put("ZZ", "അറിയപ്പെടാത്തതോ നിലവിലില്ലാത്തതോ ആയ പ്രദേശം");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ലോകം",
        "002": "ആഫ്രിക്ക",
        "003": "വടക്കേ അമേരിക്കന്‍ ഭൂഖണ്ഡം",
        "005": "തെക്കേ അമേരിക്കന്‍ ഭൂഖണ്ഡം",
        "009": "ഓഷ്യാനിയ",
        "011": "പശ്ചിമ ആഫ്രിക്ക",
        "013": "മദ്ധ്യഅമേരിക്ക",
        "014": "കിഴക്കന്‍ ആഫ്രിക്ക",
        "015": "വടക്കേ ആഫ്രിക്ക",
        "017": "മദ്ധ്യആഫ്രിക്ക",
        "018": "തെക്കേ ആഫ്രിക്ക",
        "019": "അമേരിക്കന്‍ ഭൂഖണ്ഡം",
        "021": "വടക്കേ അമേരിക്ക",
        "029": "കരീബിയന്‍",
        "030": "കിഴക്കന്‍ ഏഷ്യ",
        "034": "തെക്കേ ഏഷ്യ",
        "035": "തെക്ക്-കിഴക്കന്‍ ഏഷ്യ",
        "039": "തെക്കേ യൂറോപ്പ്",
        "053": "ഓസ്ട്രേലിയയും ന്യൂസിലാന്‍ഡും",
        "054": "മെലനേഷ്യ",
        "057": "മൈക്രോനേഷ്യന്‍ പ്രദേശം",
        "061": "പോളിനേഷ്യ",
        "142": "ഏഷ്യ",
        "143": "മദ്ധ്യേഷ്യ",
        "145": "പശ്ചിമേഷ്യ",
        "150": "യൂറോപ്പ്",
        "151": "കിഴക്കന്‍ യൂറോപ്പ്",
        "154": "വടക്കേ യൂറോപ്പ്",
        "155": "പശ്ചിമ യൂറോപ്പ്",
        "419": "ലാറ്റിനമേരിക്കയും കരീബിയനും",
        "AC": "അസന്‍ഷന്‍ ദ്വീപ്",
        "AD": "അന്‍റോറ",
        "AE": "സംയുക്ത അറബ് രാഷ്ട്രം",
        "AF": "അഫ്ഗാനിസ്ഥാന്‍",
        "AG": "ആന്‍റിഗ്വയും ബര്‍ബുഡയും",
        "AI": "ആന്‍ഗ്വില്ല",
        "AL": "അല്‍ബേനിയ",
        "AM": "അര്‍മേനിയ",
        "AN": "നെതര്‍ലന്‍ഡ്സ് ആന്‍റിലിസ്",
        "AO": "അംഗോള",
        "AQ": "അന്‍റാര്‍ട്ടിക്ക",
        "AR": "അര്‍ജന്‍റീന",
        "AS": "അമേരിക്കന്‍ സാമോവ",
        "AT": "ഓസ്ട്രിയ",
        "AU": "ഓസ്ട്രേലിയ",
        "AW": "അറുബ",
        "AX": "അലന്‍ഡ് ദ്വീപുകള്‍",
        "AZ": "അസര്‍ബൈജാന്‍",
        "BA": "ബോസ്നിയയും ഹെര്‍സഗോവിനയും",
        "BB": "ബാര്‍ബഡോസ്",
        "BD": "ബംഗ്ലാദേശ്",
        "BE": "ബെല്‍ജിയം",
        "BF": "ബുര്‍ക്കിനാ ഫാസോ",
        "BG": "ബള്‍ഗേറിയ",
        "BH": "ബഹ്റൈന്‍",
        "BI": "ബുറുണ്ടി",
        "BJ": "ബെനിന്‍",
        "BL": "സെന്‍റ് ബാര്‍ത്തെല്‍മി",
        "BM": "ബര്‍മുഡ",
        "BN": "ബ്രൂണൈ",
        "BO": "ബൊളീവിയ",
        "BR": "ബ്രസീല്‍",
        "BS": "ബഹാമാസ്",
        "BT": "ഭൂട്ടാന്‍",
        "BV": "ബൗവെറ്റ് ദ്വീപ്",
        "BW": "ബോട്സ്വാന",
        "BY": "ബെലറൂസ്",
        "BZ": "ബെലീസ്",
        "CA": "കാനഡ",
        "CC": "കോക്കസ്",
        "CD": "കോംഗോ - കിന്‍ഷാസ",
        "CF": "സെന്‍ട്രല്‍ ആഫ്രിക്കന്‍ റിപ്പബ്ലിക്",
        "CG": "കോംഗോ - ബ്രാസാവില്‍",
        "CH": "സ്വിറ്റ്സര്‍ലാന്‍ഡ്",
        "CI": "ഐവറി കോസ്റ്റ്",
        "CK": "കൂക്ക് ദ്വീപുകള്‍",
        "CL": "ചിലി",
        "CM": "കാമറൂണ്‍",
        "CN": "ചൈന",
        "CO": "കൊളംബിയ",
        "CP": "ക്ലിപ്പെര്‍ട്ടന്‍ ദ്വീപ്",
        "CR": "കോസ്റ്ററിക്ക",
        "CS": "സെര്‍ബിയയും മോണ്ടനേഗ്രോയും",
        "CU": "ക്യൂബ",
        "CV": "കേപ്പ് വെര്‍ഡെ",
        "CX": "ക്രിസ്മസ് ദ്വീപ്",
        "CY": "സൈപ്രസ്സ്",
        "CZ": "ചെക്ക് റിപ്പബ്ലിക്",
        "DE": "ജര്‍മനി",
        "DG": "ഡീഗോ ഗ്രാഷ്യ",
        "DJ": "ജിബൂട്ടി",
        "DK": "ഡെന്‍മാര്‍ക്ക്",
        "DM": "ഡൊമിനിക്ക",
        "DO": "ഡൊമിനിക്കന്‍ റിപ്പബ്ലിക്",
        "DZ": "അള്‍ജീരിയ",
        "EA": "സെയൂത്ത ആന്‍ഡ് മെലിയ",
        "EC": "ഇക്വഡോര്‍",
        "EE": "എസ്റ്റോണിയ‍",
        "EG": "ഈജിപ്ത്",
        "EH": "പശ്ചിമ സഹാറ",
        "ER": "എറിത്രിയ",
        "ES": "സ്പെയിന്‍",
        "ET": "എത്യോപ്യ",
        "EU": "യൂറോപ്യന്‍ യൂണിയന്‍",
        "FI": "ഫിന്‍ലാന്‍ഡ്",
        "FJ": "ഫിജി",
        "FK": "ഫാക്ക്‌ലാന്റ് ഐലന്റ്",
        "FM": "മൈക്രോനേഷ്യ",
        "FO": "ഫറോയി ദ്വീപുകള്‍",
        "FR": "ഫ്രാന്‍സ്",
        "GA": "ഗാബോണ്‍",
        "GB": "ബ്രിട്ടന്‍",
        "GD": "ഗ്രനേഡ",
        "GE": "ജോര്‍ജിയ",
        "GF": "ഫ്രഞ്ച് ഗയാന",
        "GG": "ഗേണ്‍സി",
        "GH": "ഘാന",
        "GI": "ജിബ്രാള്‍ട്ടര്‍",
        "GL": "ഗ്രീന്‍ലാന്‍റ്",
        "GM": "ഗാംബിയ",
        "GN": "ഗ്വിനിയ",
        "GP": "ഗുവാഡെലോപ്",
        "GQ": "ഇക്വിറ്റോറിയല്‍ ഗ്വിനിയ",
        "GR": "ഗ്രീസ്",
        "GS": "ദക്ഷിണ ജോര്‍ജ്ജിയയും ദക്ഷിണ സാന്‍ഡ്‌വിച്ച് ദ്വീപുകളും",
        "GT": "ഗ്വാട്ടിമാലാ",
        "GU": "ഗ്വാം",
        "GW": "ഗിനി-ബിസോ",
        "GY": "ഗയാന",
        "HK": "ഹോങ് കോങ്",
        "HM": "ഹിയേര്‍ഡ് ദ്വീപും മക്ഡൊണാള്ഡ് ദ്വീപുകളും",
        "HN": "ഹോണ്ടുറാസ്",
        "HR": "ക്രൊയേഷ്യ",
        "HT": "ഹെയ്തി",
        "HU": "ഹംഗറി",
        "IC": "കാനറി ദ്വീപുകള്‍",
        "ID": "ഇന്‍ഡോനേഷ്യ",
        "IE": "അയര്‍ലാന്‍ഡ്",
        "IL": "ഇസ്രായേല്‍",
        "IM": "ഐല്‍ ഓഫ് മാന്‍",
        "IN": "ഇന്ത്യ",
        "IO": "ബ്രിട്ടീഷ് ഇന്ത്യന്‍ മഹാസമുദ്ര പ്രദേശം",
        "IQ": "ഇറാക്ക്",
        "IR": "ഇറാന്‍",
        "IS": "ഐസ്‌ലാന്റ്",
        "IT": "ഇറ്റലി",
        "JE": "ജേഴ്സി",
        "JM": "ജമൈക്ക",
        "JO": "ജോര്‍ദ്ദാന്‍",
        "JP": "ജപ്പാന്‍",
        "KE": "കെനിയ",
        "KG": "കിര്‍ഗിസ്ഥാന്‍",
        "KH": "കംബോഡിയ",
        "KI": "കിരിബാത്തി",
        "KM": "കോമറോസ്",
        "KN": "സെയ്ന്‍റ് കിറ്റ്സും നെവിസും",
        "KP": "ഉത്തരകൊറിയ",
        "KR": "ദക്ഷിണകൊറിയ",
        "KW": "കുവൈറ്റ്",
        "KY": "കേയ്മാന്‍ ദ്വീപുകള്‍",
        "KZ": "കസാഖിസ്ഥാന്‍",
        "LA": "ലാവോസ്",
        "LB": "ലബനോണ്‍",
        "LC": "സെന്‍റ് ലൂസിയ",
        "LI": "ലൈച്ടെസ്റ്റിന്‍",
        "LK": "ശ്രീലങ്ക",
        "LR": "ലൈബീരിയ",
        "LS": "ലെസോത്തോ",
        "LT": "ലിത്വാനിയ",
        "LU": "ലക്സംബര്‍ഗ്",
        "LV": "ലാത്വിയ",
        "LY": "ലിബിയ",
        "MA": "മൊറോക്കൊ",
        "MC": "മൊണോക്കൊ",
        "MD": "മള്‍ഡോവ",
        "ME": "മോണ്ടേനേഗ്രോ",
        "MF": "സെന്‍റ് മാര്‍ട്ടിന്‍",
        "MG": "മഡഗാസ്കര്‍",
        "MH": "മാര്‍ഷല്‍‍‍ ദ്വീപുകള്‍",
        "MK": "മാസിഡോണിയ",
        "ML": "മാലി",
        "MM": "മ്യാന്‍മാര്‍",
        "MN": "മംഗോളിയ",
        "MO": "മക്കാവോ",
        "MP": "ഉത്തര മറിയാനാ ദ്വീപുകള്‍",
        "MQ": "മാര്‍ട്ടീനിക്",
        "MR": "മൗറിറ്റാനിയ",
        "MS": "മോണ്ട്സെറാറ്റ്",
        "MT": "മാള്‍ട്ട",
        "MU": "മൗറീഷ്യസ്",
        "MV": "മാലിദ്വീപ്",
        "MW": "മലാവി",
        "MX": "മെക്സിക്കോ",
        "MY": "മലേഷ്യ",
        "MZ": "മൊസാംബിക്ക്",
        "NA": "നമീബിയ",
        "NC": "പുതിയ കാലിഡോണിയ",
        "NE": "നൈജര്‍",
        "NF": "നോര്‍ഫോക് ദ്വീപ്",
        "NG": "നൈജീരിയ",
        "NI": "നിക്കാരഗ്വ",
        "NL": "നെതര്‍ലന്‍ഡ്സ്",
        "NO": "നോര്‍വെ",
        "NP": "നേപ്പാള്‍",
        "NR": "നൗറൂ",
        "NU": "ന്യൂവേ",
        "NZ": "ന്യൂസിലാന്‍റ്",
        "OM": "ഒമാന്‍",
        "PA": "പനാമ",
        "PE": "പെറു",
        "PF": "ഫ്രഞ്ച് പോളിനേഷ്യ",
        "PG": "പപ്പുവ ന്യൂ ഗ്വിനി",
        "PH": "ഫിലിപ്പൈന്‍സ്",
        "PK": "പാക്കിസ്ഥാന്‍",
        "PL": "പോളണ്ട്",
        "PM": "സെന്‍റ് പിറേയും മിക്വലണും",
        "PN": "പിറ്റ്കെയ്ന്‍",
        "PR": "പോര്‍ട്ടോ റിക്കോ",
        "PS": "പാലസ്തീന്‍ പ്രദേശങ്ങള്‍",
        "PT": "പോര്‍ച്ചുഗല്‍",
        "PW": "പലാവു",
        "PY": "പരാഗ്വേ",
        "QA": "ഖത്തര്‍",
        "QO": "പുറംദ്വീപുകള്‍",
        "RE": "റീയൂണിയന്‍",
        "RO": "റുമേനിയ",
        "RS": "സെര്‍ബിയ",
        "RU": "റഷ്യ",
        "RW": "റുവാണ്ട",
        "SA": "സൗദി അറേബ്യ",
        "SB": "സോളമന്‍‍ ദ്വീപുകള്‍",
        "SC": "സെയ്ഷെല്‍സ്",
        "SD": "സുഡാന്‍",
        "SE": "സ്വീഡന്‍",
        "SG": "സിംഗപ്പുര്‍",
        "SH": "സെന്‍റ് ഹെലീന",
        "SI": "സ്ലോവേനിയ",
        "SJ": "സ്വാല്‍ബാഡും ജാന്‍ മായേനും",
        "SK": "സ്ലോവാക്യ",
        "SL": "സിയേറാ ലിയോണ്‍",
        "SM": "സാന്‍ മറിനോ",
        "SN": "സെനഗല്‍",
        "SO": "സോമാലിയ",
        "SR": "സുറിനാം",
        "ST": "സാവോ റ്റമെ ആന്‍ഡ് പ്രിന്‍സിപ്പി",
        "SV": "എല്‍ സാല്‍വദോര്‍",
        "SY": "സിറിയ",
        "SZ": "സ്വാസിലാന്‍റ്",
        "TA": "ട്രസ്റ്റന്‍ ഡ കൂന",
        "TC": "ടര്‍ക്ക്സും കൈക്കോ ദ്വീപുകളും",
        "TD": "ചാഡ്",
        "TF": "ഫ്രഞ്ച് ദക്ഷിണ ഭൂപ്രദേശം",
        "TG": "ടോഗോ",
        "TH": "തായ്‌ലാന്‍ഡ്",
        "TJ": "താജിക്കിസ്ഥാന്‍",
        "TK": "ടൊകെലാവു",
        "TL": "കിഴക്കന്‍ തിമൂര്‍",
        "TM": "തുര്‍ക്ക്മെനിസ്ഥാന്‍",
        "TN": "ടുണീഷ്യ",
        "TO": "ടോംഗ",
        "TR": "തുര്‍ക്കി",
        "TT": "ട്രിനിഡാഡും റ്റൊബാഗോയും",
        "TV": "തുവാലു",
        "TW": "തായ്‌വാന്‍",
        "TZ": "ടാന്‍സാനിയ",
        "UA": "ഉക്രൈന്‍",
        "UG": "ഉഗാണ്ട",
        "UM": "യുണൈറ്റഡ് സ്റ്റേറ്റ്സും ചെറിയ പുറംദ്വീപുകളും",
        "US": "അമേരിക്കന്‍ ഐക്യനാടുകള്‍",
        "UY": "ഉറുഗ്വേ",
        "UZ": "ഉസ്ബെക്കിസ്ഥാന്‍",
        "VA": "വത്തിക്കാന്‍",
        "VC": "സെന്‍റ് വിന്‍സന്‍റും ഗ്രനഡൈന്‍സും",
        "VE": "വെനിസ്വേല",
        "VG": "ബ്രിട്ടീഷ് വിര്‍ജിന്‍ ദ്വീപുകള്‍",
        "VI": "യു.എസ്. വെര്‍ജിന്‍ ദ്വീപുകള്‍",
        "VN": "വിയറ്റ്നാം",
        "VU": "വന്വാത്തു",
        "WF": "വാലിസ് ആന്‍ഡ് ഫ്യുചൂന",
        "WS": "സാമോവ",
        "YE": "യമന്‍",
        "YT": "മയോട്ട്",
        "ZA": "ദക്ഷിണാഫ്രിക്ക",
        "ZM": "സാംബിയ",
        "ZW": "സിംബാബ്വേ",
        "ZZ": "അറിയപ്പെടാത്തതോ നിലവിലില്ലാത്തതോ ആയ പ്രദേശം"
    };
  }-*/;
}
