/*
 * Copyright 2000-2022 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4); 
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.client.widget.grid.events;

import com.google.gwt.event.shared.GwtEvent;
import com.vaadin.client.widgets.Grid.Column;

/**
 * An event for notifying that the columns in the Grid have been resized.
 *
 * @param <T>
 *            The row type of the grid. The row type is the POJO type from where
 *            the data is retrieved into the column cells.
 * @since 7.6
 * @author Vaadin Ltd
 */
public class ColumnResizeEvent<T> extends GwtEvent<ColumnResizeHandler<T>> {

    /**
     * Handler type.
     */
    private static final Type<ColumnResizeHandler<?>> TYPE = new Type<>();

    private Column<?, T> column;

    /**
     * Constructs a resize event for a grid column.
     *
     * @param column
     *            the updated column
     */
    public ColumnResizeEvent(Column<?, T> column) {
        this.column = column;
    }

    /**
     * Returns the associated handler type.
     *
     * @return the handler type
     */
    public static final Type<ColumnResizeHandler<?>> getType() {
        return TYPE;
    }

    @SuppressWarnings({ "rawtypes", "unchecked" })
    @Override
    public Type<ColumnResizeHandler<T>> getAssociatedType() {
        return (Type) TYPE;
    }

    @Override
    protected void dispatch(ColumnResizeHandler<T> handler) {
        handler.onColumnResize(this);
    }

    /**
     * @return the column
     */
    public Column<?, T> getColumn() {
        return column;
    }
}
