/*
 * Copyright 2000-2022 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4); 
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.client.ui.passwordfield;

import com.vaadin.client.ui.VPasswordField;
import com.vaadin.client.ui.textfield.TextFieldConnector;
import com.vaadin.shared.ui.Connect;
import com.vaadin.shared.ui.passwordfield.PasswordFieldState;
import com.vaadin.ui.PasswordField;

/**
 * A connector class for the PasswordField component.
 *
 * @author Vaadin Ltd
 */
@Connect(PasswordField.class)
public class PasswordFieldConnector extends TextFieldConnector {

    @Override
    public VPasswordField getWidget() {
        return (VPasswordField) super.getWidget();
    }

    @Override
    public PasswordFieldState getState() {
        return (PasswordFieldState) super.getState();
    }
}
