/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.event.ContextClickEvent;
import com.vaadin.event.FieldEvents;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.EncodeResult;
import com.vaadin.server.ErrorEvent;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.Extension;
import com.vaadin.server.JsonCodec;
import com.vaadin.server.KeyMapper;
import com.vaadin.server.Sizeable;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.Connector;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.shared.Registration;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.shared.util.SharedUtil;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.ConnectorTracker;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.SelectiveRenderer;
import com.vaadin.ui.UI;
import com.vaadin.ui.declarative.DesignAttributeHandler;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignException;
import com.vaadin.ui.declarative.DesignFormatter;
import com.vaadin.util.ReflectTools;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.fieldgroup.DefaultFieldGroupFieldFactory;
import com.vaadin.v7.data.fieldgroup.FieldGroup;
import com.vaadin.v7.data.fieldgroup.FieldGroupFieldFactory;
import com.vaadin.v7.data.sort.Sort;
import com.vaadin.v7.data.sort.SortOrder;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.util.converter.ConverterUtil;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.event.SelectionEvent;
import com.vaadin.v7.event.SortEvent;
import com.vaadin.v7.server.communication.data.DataGenerator;
import com.vaadin.v7.server.communication.data.RpcDataProviderExtension;
import com.vaadin.v7.shared.ui.grid.ColumnResizeMode;
import com.vaadin.v7.shared.ui.grid.EditorClientRpc;
import com.vaadin.v7.shared.ui.grid.EditorServerRpc;
import com.vaadin.v7.shared.ui.grid.GridClientRpc;
import com.vaadin.v7.shared.ui.grid.GridColumnState;
import com.vaadin.v7.shared.ui.grid.GridConstants;
import com.vaadin.v7.shared.ui.grid.GridServerRpc;
import com.vaadin.v7.shared.ui.grid.GridState;
import com.vaadin.v7.shared.ui.grid.GridStaticCellType;
import com.vaadin.v7.shared.ui.grid.GridStaticSectionState;
import com.vaadin.v7.shared.ui.grid.HeightMode;
import com.vaadin.v7.shared.ui.grid.ScrollDestination;
import com.vaadin.v7.shared.ui.grid.selection.MultiSelectionModelServerRpc;
import com.vaadin.v7.shared.ui.grid.selection.MultiSelectionModelState;
import com.vaadin.v7.shared.ui.grid.selection.SingleSelectionModelServerRpc;
import com.vaadin.v7.shared.ui.grid.selection.SingleSelectionModelState;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.renderers.HtmlRenderer;
import com.vaadin.v7.ui.renderers.Renderer;
import com.vaadin.v7.ui.renderers.TextRenderer;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

@Deprecated
public class Grid
extends AbstractComponent
implements SelectionEvent.SelectionNotifier,
SortEvent.SortNotifier,
SelectiveRenderer,
ItemClickEvent.ItemClickNotifier,
Component.Focusable,
FieldEvents.FocusNotifier,
FieldEvents.BlurNotifier {
    private Container.Indexed datasource;
    private final Map<Object, Column> columns = new HashMap<Object, Column>();
    private final KeyMapper<Object> columnKeys = new KeyMapper();
    private final List<SortOrder> sortOrder = new ArrayList<SortOrder>();
    private final Container.PropertySetChangeListener propertyListener = new Container.PropertySetChangeListener(){

        @Override
        public void containerPropertySetChange(Container.PropertySetChangeEvent event) {
            HashSet properties = new HashSet(event.getContainer().getContainerPropertyIds());
            LinkedList<Column> removedColumns = new LinkedList<Column>();
            for (Object k : Grid.this.columns.keySet()) {
                if (properties.contains(k)) continue;
                removedColumns.add(Grid.this.getColumn(k));
            }
            for (Column column : removedColumns) {
                Object propertyId = column.getPropertyId();
                Grid.this.internalRemoveColumn(propertyId);
                Grid.this.columnKeys.remove(propertyId);
            }
            Grid.this.datasourceExtension.columnsRemoved(removedColumns);
            LinkedList<Column> addedColumns = new LinkedList<Column>();
            for (Object propertyId : properties) {
                if (Grid.this.columns.containsKey(propertyId)) continue;
                addedColumns.add(Grid.this.appendColumn(propertyId));
            }
            Grid.this.datasourceExtension.columnsAdded(addedColumns);
            if (Grid.this.getFrozenColumnCount() > Grid.this.columns.size()) {
                Grid.this.setFrozenColumnCount(Grid.this.columns.size());
            }
            if (Grid.this.datasource instanceof Container.Sortable) {
                Collection<?> collection = ((Container.Sortable)((Object)Grid.this.datasource)).getSortableContainerPropertyIds();
                for (Object propertyId : Grid.this.columns.keySet()) {
                    Column column = (Column)Grid.this.columns.get(propertyId);
                    if (collection.contains(propertyId) || !column.isSortable()) continue;
                    column.setSortable(false);
                }
            }
        }
    };
    private final Container.ItemSetChangeListener editorClosingItemSetListener = new Container.ItemSetChangeListener(){

        @Override
        public void containerItemSetChange(Container.ItemSetChangeEvent event) {
            Grid.this.cancelEditor();
        }
    };
    private RpcDataProviderExtension datasourceExtension;
    private SelectionModel selectionModel;
    private boolean applyingSelectionFromClient;
    private final Header header = new Header(this);
    private final Footer footer = new Footer(this);
    private Object editedItemId = null;
    private boolean editorActive = false;
    private boolean editorSaving = false;
    private FieldGroup editorFieldGroup = new CustomFieldGroup();
    private Map<Object, Field<?>> editorFields = new HashMap();
    private CellStyleGenerator cellStyleGenerator;
    private RowStyleGenerator rowStyleGenerator;
    private CellDescriptionGenerator cellDescriptionGenerator;
    private RowDescriptionGenerator rowDescriptionGenerator;
    private boolean defaultContainer = true;
    private EditorErrorHandler editorErrorHandler = new DefaultEditorErrorHandler();
    private DetailComponentManager detailComponentManager = null;
    private Set<Component> extensionComponents = new HashSet<Component>();
    private static final Method SELECTION_CHANGE_METHOD = ReflectTools.findMethod(SelectionEvent.SelectionListener.class, (String)"select", (Class[])new Class[]{SelectionEvent.class});
    private static final Method SORT_ORDER_CHANGE_METHOD = ReflectTools.findMethod(SortEvent.SortListener.class, (String)"sort", (Class[])new Class[]{SortEvent.class});
    private static final Method COLUMN_REORDER_METHOD = ReflectTools.findMethod(ColumnReorderListener.class, (String)"columnReorder", (Class[])new Class[]{ColumnReorderEvent.class});
    private static final Method COLUMN_RESIZE_METHOD = ReflectTools.findMethod(ColumnResizeListener.class, (String)"columnResize", (Class[])new Class[]{ColumnResizeEvent.class});
    private static final Method COLUMN_VISIBILITY_METHOD = ReflectTools.findMethod(ColumnVisibilityChangeListener.class, (String)"columnVisibilityChanged", (Class[])new Class[]{ColumnVisibilityChangeEvent.class});

    public Grid() {
        this(null, null);
    }

    public Grid(Container.Indexed dataSource) {
        this(null, dataSource);
    }

    public Grid(String caption) {
        this(caption, null);
    }

    public Grid(String caption, Container.Indexed dataSource) {
        if (dataSource == null) {
            this.internalSetContainerDataSource(new IndexedContainer());
        } else {
            this.setContainerDataSource(dataSource);
        }
        this.setCaption(caption);
        this.initGrid();
    }

    private void initGrid() {
        this.setSelectionMode(Grid.getDefaultSelectionMode());
        this.registerRpc((ServerRpc)new GridServerRpc(){

            public void sort(String[] columnIds, SortDirection[] directions, boolean userOriginated) {
                assert (columnIds.length == directions.length);
                ArrayList<SortOrder> order = new ArrayList<SortOrder>(columnIds.length);
                for (int i = 0; i < columnIds.length; ++i) {
                    Object propertyId = Grid.this.getPropertyIdByColumnId(columnIds[i]);
                    order.add(new SortOrder(propertyId, directions[i]));
                }
                Grid.this.setSortOrder(order, userOriginated);
                if (!order.equals(Grid.this.getSortOrder())) {
                    ConnectorTracker connectorTracker = Grid.this.getUI().getConnectorTracker();
                    JsonObject diffState = connectorTracker.getDiffState((ClientConnector)Grid.this);
                    diffState.remove("sortColumns");
                    diffState.remove("sortDirs");
                    Grid.this.markAsDirty();
                }
            }

            public void itemClick(String rowKey, String columnId, MouseEventDetails details) {
                Object itemId = Grid.this.getKeyMapper().get(rowKey);
                Item item = Grid.this.datasource.getItem(itemId);
                Object propertyId = Grid.this.getPropertyIdByColumnId(columnId);
                Grid.this.fireEvent((EventObject)((Object)new ItemClickEvent((Component)Grid.this, item, itemId, propertyId, details)));
            }

            public void columnsReordered(List<String> newColumnOrder, List<String> oldColumnOrder) {
                String diffStateKey = "columnOrder";
                ConnectorTracker connectorTracker = Grid.this.getUI().getConnectorTracker();
                JsonObject diffState = connectorTracker.getDiffState((ClientConnector)Grid.this);
                if (Grid.this.getState((boolean)false).columnOrder.equals(oldColumnOrder)) {
                    Grid.this.getState((boolean)false).columnOrder = newColumnOrder;
                    assert (diffState.hasKey("columnOrder")) : "Field name has changed";
                    Type type = null;
                    try {
                        type = Grid.this.getState(false).getClass().getDeclaredField("columnOrder").getGenericType();
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    EncodeResult encodeResult = JsonCodec.encode((Object)Grid.this.getState((boolean)false).columnOrder, (JsonValue)diffState, (Type)type, (ConnectorTracker)connectorTracker);
                    diffState.put("columnOrder", encodeResult.getEncodedValue());
                    Grid.this.fireColumnReorderEvent(true);
                } else {
                    diffState.remove("columnOrder");
                    Grid.this.markAsDirty();
                }
            }

            public void columnVisibilityChanged(String id, boolean hidden, boolean userOriginated) {
                Column column = Grid.this.getColumnByColumnId(id);
                GridColumnState columnState = column.getState();
                if (columnState.hidden != hidden) {
                    columnState.hidden = hidden;
                    String diffStateKey = "columns";
                    ConnectorTracker connectorTracker = Grid.this.getUI().getConnectorTracker();
                    JsonObject diffState = connectorTracker.getDiffState((ClientConnector)Grid.this);
                    assert (diffState.hasKey("columns")) : "Field name has changed";
                    Type type = null;
                    try {
                        type = Grid.this.getState(false).getClass().getDeclaredField("columns").getGenericType();
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    EncodeResult encodeResult = JsonCodec.encode((Object)Grid.this.getState((boolean)false).columns, (JsonValue)diffState, (Type)type, (ConnectorTracker)connectorTracker);
                    diffState.put("columns", encodeResult.getEncodedValue());
                    Grid.this.fireColumnVisibilityChangeEvent(column, hidden, userOriginated);
                }
            }

            public void contextClick(int rowIndex, String rowKey, String columnId, GridConstants.Section section, MouseEventDetails details) {
                Object itemId = null;
                if (rowKey != null) {
                    itemId = Grid.this.getKeyMapper().get(rowKey);
                }
                Grid.this.fireEvent((EventObject)((Object)new GridContextClickEvent(Grid.this, details, section, rowIndex, itemId, Grid.this.getPropertyIdByColumnId(columnId))));
            }

            public void columnResized(String id, double pixels) {
                Column column = Grid.this.getColumnByColumnId(id);
                if (column != null && column.isResizable()) {
                    column.getState().width = pixels;
                    Grid.this.fireColumnResizeEvent(column, true);
                    Grid.this.markAsDirty();
                }
            }
        });
        this.registerRpc((ServerRpc)new EditorServerRpc(){

            public void bind(int rowIndex) {
                try {
                    boolean allowMove;
                    Object id = Grid.this.getContainerDataSource().getIdByIndex(rowIndex);
                    boolean opening = Grid.this.editedItemId == null;
                    boolean moving = !opening && !Grid.this.editedItemId.equals(id);
                    boolean bl = allowMove = !Grid.this.isEditorBuffered() && Grid.this.getEditorFieldGroup().isValid();
                    if (opening || !moving || allowMove) {
                        this.doBind(id);
                    } else {
                        this.failBind(null);
                    }
                }
                catch (Exception e) {
                    this.failBind(e);
                }
            }

            private void doBind(Object id) {
                Grid.this.editedItemId = id;
                Grid.this.doEditItem();
                Grid.this.getEditorRpc().confirmBind(true);
            }

            private void failBind(Exception e) {
                if (e != null) {
                    this.handleError(e);
                }
                Grid.this.getEditorRpc().confirmBind(false);
            }

            public void cancel(int rowIndex) {
                try {
                    Grid.this.doCancelEditor();
                }
                catch (Exception e) {
                    this.handleError(e);
                }
            }

            public void save(int rowIndex) {
                ArrayList<String> errorColumnIds = null;
                String errorMessage = null;
                boolean success = false;
                try {
                    Grid.this.saveEditor();
                    success = true;
                }
                catch (FieldGroup.CommitException e) {
                    try {
                        CommitErrorEvent event = new CommitErrorEvent(Grid.this, e);
                        Grid.this.getEditorErrorHandler().commitError(event);
                        errorMessage = event.getUserErrorMessage();
                        errorColumnIds = new ArrayList<String>();
                        for (Column column : event.getErrorColumns()) {
                            errorColumnIds.add(((Column)column).state.id);
                        }
                    }
                    catch (Exception ee) {
                        this.handleError(ee);
                    }
                }
                catch (Exception e) {
                    this.handleError(e);
                }
                Grid.this.getEditorRpc().confirmSave(success, errorMessage, errorColumnIds);
            }

            private void handleError(Exception e) {
                ErrorEvent.findErrorHandler((ClientConnector)Grid.this).error((ErrorEvent)new ClientConnector.ConnectorErrorEvent((Connector)Grid.this, (Throwable)e));
            }
        });
    }

    public void beforeClientResponse(boolean initial) {
        try {
            this.header.sanityCheck();
            this.footer.sanityCheck();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setComponentError(new ErrorMessage(){

                public ErrorMessage.ErrorLevel getErrorLevel() {
                    return ErrorMessage.ErrorLevel.CRITICAL;
                }

                public String getFormattedHtmlMessage() {
                    return "Incorrectly merged cells";
                }
            });
        }
        super.beforeClientResponse(initial);
    }

    public void setContainerDataSource(Container.Indexed container) {
        this.defaultContainer = false;
        this.internalSetContainerDataSource(container);
    }

    private void internalSetContainerDataSource(Container.Indexed container) {
        if (container == null) {
            throw new IllegalArgumentException("Cannot set the datasource to null");
        }
        if (this.datasource == container) {
            return;
        }
        if (this.datasource instanceof Container.PropertySetChangeNotifier) {
            ((Container.PropertySetChangeNotifier)((Object)this.datasource)).removePropertySetChangeListener(this.propertyListener);
        }
        if (this.datasourceExtension != null) {
            this.removeExtension((Extension)this.datasourceExtension);
        }
        if (this.detailComponentManager != null) {
            this.detailComponentManager.remove();
        }
        this.resetEditor();
        this.datasource = container;
        if (container instanceof Container.Sortable) {
            Iterator<?> sortableProps = ((Container.Sortable)((Object)this.getContainerDataSource())).getSortableContainerPropertyIds();
            Iterator<SortOrder> i = this.sortOrder.iterator();
            while (i.hasNext()) {
                if (sortableProps.contains(i.next().getPropertyId())) continue;
                i.remove();
            }
            this.sort(false);
        } else {
            this.sortOrder.clear();
        }
        this.datasourceExtension = new RpcDataProviderExtension(container);
        this.datasourceExtension.extend(this);
        this.datasourceExtension.addDataGenerator(new RowDataGenerator());
        for (Extension e : this.getExtensions()) {
            if (!(e instanceof DataGenerator)) continue;
            this.datasourceExtension.addDataGenerator((DataGenerator)e);
        }
        this.detailComponentManager = this.detailComponentManager != null ? new DetailComponentManager(this, this.detailComponentManager.getDetailsGenerator()) : new DetailComponentManager(this);
        if (this.selectionModel != null) {
            this.selectionModel.reset();
        }
        if (this.datasource instanceof Container.PropertySetChangeNotifier) {
            ((Container.PropertySetChangeNotifier)((Object)this.datasource)).addPropertySetChangeListener(this.propertyListener);
        }
        this.setFrozenColumnCount(0);
        if (this.columns.isEmpty()) {
            for (Object propertyId : this.datasource.getContainerPropertyIds()) {
                Column column = this.appendColumn(propertyId);
                if (this.datasource instanceof Container.Sortable) {
                    column.setSortable(((Container.Sortable)((Object)this.datasource)).getSortableContainerPropertyIds().contains(propertyId));
                    continue;
                }
                column.setSortable(false);
            }
        } else {
            Collection<?> properties = this.datasource.getContainerPropertyIds();
            for (Object property : this.columns.keySet()) {
                if (!properties.contains(property)) {
                    throw new IllegalStateException("Found at least one column in Grid that does not exist in the given container: " + property + " with the header \"" + this.getColumn(property).getHeaderCaption() + "\". " + "Call removeAllColumns() before setContainerDataSource() if you want to reconfigure the columns based on the new container.");
                }
                if (this.datasource instanceof Container.Sortable && ((Container.Sortable)((Object)this.datasource)).getSortableContainerPropertyIds().contains(property)) continue;
                this.columns.get(property).setSortable(false);
            }
        }
    }

    public Container.Indexed getContainerDataSource() {
        return this.datasource;
    }

    public Column getColumn(Object propertyId) {
        return this.columns.get(propertyId);
    }

    public List<Column> getColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String columnId : this.getState((boolean)false).columnOrder) {
            columns.add(this.getColumnByColumnId(columnId));
        }
        return Collections.unmodifiableList(columns);
    }

    public Column addColumn(Object propertyId) throws IllegalStateException {
        if (this.datasource.getContainerPropertyIds().contains(propertyId) && !this.columns.containsKey(propertyId)) {
            this.appendColumn(propertyId);
        } else if (this.defaultContainer) {
            this.addColumnProperty(propertyId, String.class, "");
        } else {
            if (this.columns.containsKey(propertyId)) {
                throw new IllegalStateException("A column for property id '" + propertyId.toString() + "' already exists in this grid");
            }
            throw new IllegalStateException("Property id '" + propertyId.toString() + "' does not exist in the container");
        }
        Column column = this.getColumn(propertyId);
        ArrayList<Column> addedColumns = new ArrayList<Column>();
        addedColumns.add(column);
        this.datasourceExtension.columnsAdded(addedColumns);
        return column;
    }

    public Column addColumn(Object propertyId, Class<?> type) {
        this.addColumnProperty(propertyId, type, null);
        return this.getColumn(propertyId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addColumnProperty(Object propertyId, Class<?> type, Object defaultValue) throws IllegalStateException {
        if (!this.defaultContainer) {
            throw new IllegalStateException("Container for this Grid is not a default container from Grid() constructor");
        }
        if (this.columns.containsKey(propertyId)) throw new IllegalStateException("Grid already has a column for property " + propertyId);
        if (!this.datasource.getContainerPropertyIds().contains(propertyId)) {
            this.datasource.addContainerProperty(propertyId, type, defaultValue);
            return;
        } else {
            Property containerProperty = this.datasource.getContainerProperty(this.datasource.firstItemId(), propertyId);
            if (containerProperty.getType() != type) throw new IllegalStateException("DataSource already has the given property " + propertyId + " with a different type");
            this.appendColumn(propertyId);
        }
    }

    public void removeAllColumns() {
        ArrayList<Column> removed = new ArrayList<Column>(this.columns.values());
        HashSet<Object> properties = new HashSet<Object>(this.columns.keySet());
        for (Object e : properties) {
            this.removeColumn(e);
        }
        this.datasourceExtension.columnsRemoved(removed);
    }

    Column getColumnByColumnId(String columnId) {
        Object propertyId = this.getPropertyIdByColumnId(columnId);
        return this.getColumn(propertyId);
    }

    Object getPropertyIdByColumnId(String columnId) {
        return this.columnKeys.get(columnId);
    }

    public boolean isColumnReorderingAllowed() {
        return this.getState((boolean)false).columnReorderingAllowed;
    }

    public void setColumnReorderingAllowed(boolean columnReorderingAllowed) {
        if (this.isColumnReorderingAllowed() != columnReorderingAllowed) {
            this.getState().columnReorderingAllowed = columnReorderingAllowed;
        }
    }

    protected GridState getState() {
        return (GridState)super.getState();
    }

    protected GridState getState(boolean markAsDirty) {
        return (GridState)super.getState(markAsDirty);
    }

    public void setColumnResizeMode(ColumnResizeMode mode) {
        this.getState().columnResizeMode = mode;
    }

    public ColumnResizeMode getColumnResizeMode() {
        return this.getState((boolean)false).columnResizeMode;
    }

    private Column appendColumn(Object datasourcePropertyId) {
        if (datasourcePropertyId == null) {
            throw new IllegalArgumentException("Property id cannot be null");
        }
        assert (this.datasource.getContainerPropertyIds().contains(datasourcePropertyId)) : "Datasource should contain the property id";
        GridColumnState columnState = new GridColumnState();
        columnState.id = this.columnKeys.key(datasourcePropertyId);
        Column column = new Column(this, columnState, datasourcePropertyId);
        this.columns.put(datasourcePropertyId, column);
        this.getState().columns.add(columnState);
        this.getState().columnOrder.add(columnState.id);
        this.header.addColumn(datasourcePropertyId);
        this.footer.addColumn(datasourcePropertyId);
        String humanFriendlyPropertyId = SharedUtil.propertyIdToHumanFriendly((Object)String.valueOf(datasourcePropertyId));
        column.setHeaderCaption(humanFriendlyPropertyId);
        if (this.datasource instanceof Container.Sortable && ((Container.Sortable)((Object)this.datasource)).getSortableContainerPropertyIds().contains(datasourcePropertyId)) {
            column.setSortable(true);
        }
        return column;
    }

    public void removeColumn(Object propertyId) throws IllegalArgumentException {
        if (!this.columns.keySet().contains(propertyId)) {
            throw new IllegalArgumentException("There is no column for given property id " + propertyId);
        }
        ArrayList<Column> removed = new ArrayList<Column>();
        removed.add(this.getColumn(propertyId));
        this.internalRemoveColumn(propertyId);
        this.datasourceExtension.columnsRemoved(removed);
    }

    private void internalRemoveColumn(Object propertyId) {
        this.setEditorField(propertyId, null);
        this.header.removeColumn(propertyId);
        this.footer.removeColumn(propertyId);
        Column column = this.columns.remove(propertyId);
        this.getState().columnOrder.remove(this.columnKeys.key(propertyId));
        this.getState().columns.remove(column.getState());
        this.removeExtension(column.getRenderer());
    }

    public void setColumns(Object ... propertyIds) {
        if (SharedUtil.containsDuplicates((Object[])propertyIds)) {
            throw new IllegalArgumentException("The propertyIds array contains duplicates: " + SharedUtil.getDuplicates((Object[])propertyIds));
        }
        HashSet<Object> removePids = new HashSet<Object>(this.columns.keySet());
        removePids.removeAll(Arrays.asList(propertyIds));
        for (Object e : removePids) {
            this.removeColumn(e);
        }
        HashSet<Object> addPids = new HashSet<Object>(Arrays.asList(propertyIds));
        addPids.removeAll(this.columns.keySet());
        for (Object e : addPids) {
            this.addColumn(e);
        }
        this.setColumnOrder(propertyIds);
    }

    public void setColumnOrder(Object ... propertyIds) {
        if (SharedUtil.containsDuplicates((Object[])propertyIds)) {
            throw new IllegalArgumentException("The propertyIds array contains duplicates: " + SharedUtil.getDuplicates((Object[])propertyIds));
        }
        ArrayList<String> columnOrder = new ArrayList<String>();
        for (Object propertyId : propertyIds) {
            if (!this.columns.containsKey(propertyId)) {
                throw new IllegalArgumentException("Grid does not contain column for property " + String.valueOf(propertyId));
            }
            columnOrder.add(this.columnKeys.key(propertyId));
        }
        List stateColumnOrder = this.getState().columnOrder;
        if (stateColumnOrder.size() != columnOrder.size()) {
            stateColumnOrder.removeAll(columnOrder);
            columnOrder.addAll(stateColumnOrder);
        }
        this.getState().columnOrder = columnOrder;
        this.fireColumnReorderEvent(false);
    }

    public void setFrozenColumnCount(int numberOfColumns) {
        if (numberOfColumns < -1 || numberOfColumns > this.columns.size()) {
            throw new IllegalArgumentException("count must be between -1 and the current number of columns (" + this.columns.size() + "): " + numberOfColumns);
        }
        this.getState().frozenColumnCount = numberOfColumns;
    }

    public int getFrozenColumnCount() {
        return this.getState((boolean)false).frozenColumnCount;
    }

    public void scrollTo(Object itemId) throws IllegalArgumentException {
        this.scrollTo(itemId, ScrollDestination.ANY);
    }

    public void scrollTo(Object itemId, ScrollDestination destination) throws IllegalArgumentException {
        int row = this.datasource.indexOfId(itemId);
        if (row == -1) {
            throw new IllegalArgumentException("Item with specified ID does not exist in data source");
        }
        GridClientRpc clientRPC = (GridClientRpc)this.getRpcProxy(GridClientRpc.class);
        clientRPC.scrollToRow(row, destination);
    }

    public void scrollToStart() {
        GridClientRpc clientRPC = (GridClientRpc)this.getRpcProxy(GridClientRpc.class);
        clientRPC.scrollToStart();
    }

    public void scrollToEnd() {
        GridClientRpc clientRPC = (GridClientRpc)this.getRpcProxy(GridClientRpc.class);
        clientRPC.scrollToEnd();
    }

    public void setHeightByRows(double rows) {
        if (rows <= 0.0) {
            throw new IllegalArgumentException("More than zero rows must be shown.");
        }
        if (Double.isInfinite(rows)) {
            throw new IllegalArgumentException("Grid doesn't support infinite heights");
        }
        if (Double.isNaN(rows)) {
            throw new IllegalArgumentException("NaN is not a valid row count");
        }
        this.getState().heightByRows = rows;
    }

    public double getHeightByRows() {
        return this.getState((boolean)false).heightByRows;
    }

    public void setHeight(float height, Sizeable.Unit unit) {
        super.setHeight(height, unit);
    }

    public void setHeightMode(HeightMode heightMode) {
        this.getState().heightMode = heightMode;
    }

    public HeightMode getHeightMode() {
        return this.getState((boolean)false).heightMode;
    }

    public void setSelectionModel(SelectionModel selectionModel) throws IllegalArgumentException {
        if (selectionModel == null) {
            throw new IllegalArgumentException("Selection model may not be null");
        }
        if (this.selectionModel != selectionModel) {
            List<Object> oldSelection;
            if (this.selectionModel != null) {
                oldSelection = this.selectionModel.getSelectedRows();
                this.selectionModel.remove();
            } else {
                oldSelection = Collections.emptyList();
            }
            this.selectionModel = selectionModel;
            selectionModel.setGrid(this);
            Collection<Object> newSelection = this.selectionModel.getSelectedRows();
            if (!SharedUtil.equals(oldSelection, newSelection)) {
                this.fireSelectionEvent(oldSelection, newSelection);
            }
            this.datasourceExtension.refreshCache();
        }
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public SelectionModel setSelectionMode(SelectionMode selectionMode) throws IllegalArgumentException {
        if (selectionMode == null) {
            throw new IllegalArgumentException("selection mode may not be null");
        }
        SelectionModel newSelectionModel = selectionMode.createModel();
        this.setSelectionModel(newSelectionModel);
        return newSelectionModel;
    }

    public boolean isSelected(Object itemId) {
        return this.selectionModel.isSelected(itemId);
    }

    public Collection<Object> getSelectedRows() {
        return this.getSelectionModel().getSelectedRows();
    }

    public Object getSelectedRow() throws IllegalStateException {
        if (this.selectionModel instanceof SelectionModel.Single) {
            return ((SelectionModel.Single)this.selectionModel).getSelectedRow();
        }
        if (this.selectionModel instanceof SelectionModel.Multi) {
            throw new IllegalStateException("Cannot get unique selected row: Grid is in multiselect mode (the current selection model is " + this.selectionModel.getClass().getName() + ").");
        }
        if (this.selectionModel instanceof SelectionModel.None) {
            throw new IllegalStateException("Cannot get selected row: Grid selection is disabled (the current selection model is " + this.selectionModel.getClass().getName() + ").");
        }
        throw new IllegalStateException("Cannot get selected row: Grid selection model does not implement " + SelectionModel.Single.class.getName() + " or " + SelectionModel.Multi.class.getName() + "(the current model is " + this.selectionModel.getClass().getName() + ").");
    }

    public boolean select(Object itemId) throws IllegalArgumentException, IllegalStateException {
        if (this.selectionModel instanceof SelectionModel.Single) {
            return ((SelectionModel.Single)this.selectionModel).select(itemId);
        }
        if (this.selectionModel instanceof SelectionModel.Multi) {
            return ((SelectionModel.Multi)this.selectionModel).select(itemId);
        }
        if (this.selectionModel instanceof SelectionModel.None) {
            throw new IllegalStateException("Cannot select row '" + itemId + "': Grid selection is disabled " + "(the current selection model is " + this.selectionModel.getClass().getName() + ").");
        }
        throw new IllegalStateException("Cannot select row '" + itemId + "': Grid selection model does not implement " + SelectionModel.Single.class.getName() + " or " + SelectionModel.Multi.class.getName() + "(the current model is " + this.selectionModel.getClass().getName() + ").");
    }

    public boolean deselect(Object itemId) throws IllegalStateException {
        if (this.selectionModel instanceof SelectionModel.Single) {
            if (this.isSelected(itemId)) {
                return ((SelectionModel.Single)this.selectionModel).select(null);
            }
            return false;
        }
        if (this.selectionModel instanceof SelectionModel.Multi) {
            return ((SelectionModel.Multi)this.selectionModel).deselect(itemId);
        }
        if (this.selectionModel instanceof SelectionModel.None) {
            throw new IllegalStateException("Cannot deselect row '" + itemId + "': Grid selection is disabled " + "(the current selection model is " + this.selectionModel.getClass().getName() + ").");
        }
        throw new IllegalStateException("Cannot deselect row '" + itemId + "': Grid selection model does not implement " + SelectionModel.Single.class.getName() + " or " + SelectionModel.Multi.class.getName() + "(the current model is " + this.selectionModel.getClass().getName() + ").");
    }

    public boolean deselectAll() throws IllegalStateException {
        if (this.selectionModel instanceof SelectionModel.Single) {
            if (this.getSelectedRow() != null) {
                return this.deselect(this.getSelectedRow());
            }
            return false;
        }
        if (this.selectionModel instanceof SelectionModel.Multi) {
            return ((SelectionModel.Multi)this.selectionModel).deselectAll();
        }
        if (this.selectionModel instanceof SelectionModel.None) {
            throw new IllegalStateException("Cannot deselect all rows: Grid selection is disabled (the current selection model is " + this.selectionModel.getClass().getName() + ").");
        }
        throw new IllegalStateException("Cannot deselect all rows: Grid selection model does not implement " + SelectionModel.Single.class.getName() + " or " + SelectionModel.Multi.class.getName() + "(the current model is " + this.selectionModel.getClass().getName() + ").");
    }

    public void fireSelectionEvent(Collection<Object> oldSelection, Collection<Object> newSelection) {
        this.fireEvent(new SelectionEvent(this, oldSelection, newSelection));
    }

    @Override
    public void addSelectionListener(SelectionEvent.SelectionListener listener) {
        this.addListener(SelectionEvent.class, listener, SELECTION_CHANGE_METHOD);
    }

    @Override
    public void removeSelectionListener(SelectionEvent.SelectionListener listener) {
        this.removeListener(SelectionEvent.class, listener, SELECTION_CHANGE_METHOD);
    }

    private void fireColumnReorderEvent(boolean userOriginated) {
        this.fireEvent((EventObject)((Object)new ColumnReorderEvent(this, userOriginated)));
    }

    public void addColumnReorderListener(ColumnReorderListener listener) {
        this.addListener(ColumnReorderEvent.class, listener, COLUMN_REORDER_METHOD);
    }

    public void removeColumnReorderListener(ColumnReorderListener listener) {
        this.removeListener(ColumnReorderEvent.class, listener, COLUMN_REORDER_METHOD);
    }

    private void fireColumnResizeEvent(Column column, boolean userOriginated) {
        this.fireEvent((EventObject)((Object)new ColumnResizeEvent(this, column, userOriginated)));
    }

    public void addColumnResizeListener(ColumnResizeListener listener) {
        this.addListener(ColumnResizeEvent.class, listener, COLUMN_RESIZE_METHOD);
    }

    public void removeColumnResizeListener(ColumnResizeListener listener) {
        this.removeListener(ColumnResizeEvent.class, listener, COLUMN_RESIZE_METHOD);
    }

    KeyMapper<Object> getKeyMapper() {
        return this.datasourceExtension.getKeyMapper();
    }

    void addRenderer(Renderer<?> renderer) {
        this.addExtension(renderer);
    }

    public void sort(Sort s) {
        this.setSortOrder(s.build());
    }

    public void sort(Object propertyId) {
        this.sort(propertyId, SortDirection.ASCENDING);
    }

    public void sort(Object propertyId, SortDirection direction) {
        this.sort(Sort.by(propertyId, direction));
    }

    public void clearSortOrder() {
        this.sortOrder.clear();
        this.sort(false);
    }

    public void setSortOrder(List<SortOrder> order) {
        this.setSortOrder(order, false);
    }

    private void setSortOrder(List<SortOrder> order, boolean userOriginated) throws IllegalStateException, IllegalArgumentException {
        if (!(this.getContainerDataSource() instanceof Container.Sortable)) {
            throw new IllegalStateException("Attached container is not sortable (does not implement Container.Sortable)");
        }
        if (order == null) {
            throw new IllegalArgumentException("Order list may not be null!");
        }
        this.sortOrder.clear();
        Collection<?> sortableProps = ((Container.Sortable)((Object)this.getContainerDataSource())).getSortableContainerPropertyIds();
        for (SortOrder o : order) {
            if (sortableProps.contains(o.getPropertyId())) continue;
            throw new IllegalArgumentException("Property " + o.getPropertyId() + " does not exist or is not sortable in the current container");
        }
        this.sortOrder.addAll(order);
        this.sort(userOriginated);
    }

    public List<SortOrder> getSortOrder() {
        return Collections.unmodifiableList(this.sortOrder);
    }

    private void sort(boolean userOriginated) {
        Container.Indexed c = this.getContainerDataSource();
        if (c instanceof Container.Sortable) {
            Container.Sortable cs = (Container.Sortable)((Object)c);
            int items = this.sortOrder.size();
            Object[] propertyIds = new Object[items];
            boolean[] directions = new boolean[items];
            SortDirection[] stateDirs = new SortDirection[items];
            block4: for (int i = 0; i < items; ++i) {
                SortOrder order = this.sortOrder.get(i);
                stateDirs[i] = order.getDirection();
                propertyIds[i] = order.getPropertyId();
                switch (order.getDirection()) {
                    case ASCENDING: {
                        directions[i] = true;
                        continue block4;
                    }
                    case DESCENDING: {
                        directions[i] = false;
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException("getDirection() of " + order + " returned an unexpected value");
                    }
                }
            }
            cs.sort(propertyIds, directions);
            if (this.columns.keySet().containsAll(Arrays.asList(propertyIds))) {
                String[] columnKeys = new String[items];
                for (int i = 0; i < items; ++i) {
                    columnKeys[i] = this.columnKeys.key(propertyIds[i]);
                }
                this.getState().sortColumns = columnKeys;
                this.getState((boolean)false).sortDirs = stateDirs;
            } else {
                this.getState().sortColumns = new String[0];
                this.getState((boolean)false).sortDirs = new SortDirection[0];
            }
        } else {
            throw new IllegalStateException("Container is not sortable (does not implement Container.Sortable)");
        }
        this.fireEvent((EventObject)((Object)new SortEvent((Component)this, new ArrayList<SortOrder>(this.sortOrder), userOriginated)));
    }

    @Override
    public Registration addSortListener(SortEvent.SortListener listener) {
        this.addListener(SortEvent.class, listener, SORT_ORDER_CHANGE_METHOD);
        return (Registration & Serializable)() -> this.removeListener(SortEvent.class, listener, SORT_ORDER_CHANGE_METHOD);
    }

    @Override
    public void removeSortListener(SortEvent.SortListener listener) {
        this.removeListener(SortEvent.class, listener, SORT_ORDER_CHANGE_METHOD);
    }

    protected Header getHeader() {
        return this.header;
    }

    public HeaderRow getHeaderRow(int rowIndex) {
        return (HeaderRow)this.header.getRow(rowIndex);
    }

    public HeaderRow addHeaderRowAt(int index) {
        return (HeaderRow)this.header.addRowAt(index);
    }

    public HeaderRow appendHeaderRow() {
        return (HeaderRow)this.header.appendRow();
    }

    public HeaderRow getDefaultHeaderRow() {
        return this.header.getDefaultRow();
    }

    public int getHeaderRowCount() {
        return this.header.getRowCount();
    }

    public HeaderRow prependHeaderRow() {
        return (HeaderRow)this.header.prependRow();
    }

    public void removeHeaderRow(HeaderRow row) {
        this.header.removeRow(row);
    }

    public void removeHeaderRow(int rowIndex) {
        this.header.removeRow(rowIndex);
    }

    public void setDefaultHeaderRow(HeaderRow row) {
        this.header.setDefaultRow(row);
    }

    public void setHeaderVisible(boolean visible) {
        this.header.setVisible(visible);
    }

    public boolean isHeaderVisible() {
        return this.header.isVisible();
    }

    protected Footer getFooter() {
        return this.footer;
    }

    public FooterRow getFooterRow(int rowIndex) {
        return (FooterRow)this.footer.getRow(rowIndex);
    }

    public FooterRow addFooterRowAt(int index) {
        return (FooterRow)this.footer.addRowAt(index);
    }

    public FooterRow appendFooterRow() {
        return (FooterRow)this.footer.appendRow();
    }

    public int getFooterRowCount() {
        return this.footer.getRowCount();
    }

    public FooterRow prependFooterRow() {
        return (FooterRow)this.footer.prependRow();
    }

    public void removeFooterRow(FooterRow row) {
        this.footer.removeRow(row);
    }

    public void removeFooterRow(int rowIndex) {
        this.footer.removeRow(rowIndex);
    }

    public void setFooterVisible(boolean visible) {
        this.footer.setVisible(visible);
    }

    public boolean isFooterVisible() {
        return this.footer.isVisible();
    }

    private void addComponent(Component c) {
        this.extensionComponents.add(c);
        c.setParent((HasComponents)this);
        this.markAsDirty();
    }

    private void removeComponent(Component c) {
        this.extensionComponents.remove(c);
        c.setParent(null);
        this.markAsDirty();
    }

    public Iterator<Component> iterator() {
        LinkedHashSet<Component> componentList = new LinkedHashSet<Component>();
        Header header = this.getHeader();
        for (int i = 0; i < header.getRowCount(); ++i) {
            HeaderRow row = (HeaderRow)header.getRow(i);
            for (Object propId : this.columns.keySet()) {
                HeaderCell cell = (HeaderCell)row.getCell(propId);
                if (cell.getCellState().type != GridStaticCellType.WIDGET) continue;
                componentList.add(cell.getComponent());
            }
        }
        Footer footer = this.getFooter();
        for (int i = 0; i < footer.getRowCount(); ++i) {
            FooterRow row = (FooterRow)footer.getRow(i);
            for (Object propId : this.columns.keySet()) {
                FooterCell cell = (FooterCell)row.getCell(propId);
                if (cell.getCellState().type != GridStaticCellType.WIDGET) continue;
                componentList.add(cell.getComponent());
            }
        }
        componentList.addAll(this.getEditorFields());
        componentList.addAll(this.extensionComponents);
        return componentList.iterator();
    }

    public boolean isRendered(Component childComponent) {
        if (this.getEditorFields().contains(childComponent)) {
            return this.isEditorActive();
        }
        return true;
    }

    EditorClientRpc getEditorRpc() {
        return (EditorClientRpc)this.getRpcProxy(EditorClientRpc.class);
    }

    public void setCellDescriptionGenerator(CellDescriptionGenerator generator) {
        this.cellDescriptionGenerator = generator;
        this.getState().hasDescriptions = generator != null || this.rowDescriptionGenerator != null;
        this.datasourceExtension.refreshCache();
    }

    public CellDescriptionGenerator getCellDescriptionGenerator() {
        return this.cellDescriptionGenerator;
    }

    public void setRowDescriptionGenerator(RowDescriptionGenerator generator) {
        this.rowDescriptionGenerator = generator;
        this.getState().hasDescriptions = generator != null || this.cellDescriptionGenerator != null;
        this.datasourceExtension.refreshCache();
    }

    public RowDescriptionGenerator getRowDescriptionGenerator() {
        return this.rowDescriptionGenerator;
    }

    public void setCellStyleGenerator(CellStyleGenerator cellStyleGenerator) {
        this.cellStyleGenerator = cellStyleGenerator;
        this.datasourceExtension.refreshCache();
    }

    public CellStyleGenerator getCellStyleGenerator() {
        return this.cellStyleGenerator;
    }

    public void setRowStyleGenerator(RowStyleGenerator rowStyleGenerator) {
        this.rowStyleGenerator = rowStyleGenerator;
        this.datasourceExtension.refreshCache();
    }

    public RowStyleGenerator getRowStyleGenerator() {
        return this.rowStyleGenerator;
    }

    public Object addRow(Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        Container.Indexed dataSource = this.getContainerDataSource();
        List columnOrder = this.getState((boolean)false).columnOrder;
        if (values.length != columnOrder.size()) {
            throw new IllegalArgumentException("There are " + columnOrder.size() + " visible columns, but " + values.length + " cell values were provided.");
        }
        for (int i = 0; i < columnOrder.size(); ++i) {
            Object propertyId = this.getPropertyIdByColumnId((String)columnOrder.get(i));
            Class<?> propertyType = dataSource.getType(propertyId);
            if (values[i] == null || propertyType.isInstance(values[i])) continue;
            throw new IllegalArgumentException("Parameter " + i + "(" + values[i] + ") is not an instance of " + propertyType.getCanonicalName());
        }
        Object itemId = dataSource.addItem();
        try {
            Item item = dataSource.getItem(itemId);
            for (int i = 0; i < columnOrder.size(); ++i) {
                Object propertyId = this.getPropertyIdByColumnId((String)columnOrder.get(i));
                Property property = item.getItemProperty(propertyId);
                property.setValue(values[i]);
            }
        }
        catch (RuntimeException e) {
            try {
                dataSource.removeItem(itemId);
            }
            catch (Exception e2) {
                Grid.getLogger().log(Level.SEVERE, "Error recovering from exception in addRow", e);
            }
            throw e;
        }
        return itemId;
    }

    public void refreshRows(Object ... itemIds) {
        for (Object itemId : itemIds) {
            this.datasourceExtension.updateRowData(itemId);
        }
    }

    public void refreshAllRows() {
        this.datasourceExtension.refreshCache();
    }

    private static Logger getLogger() {
        return Logger.getLogger(Grid.class.getName());
    }

    public void setEditorEnabled(boolean isEnabled) throws IllegalStateException {
        if (this.isEditorActive()) {
            throw new IllegalStateException("Cannot disable the editor while an item (" + this.getEditedItemId() + ") is being edited");
        }
        if (this.isEditorEnabled() != isEnabled) {
            this.getState().editorEnabled = isEnabled;
        }
    }

    public boolean isEditorEnabled() {
        return this.getState((boolean)false).editorEnabled;
    }

    public Object getEditedItemId() {
        return this.editedItemId;
    }

    public FieldGroup getEditorFieldGroup() {
        return this.editorFieldGroup;
    }

    public void setEditorFieldGroup(FieldGroup fieldGroup) {
        if (this.isEditorActive()) {
            throw new IllegalStateException("Cannot change field group while an item (" + this.getEditedItemId() + ") is being edited");
        }
        this.editorFieldGroup = fieldGroup;
    }

    public boolean isEditorActive() {
        return this.editorActive;
    }

    private void checkColumnExists(Object propertyId) {
        if (this.getColumn(propertyId) == null) {
            throw new IllegalArgumentException("There is no column with the property id " + propertyId);
        }
    }

    private Field<?> getEditorField(Object propertyId) {
        this.checkColumnExists(propertyId);
        if (!this.getColumn(propertyId).isEditable()) {
            return null;
        }
        Field<?> editor = this.editorFieldGroup.getField(propertyId);
        if (editor == null && (editor = this.editorFields.get(propertyId)) != null) {
            this.editorFieldGroup.bind(editor, propertyId);
        }
        try {
            if (editor == null) {
                editor = this.editorFieldGroup.buildAndBind(propertyId);
            }
        }
        finally {
            if (editor == null) {
                editor = this.editorFieldGroup.getField(propertyId);
            }
            if (editor != null && editor.getParent() != this) {
                assert (editor.getParent() == null);
                editor.setParent((HasComponents)this);
            }
        }
        return editor;
    }

    public void editItem(Object itemId) throws IllegalStateException, IllegalArgumentException {
        if (!this.isEditorEnabled()) {
            throw new IllegalStateException("Item editor is not enabled");
        }
        if (this.isEditorBuffered() && this.editedItemId != null) {
            throw new IllegalStateException("Editing item " + itemId + " failed. Item editor is already editing item " + this.editedItemId);
        }
        if (!this.getContainerDataSource().containsId(itemId)) {
            throw new IllegalArgumentException("Item with id " + itemId + " not found in current container");
        }
        this.editedItemId = itemId;
        this.getEditorRpc().bind(this.getContainerDataSource().indexOfId(itemId));
    }

    protected void doEditItem() {
        Item item = this.getContainerDataSource().getItem(this.editedItemId);
        this.editorFieldGroup.setItemDataSource(item);
        for (Column column : this.getColumns()) {
            column.getState().editorConnector = item.getItemProperty(column.getPropertyId()) == null ? null : this.getEditorField(column.getPropertyId());
        }
        this.editorActive = true;
        for (Field field : this.getEditorFields()) {
            field.markAsDirtyRecursive();
        }
        if (this.datasource instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)this.datasource)).addItemSetChangeListener(this.editorClosingItemSetListener);
        }
    }

    private void setEditorField(Object propertyId, Field<?> field) {
        this.checkColumnExists(propertyId);
        Field<?> oldField = this.editorFieldGroup.getField(propertyId);
        if (oldField != null) {
            this.editorFieldGroup.unbind(oldField);
            oldField.setParent(null);
        }
        if (field != null) {
            field.setParent((HasComponents)this);
            this.editorFieldGroup.bind(field, propertyId);
        }
        this.editorFields.put(propertyId, field);
    }

    public void saveEditor() throws FieldGroup.CommitException {
        try {
            this.editorSaving = true;
            this.editorFieldGroup.commit();
        }
        finally {
            this.editorSaving = false;
        }
    }

    public void cancelEditor() {
        if (this.editorSaving) {
            return;
        }
        if (this.isEditorActive()) {
            this.getEditorRpc().cancel(this.getContainerDataSource().indexOfId(this.editedItemId));
            this.doCancelEditor();
        }
    }

    protected void doCancelEditor() {
        this.editedItemId = null;
        this.editorActive = false;
        this.editorFieldGroup.discard();
        this.editorFieldGroup.setItemDataSource(null);
        if (this.datasource instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)this.datasource)).removeItemSetChangeListener(this.editorClosingItemSetListener);
        }
        this.markAsDirty();
    }

    void resetEditor() {
        if (this.isEditorActive()) {
            this.cancelEditor();
        }
        for (Field<?> editor : this.getEditorFields()) {
            editor.setParent(null);
        }
        this.editedItemId = null;
        this.editorActive = false;
        this.editorFieldGroup = new CustomFieldGroup();
    }

    Collection<Field<?>> getEditorFields() {
        Collection<Field<?>> fields = this.editorFieldGroup.getFields();
        assert (this.allAttached(fields));
        return fields;
    }

    private boolean allAttached(Collection<? extends Component> components) {
        for (Component component : components) {
            if (component.getParent() == this) continue;
            return false;
        }
        return true;
    }

    public void setEditorFieldFactory(FieldGroupFieldFactory fieldFactory) {
        this.editorFieldGroup.setFieldFactory(fieldFactory);
    }

    public void setEditorErrorHandler(EditorErrorHandler editorErrorHandler) throws IllegalArgumentException {
        if (editorErrorHandler == null) {
            throw new IllegalArgumentException("The error handler cannot be null");
        }
        this.editorErrorHandler = editorErrorHandler;
    }

    public EditorErrorHandler getEditorErrorHandler() {
        return this.editorErrorHandler;
    }

    public FieldGroupFieldFactory getEditorFieldFactory() {
        return this.editorFieldGroup.getFieldFactory();
    }

    public void setEditorSaveCaption(String saveCaption) throws IllegalArgumentException {
        if (saveCaption == null) {
            throw new IllegalArgumentException("Save caption cannot be null");
        }
        this.getState().editorSaveCaption = saveCaption;
    }

    public String getEditorSaveCaption() {
        return this.getState((boolean)false).editorSaveCaption;
    }

    public void setEditorCancelCaption(String cancelCaption) throws IllegalArgumentException {
        if (cancelCaption == null) {
            throw new IllegalArgumentException("Cancel caption cannot be null");
        }
        this.getState().editorCancelCaption = cancelCaption;
    }

    public String getEditorCancelCaption() {
        return this.getState((boolean)false).editorCancelCaption;
    }

    public void setEditorBuffered(boolean editorBuffered) throws IllegalStateException {
        if (this.isEditorActive()) {
            throw new IllegalStateException("Can't change editor unbuffered mode while editor is active.");
        }
        this.getState().editorBuffered = editorBuffered;
        this.editorFieldGroup.setBuffered(editorBuffered);
    }

    public boolean isEditorBuffered() {
        return this.getState((boolean)false).editorBuffered;
    }

    @Override
    public void addItemClickListener(ItemClickEvent.ItemClickListener listener) {
        this.addListener("itemClick", ItemClickEvent.class, listener, ItemClickEvent.ITEM_CLICK_METHOD);
    }

    @Override
    @Deprecated
    public void addListener(ItemClickEvent.ItemClickListener listener) {
        this.addItemClickListener(listener);
    }

    @Override
    public void removeItemClickListener(ItemClickEvent.ItemClickListener listener) {
        this.removeListener("itemClick", ItemClickEvent.class, listener);
    }

    @Override
    @Deprecated
    public void removeListener(ItemClickEvent.ItemClickListener listener) {
        this.removeItemClickListener(listener);
    }

    public void recalculateColumnWidths() {
        ((GridClientRpc)this.getRpcProxy(GridClientRpc.class)).recalculateColumnWidths();
    }

    public void addColumnVisibilityChangeListener(ColumnVisibilityChangeListener listener) {
        this.addListener(ColumnVisibilityChangeEvent.class, listener, COLUMN_VISIBILITY_METHOD);
    }

    public void removeColumnVisibilityChangeListener(ColumnVisibilityChangeListener listener) {
        this.removeListener(ColumnVisibilityChangeEvent.class, listener, COLUMN_VISIBILITY_METHOD);
    }

    private void fireColumnVisibilityChangeEvent(Column column, boolean hidden, boolean isUserOriginated) {
        this.fireEvent((EventObject)((Object)new ColumnVisibilityChangeEvent(this, column, hidden, isUserOriginated)));
    }

    public void setDetailsGenerator(DetailsGenerator detailsGenerator) throws IllegalArgumentException {
        this.detailComponentManager.setDetailsGenerator(detailsGenerator);
    }

    public DetailsGenerator getDetailsGenerator() {
        return this.detailComponentManager.getDetailsGenerator();
    }

    public void setDetailsVisible(Object itemId, boolean visible) {
        this.detailComponentManager.setDetailsVisible(itemId, visible);
    }

    public boolean isDetailsVisible(Object itemId) {
        return this.detailComponentManager.isDetailsVisible(itemId);
    }

    private static SelectionMode getDefaultSelectionMode() {
        return SelectionMode.SINGLE;
    }

    public void readDesign(Element design, DesignContext context) {
        super.readDesign(design, context);
        Attributes attrs = design.attributes();
        if (attrs.hasKey("editable")) {
            this.setEditorEnabled((Boolean)DesignAttributeHandler.readAttribute((String)"editable", (Attributes)attrs, Boolean.TYPE));
        }
        if (attrs.hasKey("rows")) {
            this.setHeightByRows((Double)DesignAttributeHandler.readAttribute((String)"rows", (Attributes)attrs, Double.TYPE));
            this.setHeightMode(HeightMode.ROW);
        }
        if (attrs.hasKey("selection-mode")) {
            this.setSelectionMode((SelectionMode)((Object)DesignAttributeHandler.readAttribute((String)"selection-mode", (Attributes)attrs, SelectionMode.class)));
        }
        if (design.children().size() > 0) {
            if (design.children().size() > 1 || !design.child(0).tagName().equals("table")) {
                throw new DesignException("Grid needs to have a table element as its only child");
            }
            Element table = design.child(0);
            Elements colgroups = table.getElementsByTag("colgroup");
            if (colgroups.size() != 1) {
                throw new DesignException("Table element in declarative Grid needs to have a colgroup defining the columns used in Grid");
            }
            int i = 0;
            for (Element col : ((Element)colgroups.get(0)).getElementsByTag("col")) {
                String propertyId = (String)DesignAttributeHandler.readAttribute((String)"property-id", (Attributes)col.attributes(), (Object)("property-" + i), String.class);
                this.addColumn(propertyId, String.class).readDesign(col, context);
                ++i;
            }
            for (Element child : table.children()) {
                if (child.tagName().equals("thead")) {
                    this.header.readDesign(child, context);
                    continue;
                }
                if (child.tagName().equals("tbody")) {
                    for (Element row : child.children()) {
                        Elements cells = row.children();
                        Object[] data = new String[cells.size()];
                        for (int c = 0; c < cells.size(); ++c) {
                            data[c] = ((Element)cells.get(c)).html();
                        }
                        this.addRow(data);
                    }
                    for (Column c : this.getColumns()) {
                        c.setRenderer(new HtmlRenderer());
                    }
                    continue;
                }
                if (!child.tagName().equals("tfoot")) continue;
                this.footer.readDesign(child, context);
            }
        }
        if (attrs.hasKey("frozen-columns")) {
            this.setFrozenColumnCount((Integer)DesignAttributeHandler.readAttribute((String)"frozen-columns", (Attributes)attrs, Integer.TYPE));
        }
    }

    public void writeDesign(Element design, DesignContext context) {
        super.writeDesign(design, context);
        Attributes attrs = design.attributes();
        Grid def = (Grid)context.getDefaultInstance((Component)this);
        DesignAttributeHandler.writeAttribute((String)"editable", (Attributes)attrs, (Object)this.isEditorEnabled(), (Object)def.isEditorEnabled(), Boolean.TYPE, (DesignContext)context);
        DesignAttributeHandler.writeAttribute((String)"frozen-columns", (Attributes)attrs, (Object)this.getFrozenColumnCount(), (Object)def.getFrozenColumnCount(), Integer.TYPE, (DesignContext)context);
        if (this.getHeightMode() == HeightMode.ROW) {
            DesignAttributeHandler.writeAttribute((String)"rows", (Attributes)attrs, (Object)this.getHeightByRows(), (Object)def.getHeightByRows(), Double.TYPE, (DesignContext)context);
        }
        SelectionMode selectionMode = null;
        if (this.selectionModel.getClass().equals(SingleSelectionModel.class)) {
            selectionMode = SelectionMode.SINGLE;
        } else if (this.selectionModel.getClass().equals(MultiSelectionModel.class)) {
            selectionMode = SelectionMode.MULTI;
        } else if (this.selectionModel.getClass().equals(NoSelectionModel.class)) {
            selectionMode = SelectionMode.NONE;
        }
        assert (selectionMode != null) : "Unexpected selection model " + this.selectionModel.getClass().getName();
        DesignAttributeHandler.writeAttribute((String)"selection-mode", (Attributes)attrs, (Object)((Object)selectionMode), (Object)((Object)Grid.getDefaultSelectionMode()), SelectionMode.class, (DesignContext)context);
        if (this.columns.isEmpty()) {
            return;
        }
        Element tableElement = design.appendElement("table");
        Element colGroup = tableElement.appendElement("colgroup");
        List<Column> columnOrder = this.getColumns();
        for (int i = 0; i < columnOrder.size(); ++i) {
            Column column = columnOrder.get(i);
            Element colElement = colGroup.appendElement("col");
            column.writeDesign(colElement, context);
        }
        this.header.writeDesign(tableElement.appendElement("thead"), context);
        if (context.shouldWriteData((Component)this)) {
            Element bodyElement = tableElement.appendElement("tbody");
            for (Object itemId : this.datasource.getItemIds()) {
                Element tableRow = bodyElement.appendElement("tr");
                for (Column c : this.getColumns()) {
                    Object value = this.datasource.getItem(itemId).getItemProperty(c.getPropertyId()).getValue();
                    tableRow.appendElement("td").append(value != null ? DesignFormatter.encodeForTextNode((String)value.toString()) : "");
                }
            }
        }
        if (this.footer.getRowCount() > 0) {
            this.footer.writeDesign(tableElement.appendElement("tfoot"), context);
        }
    }

    @Override
    public void addBlurListener(FieldEvents.BlurListener listener) {
        this.addListener("blur", FieldEvents.BlurEvent.class, listener, FieldEvents.BlurListener.blurMethod);
    }

    @Override
    public void removeBlurListener(FieldEvents.BlurListener listener) {
        this.removeListener("blur", FieldEvents.BlurEvent.class, listener);
    }

    @Override
    public void addFocusListener(FieldEvents.FocusListener listener) {
        this.addListener("focus", FieldEvents.FocusEvent.class, listener, FieldEvents.FocusListener.focusMethod);
    }

    @Override
    public void removeFocusListener(FieldEvents.FocusListener listener) {
        this.removeListener("focus", FieldEvents.FocusEvent.class, listener);
    }

    public void focus() {
        super.focus();
    }

    public int getTabIndex() {
        return this.getState((boolean)false).tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.getState().tabIndex = tabIndex;
    }

    protected Collection<String> getCustomAttributes() {
        Collection result = super.getCustomAttributes();
        result.add("editor-enabled");
        result.add("editable");
        result.add("frozen-column-count");
        result.add("frozen-columns");
        result.add("height-by-rows");
        result.add("rows");
        result.add("selection-mode");
        result.add("header-visible");
        result.add("footer-visible");
        result.add("editor-error-handler");
        result.add("height-mode");
        return result;
    }

    @Deprecated
    public static abstract class AbstractGridExtension
    extends AbstractExtension {
        public AbstractGridExtension() {
        }

        public AbstractGridExtension(Grid grid) {
            this.extend((AbstractClientConnector)grid);
        }

        protected void extend(AbstractClientConnector target) {
            super.extend(target);
            if (this instanceof DataGenerator) {
                this.getParentGrid().datasourceExtension.addDataGenerator((DataGenerator)((Object)this));
            }
        }

        public void remove() {
            if (this instanceof DataGenerator) {
                this.getParentGrid().datasourceExtension.removeDataGenerator((DataGenerator)((Object)this));
            }
            super.remove();
        }

        protected Object getItemId(String rowKey) {
            return this.getParentGrid().getKeyMapper().get(rowKey);
        }

        protected Column getColumn(String columnId) {
            return this.getParentGrid().getColumnByColumnId(columnId);
        }

        protected Grid getParentGrid() {
            if (this.getParent() instanceof Grid) {
                Grid grid = (Grid)this.getParent();
                return grid;
            }
            if (this.getParent() == null) {
                throw new IllegalStateException("Renderer is not attached to any parent");
            }
            throw new IllegalStateException("Renderers can be used only with Grid. Extended " + this.getParent().getClass().getSimpleName() + " instead");
        }

        protected void refreshRow(Object itemId) {
            this.getParentGrid().datasourceExtension.updateRowData(itemId);
        }

        protected void addComponentToGrid(Component c) {
            this.getParentGrid().addComponent(c);
        }

        protected void removeComponentFromGrid(Component c) {
            this.getParentGrid().removeComponent(c);
        }
    }

    @Deprecated
    public static abstract class AbstractRenderer<T>
    extends AbstractGridExtension
    implements Renderer<T> {
        private final Class<T> presentationType;
        private final String nullRepresentation;

        protected AbstractRenderer(Class<T> presentationType, String nullRepresentation) {
            this.presentationType = presentationType;
            this.nullRepresentation = nullRepresentation;
        }

        protected AbstractRenderer(Class<T> presentationType) {
            this(presentationType, null);
        }

        @Deprecated
        protected Class<Grid> getSupportedParentType() {
            return Grid.class;
        }

        @Override
        @Deprecated
        protected void extend(AbstractClientConnector target) {
            super.extend(target);
        }

        @Override
        public Class<T> getPresentationType() {
            return this.presentationType;
        }

        @Override
        public JsonValue encode(T value) {
            if (value == null) {
                return this.encode(this.getNullRepresentation(), String.class);
            }
            return this.encode(value, this.getPresentationType());
        }

        protected String getNullRepresentation() {
            return this.nullRepresentation;
        }

        protected <U> JsonValue encode(U value, Class<U> type) {
            return JsonCodec.encode(value, null, type, (ConnectorTracker)this.getUI().getConnectorTracker()).getEncodedValue();
        }

        public static <T> JsonValue encodeValue(Object modelValue, Renderer<T> renderer, Converter<?, ?> converter, Locale locale) {
            JsonValue encodedValue;
            Object presentationValue;
            Class<T> presentationType = renderer.getPresentationType();
            if (converter == null) {
                try {
                    presentationValue = presentationType.cast(modelValue);
                }
                catch (ClassCastException e) {
                    if (presentationType == String.class) {
                        presentationValue = modelValue.toString();
                    }
                    throw new Converter.ConversionException("Unable to convert value of type " + modelValue.getClass().getName() + " to presentation type " + presentationType.getName() + ". No converter is set and the types are not compatible.");
                }
            } else {
                assert (presentationType.isAssignableFrom(converter.getPresentationType()));
                Converter<?, ?> safeConverter = converter;
                presentationValue = safeConverter.convertToPresentation(modelValue, safeConverter.getPresentationType(), locale);
            }
            try {
                encodedValue = renderer.encode(presentationValue);
            }
            catch (Exception e) {
                AbstractRenderer.getLogger().log(Level.SEVERE, "Unable to encode data", e);
                encodedValue = renderer.encode(null);
            }
            return encodedValue;
        }

        private static Logger getLogger() {
            return Logger.getLogger(AbstractRenderer.class.getName());
        }
    }

    @Deprecated
    public static class Column
    implements Serializable {
        private final GridColumnState state;
        private final Grid grid;
        private final Object propertyId;
        private Converter<?, Object> converter;
        private boolean isFirstConverterAssignment = true;

        Column(Grid grid, GridColumnState state, Object propertyId) {
            this.grid = grid;
            this.state = state;
            this.propertyId = propertyId;
            this.internalSetRenderer(new TextRenderer());
        }

        GridColumnState getState() {
            return this.state;
        }

        public Object getPropertyId() {
            return this.propertyId;
        }

        public String getHeaderCaption() throws IllegalStateException {
            this.checkColumnIsAttached();
            return this.state.headerCaption;
        }

        public Column setHeaderCaption(String caption) throws IllegalStateException {
            this.checkColumnIsAttached();
            if (caption == null) {
                caption = "";
            }
            this.state.headerCaption = caption;
            HeaderRow row = this.grid.getHeader().getDefaultRow();
            if (row != null) {
                ((HeaderCell)row.getCell(this.grid.getPropertyIdByColumnId(this.state.id))).setText(caption);
            }
            return this;
        }

        public String getHidingToggleCaption() throws IllegalStateException {
            this.checkColumnIsAttached();
            return this.state.hidingToggleCaption;
        }

        public Column setHidingToggleCaption(String hidingToggleCaption) throws IllegalStateException {
            this.checkColumnIsAttached();
            this.state.hidingToggleCaption = hidingToggleCaption;
            this.grid.markAsDirty();
            return this;
        }

        public double getWidth() throws IllegalStateException {
            this.checkColumnIsAttached();
            return this.state.width;
        }

        public Column setWidth(double pixelWidth) throws IllegalStateException, IllegalArgumentException {
            this.checkColumnIsAttached();
            if (pixelWidth < 0.0) {
                throw new IllegalArgumentException("Pixel width should be greated than 0 (in " + this.toString() + ")");
            }
            if (this.state.width != pixelWidth) {
                this.state.width = pixelWidth;
                this.grid.markAsDirty();
                this.grid.fireColumnResizeEvent(this, false);
            }
            return this;
        }

        public boolean isWidthUndefined() {
            this.checkColumnIsAttached();
            return this.state.width < 0.0;
        }

        public Column setWidthUndefined() {
            this.checkColumnIsAttached();
            if (!this.isWidthUndefined()) {
                this.state.width = -1.0;
                this.grid.markAsDirty();
                this.grid.fireColumnResizeEvent(this, false);
            }
            return this;
        }

        protected void checkColumnIsAttached() throws IllegalStateException {
            if (this.grid.getColumnByColumnId(this.state.id) == null) {
                throw new IllegalStateException("Column no longer exists.");
            }
        }

        public Column setLastFrozenColumn() {
            this.checkColumnIsAttached();
            this.grid.setFrozenColumnCount(this.grid.getState((boolean)false).columnOrder.indexOf(this.getState().id) + 1);
            return this;
        }

        public Column setRenderer(Renderer<?> renderer) {
            if (!this.internalSetRenderer(renderer)) {
                throw new IllegalArgumentException("Could not find a converter for converting from the model type " + this.getModelType() + " to the renderer presentation type " + renderer.getPresentationType() + " (in " + this.toString() + ")");
            }
            return this;
        }

        public <T> Column setRenderer(Renderer<T> renderer, Converter<? extends T, ?> converter) {
            if (renderer.getParent() != null) {
                throw new IllegalArgumentException("Cannot set a renderer that is already connected to a grid column (in " + this.toString() + ")");
            }
            if (this.getRenderer() != null) {
                this.grid.removeExtension(this.getRenderer());
            }
            this.grid.addRenderer(renderer);
            this.state.rendererConnector = renderer;
            this.setConverter(converter);
            return this;
        }

        public Column setConverter(Converter<?, ?> converter) throws IllegalArgumentException {
            Class<?> modelType = this.getModelType();
            if (converter != null) {
                if (!converter.getModelType().isAssignableFrom(modelType)) {
                    throw new IllegalArgumentException("The converter model type " + converter.getModelType() + " is not compatible with the property type " + modelType + " (in " + this.toString() + ")");
                }
                if (!this.getRenderer().getPresentationType().isAssignableFrom(converter.getPresentationType())) {
                    throw new IllegalArgumentException("The converter presentation type " + converter.getPresentationType() + " is not compatible with the renderer presentation type " + this.getRenderer().getPresentationType() + " (in " + this.toString() + ")");
                }
            } else {
                Class<?> rendererPresentationType = this.getRenderer().getPresentationType();
                if (!this.isFirstConverterAssignment && !rendererPresentationType.isAssignableFrom(modelType)) {
                    throw new IllegalArgumentException("Cannot remove converter, as renderer's presentation type " + rendererPresentationType.getName() + " and column's " + "model " + modelType.getName() + " type aren't " + "directly compatible with each other (in " + this.toString() + ")");
                }
            }
            this.isFirstConverterAssignment = false;
            Converter<?, ?> castConverter = converter;
            this.converter = castConverter;
            return this;
        }

        public Renderer<?> getRenderer() {
            return (Renderer)this.getState().rendererConnector;
        }

        public Converter<?, ?> getConverter() {
            return this.converter;
        }

        private <T> boolean internalSetRenderer(Renderer<T> renderer) {
            Converter<Object, ?> converter = this.isCompatibleWithProperty(renderer, this.getConverter()) ? this.getConverter() : ConverterUtil.getConverter(renderer.getPresentationType(), this.getModelType(), this.getSession());
            this.setRenderer(renderer, converter);
            return this.isCompatibleWithProperty(renderer, converter);
        }

        private VaadinSession getSession() {
            UI ui = this.grid.getUI();
            return ui != null ? ui.getSession() : null;
        }

        private boolean isCompatibleWithProperty(Renderer<?> renderer, Converter<?, ?> converter) {
            Class<?> type = converter == null ? this.getModelType() : converter.getPresentationType();
            return renderer.getPresentationType().isAssignableFrom(type);
        }

        private Class<?> getModelType() {
            return this.grid.getContainerDataSource().getType(this.grid.getPropertyIdByColumnId(this.state.id));
        }

        public Column setSortable(boolean sortable) {
            this.checkColumnIsAttached();
            if (sortable) {
                if (!(this.grid.datasource instanceof Container.Sortable)) {
                    throw new IllegalStateException("Can't set column " + this.toString() + " sortable. The Container of Grid does not implement Sortable");
                }
                if (!((Container.Sortable)((Object)this.grid.datasource)).getSortableContainerPropertyIds().contains(this.propertyId)) {
                    throw new IllegalStateException("Can't set column " + this.toString() + " sortable. Container doesn't support sorting by property " + this.propertyId);
                }
            }
            this.state.sortable = sortable;
            this.grid.markAsDirty();
            return this;
        }

        public boolean isSortable() {
            return this.state.sortable;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[propertyId:" + this.grid.getPropertyIdByColumnId(this.state.id) + "]";
        }

        public Column setExpandRatio(int expandRatio) throws IllegalStateException {
            this.checkColumnIsAttached();
            this.getState().expandRatio = expandRatio;
            this.grid.markAsDirty();
            return this;
        }

        public int getExpandRatio() {
            return this.getState().expandRatio;
        }

        public Column clearExpandRatio() throws IllegalStateException {
            return this.setExpandRatio(-1);
        }

        public Column setMinimumWidth(double pixels) throws IllegalStateException {
            this.checkColumnIsAttached();
            double maxwidth = this.getMaximumWidth();
            if (pixels >= 0.0 && pixels > maxwidth && maxwidth >= 0.0) {
                throw new IllegalArgumentException("New minimum width (" + pixels + ") was greater than maximum width (" + maxwidth + ")");
            }
            this.getState().minWidth = pixels;
            this.grid.markAsDirty();
            return this;
        }

        public double getMinimumWidth() {
            return this.getState().minWidth;
        }

        public Column setMaximumWidth(double pixels) {
            this.checkColumnIsAttached();
            double minwidth = this.getMinimumWidth();
            if (pixels >= 0.0 && pixels < minwidth && minwidth >= 0.0) {
                throw new IllegalArgumentException("New maximum width (" + pixels + ") was less than minimum width (" + minwidth + ")");
            }
            this.getState().maxWidth = pixels;
            this.grid.markAsDirty();
            return this;
        }

        public double getMaximumWidth() {
            return this.getState().maxWidth;
        }

        public Column setEditable(boolean editable) {
            this.checkColumnIsAttached();
            if (this.grid.isEditorActive()) {
                throw new IllegalStateException("Cannot change column editable status while the editor is active");
            }
            this.getState().editable = editable;
            this.grid.markAsDirty();
            return this;
        }

        public boolean isEditable() {
            return this.getState().editable;
        }

        public Column setEditorField(Field<?> editor) {
            this.grid.setEditorField(this.getPropertyId(), editor);
            return this;
        }

        public Field<?> getEditorField() {
            return this.grid.getEditorField(this.getPropertyId());
        }

        public Column setHidden(boolean hidden) {
            if (hidden != this.getState().hidden) {
                this.getState().hidden = hidden;
                this.grid.markAsDirty();
                this.grid.fireColumnVisibilityChangeEvent(this, hidden, false);
            }
            return this;
        }

        public boolean isHidden() {
            return this.getState().hidden;
        }

        public Column setHidable(boolean hidable) {
            if (hidable != this.getState().hidable) {
                this.getState().hidable = hidable;
                this.grid.markAsDirty();
            }
            return this;
        }

        public boolean isHidable() {
            return this.getState().hidable;
        }

        public Column setResizable(boolean resizable) {
            if (resizable != this.getState().resizable) {
                this.getState().resizable = resizable;
                this.grid.markAsDirty();
            }
            return this;
        }

        public boolean isResizable() {
            return this.getState().resizable;
        }

        protected void writeDesign(Element design, DesignContext designContext) {
            Attributes attributes = design.attributes();
            GridColumnState def = new GridColumnState();
            DesignAttributeHandler.writeAttribute((String)"property-id", (Attributes)attributes, (Object)this.getPropertyId(), null, Object.class, (DesignContext)designContext);
            DesignAttributeHandler.writeAttribute((String)"sortable", (Attributes)attributes, (Object)this.isSortable(), null, Boolean.TYPE, (DesignContext)designContext);
            DesignAttributeHandler.writeAttribute((String)"editable", (Attributes)attributes, (Object)this.isEditable(), (Object)def.editable, Boolean.TYPE, (DesignContext)designContext);
            DesignAttributeHandler.writeAttribute((String)"resizable", (Attributes)attributes, (Object)this.isResizable(), (Object)def.resizable, Boolean.TYPE, (DesignContext)designContext);
            DesignAttributeHandler.writeAttribute((String)"hidable", (Attributes)attributes, (Object)this.isHidable(), (Object)def.hidable, Boolean.TYPE, (DesignContext)designContext);
            DesignAttributeHandler.writeAttribute((String)"hidden", (Attributes)attributes, (Object)this.isHidden(), (Object)def.hidden, Boolean.TYPE, (DesignContext)designContext);
            DesignAttributeHandler.writeAttribute((String)"hiding-toggle-caption", (Attributes)attributes, (Object)this.getHidingToggleCaption(), null, String.class, (DesignContext)designContext);
            DesignAttributeHandler.writeAttribute((String)"width", (Attributes)attributes, (Object)this.getWidth(), (Object)def.width, Double.class, (DesignContext)designContext);
            DesignAttributeHandler.writeAttribute((String)"min-width", (Attributes)attributes, (Object)this.getMinimumWidth(), (Object)def.minWidth, Double.class, (DesignContext)designContext);
            DesignAttributeHandler.writeAttribute((String)"max-width", (Attributes)attributes, (Object)this.getMaximumWidth(), (Object)def.maxWidth, Double.class, (DesignContext)designContext);
            DesignAttributeHandler.writeAttribute((String)"expand", (Attributes)attributes, (Object)this.getExpandRatio(), (Object)def.expandRatio, Integer.class, (DesignContext)designContext);
        }

        protected void readDesign(Element design, DesignContext designContext) {
            Attributes attributes = design.attributes();
            if (design.hasAttr("sortable")) {
                this.setSortable((Boolean)DesignAttributeHandler.readAttribute((String)"sortable", (Attributes)attributes, Boolean.TYPE));
            }
            if (design.hasAttr("editable")) {
                this.setEditable((Boolean)DesignAttributeHandler.readAttribute((String)"editable", (Attributes)attributes, Boolean.TYPE));
            }
            if (design.hasAttr("resizable")) {
                this.setResizable((Boolean)DesignAttributeHandler.readAttribute((String)"resizable", (Attributes)attributes, Boolean.TYPE));
            }
            if (design.hasAttr("hidable")) {
                this.setHidable((Boolean)DesignAttributeHandler.readAttribute((String)"hidable", (Attributes)attributes, Boolean.TYPE));
            }
            if (design.hasAttr("hidden")) {
                this.setHidden((Boolean)DesignAttributeHandler.readAttribute((String)"hidden", (Attributes)attributes, Boolean.TYPE));
            }
            if (design.hasAttr("hiding-toggle-caption")) {
                this.setHidingToggleCaption((String)DesignAttributeHandler.readAttribute((String)"hiding-toggle-caption", (Attributes)attributes, String.class));
            }
            if (design.hasAttr("width")) {
                this.setWidth((Double)DesignAttributeHandler.readAttribute((String)"width", (Attributes)attributes, Double.class));
            }
            if (design.hasAttr("min-width")) {
                this.setMinimumWidth((Double)DesignAttributeHandler.readAttribute((String)"min-width", (Attributes)attributes, Double.class));
            }
            if (design.hasAttr("max-width")) {
                this.setMaximumWidth((Double)DesignAttributeHandler.readAttribute((String)"max-width", (Attributes)attributes, Double.class));
            }
            if (design.hasAttr("expand")) {
                if (design.attr("expand").isEmpty()) {
                    this.setExpandRatio(1);
                } else {
                    this.setExpandRatio((Integer)DesignAttributeHandler.readAttribute((String)"expand", (Attributes)attributes, Integer.class));
                }
            }
        }
    }

    @Deprecated
    public static class FooterCell
    extends StaticSection.StaticCell {
        protected FooterCell(FooterRow row) {
            super(row);
        }
    }

    @Deprecated
    public static class FooterRow
    extends StaticSection.StaticRow<FooterCell> {
        protected FooterRow(StaticSection<?> section) {
            super(section);
        }

        @Override
        protected FooterCell createCell() {
            return new FooterCell(this);
        }

        @Override
        protected String getCellTagName() {
            return "td";
        }
    }

    @Deprecated
    protected static class Footer
    extends StaticSection<FooterRow> {
        private final GridStaticSectionState footerState = new GridStaticSectionState();

        protected Footer(Grid grid) {
            this.grid = grid;
            grid.getState((boolean)true).footer = this.footerState;
        }

        @Override
        protected GridStaticSectionState getSectionState() {
            return this.footerState;
        }

        @Override
        protected FooterRow createRow() {
            return new FooterRow(this);
        }

        @Override
        protected void sanityCheck() throws IllegalStateException {
            super.sanityCheck();
        }
    }

    @Deprecated
    public static class HeaderCell
    extends StaticSection.StaticCell {
        protected HeaderCell(HeaderRow row) {
            super(row);
        }
    }

    @Deprecated
    public static class HeaderRow
    extends StaticSection.StaticRow<HeaderCell> {
        protected HeaderRow(StaticSection<?> section) {
            super(section);
        }

        private void setDefaultRow(boolean value) {
            this.getRowState().defaultRow = value;
        }

        private boolean isDefaultRow() {
            return this.getRowState().defaultRow;
        }

        @Override
        protected HeaderCell createCell() {
            return new HeaderCell(this);
        }

        @Override
        protected String getCellTagName() {
            return "th";
        }

        @Override
        protected void writeDesign(Element trElement, DesignContext designContext) {
            super.writeDesign(trElement, designContext);
            if (this.section.grid.getDefaultHeaderRow() == this) {
                DesignAttributeHandler.writeAttribute((String)"default", (Attributes)trElement.attributes(), (Object)true, null, Boolean.TYPE, (DesignContext)designContext);
            }
        }

        @Override
        protected void readDesign(Element trElement, DesignContext designContext) {
            super.readDesign(trElement, designContext);
            boolean defaultRow = (Boolean)DesignAttributeHandler.readAttribute((String)"default", (Attributes)trElement.attributes(), (Object)false, Boolean.TYPE);
            if (defaultRow) {
                this.section.grid.setDefaultHeaderRow(this);
            }
        }
    }

    @Deprecated
    protected static class Header
    extends StaticSection<HeaderRow> {
        private HeaderRow defaultRow = null;
        private final GridStaticSectionState headerState = new GridStaticSectionState();

        protected Header(Grid grid) {
            this.grid = grid;
            grid.getState((boolean)true).header = this.headerState;
            HeaderRow row = this.createRow();
            this.rows.add(row);
            this.setDefaultRow(row);
            this.getSectionState().rows.add(row.getRowState());
        }

        public void setDefaultRow(HeaderRow row) {
            if (row == this.defaultRow) {
                return;
            }
            if (row != null && !this.rows.contains(row)) {
                throw new IllegalArgumentException("Cannot set a default row that does not exist in the section");
            }
            if (this.defaultRow != null) {
                this.defaultRow.setDefaultRow(false);
            }
            if (row != null) {
                row.setDefaultRow(true);
            }
            this.defaultRow = row;
            this.markAsDirty();
        }

        public HeaderRow getDefaultRow() {
            return this.defaultRow;
        }

        @Override
        protected GridStaticSectionState getSectionState() {
            return this.headerState;
        }

        @Override
        protected HeaderRow createRow() {
            return new HeaderRow(this);
        }

        @Override
        public HeaderRow removeRow(int rowIndex) {
            HeaderRow row = (HeaderRow)super.removeRow(rowIndex);
            if (row == this.defaultRow) {
                this.setDefaultRow(null);
            }
            return row;
        }

        @Override
        protected void sanityCheck() throws IllegalStateException {
            super.sanityCheck();
            boolean hasDefaultRow = false;
            for (HeaderRow row : this.rows) {
                if (!row.getRowState().defaultRow) continue;
                if (!hasDefaultRow) {
                    hasDefaultRow = true;
                    continue;
                }
                throw new IllegalStateException("Multiple default rows in header");
            }
        }

        @Override
        protected void readDesign(Element tableSectionElement, DesignContext designContext) {
            super.readDesign(tableSectionElement, designContext);
            if (this.defaultRow == null && !this.rows.isEmpty()) {
                this.grid.setDefaultHeaderRow((HeaderRow)this.rows.get(0));
            }
        }
    }

    @Deprecated
    public static abstract class StaticSection<ROWTYPE extends StaticRow<?>>
    implements Serializable {
        protected Grid grid;
        protected List<ROWTYPE> rows = new ArrayList<ROWTYPE>();

        public void setVisible(boolean visible) {
            if (this.getSectionState().visible != visible) {
                this.getSectionState().visible = visible;
                this.markAsDirty();
            }
        }

        public boolean isVisible() {
            return this.getSectionState().visible;
        }

        public ROWTYPE removeRow(int rowIndex) {
            if (rowIndex >= this.rows.size() || rowIndex < 0) {
                throw new IllegalArgumentException("No row at given index " + rowIndex);
            }
            StaticRow row = (StaticRow)this.rows.remove(rowIndex);
            row.detach();
            this.getSectionState().rows.remove(rowIndex);
            this.markAsDirty();
            return (ROWTYPE)row;
        }

        public void removeRow(ROWTYPE row) {
            try {
                this.removeRow(this.rows.indexOf(row));
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Section does not contain the given row");
            }
        }

        public ROWTYPE getRow(int rowIndex) {
            if (rowIndex >= this.rows.size() || rowIndex < 0) {
                throw new IllegalArgumentException("No row at given index " + rowIndex);
            }
            return (ROWTYPE)((StaticRow)this.rows.get(rowIndex));
        }

        public ROWTYPE prependRow() {
            return this.addRowAt(0);
        }

        public ROWTYPE appendRow() {
            return this.addRowAt(this.rows.size());
        }

        public ROWTYPE addRowAt(int index) {
            if (index > this.rows.size() || index < 0) {
                throw new IllegalArgumentException("Unable to add row at index " + index);
            }
            ROWTYPE row = this.createRow();
            this.rows.add(index, row);
            this.getSectionState().rows.add(index, ((StaticRow)row).getRowState());
            for (Object id : this.grid.columns.keySet()) {
                ((StaticRow)row).addCell(id);
            }
            this.markAsDirty();
            return row;
        }

        public int getRowCount() {
            return this.rows.size();
        }

        protected abstract GridStaticSectionState getSectionState();

        protected abstract ROWTYPE createRow();

        protected void markAsDirty() {
            this.grid.markAsDirty();
        }

        protected void removeColumn(Object propertyId) {
            for (StaticRow row : this.rows) {
                row.removeCell(propertyId);
            }
        }

        protected void addColumn(Object propertyId) {
            for (StaticRow row : this.rows) {
                row.addCell(propertyId);
            }
        }

        protected void sanityCheck() throws IllegalStateException {
            List columnOrder = this.grid.getState().columnOrder;
            for (StaticRow row : this.rows) {
                for (Set cellGroup : row.getRowState().cellGroups.keySet()) {
                    if (this.checkCellGroupAndOrder(columnOrder, cellGroup)) continue;
                    throw new IllegalStateException("Not all merged cells were in a continuous range.");
                }
            }
        }

        private boolean checkCellGroupAndOrder(List<String> columnOrder, Set<String> cellGroup) {
            if (!columnOrder.containsAll(cellGroup)) {
                return false;
            }
            for (int i = 0; i < columnOrder.size(); ++i) {
                if (!cellGroup.contains(columnOrder.get(i))) continue;
                for (int j = 1; j < cellGroup.size(); ++j) {
                    if (cellGroup.contains(columnOrder.get(i + j))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        protected void writeDesign(Element tableSectionElement, DesignContext designContext) {
            for (StaticRow row : this.rows) {
                row.writeDesign(tableSectionElement.appendElement("tr"), designContext);
            }
        }

        protected void readDesign(Element tableSectionElement, DesignContext designContext) throws DesignException {
            while (this.rows.size() > 0) {
                this.removeRow(0);
            }
            for (Element row : tableSectionElement.children()) {
                if (!row.tagName().equals("tr")) {
                    throw new DesignException("Unexpected element in " + tableSectionElement.tagName() + ": " + row.tagName());
                }
                ((StaticRow)this.appendRow()).readDesign(row, designContext);
            }
        }

        @Deprecated
        static abstract class StaticCell
        implements Serializable {
            private GridStaticSectionState.CellState cellState = new GridStaticSectionState.CellState();
            private StaticRow<?> row;

            protected StaticCell(StaticRow<?> row) {
                this.row = row;
            }

            void setColumnId(String id) {
                this.cellState.columnId = id;
            }

            String getColumnId() {
                return this.cellState.columnId;
            }

            public StaticRow<?> getRow() {
                return this.row;
            }

            protected GridStaticSectionState.CellState getCellState() {
                return this.cellState;
            }

            public void setText(String text) {
                this.removeComponentIfPresent();
                this.cellState.text = text;
                this.cellState.type = GridStaticCellType.TEXT;
                this.row.section.markAsDirty();
            }

            public String getText() {
                if (this.cellState.type != GridStaticCellType.TEXT) {
                    throw new IllegalStateException("Cannot fetch Text from a cell with type " + this.cellState.type);
                }
                return this.cellState.text;
            }

            public String getHtml() {
                if (this.cellState.type != GridStaticCellType.HTML) {
                    throw new IllegalStateException("Cannot fetch HTML from a cell with type " + this.cellState.type);
                }
                return this.cellState.html;
            }

            public void setHtml(String html) {
                this.removeComponentIfPresent();
                this.cellState.html = html;
                this.cellState.type = GridStaticCellType.HTML;
                this.row.section.markAsDirty();
            }

            public Component getComponent() {
                if (this.cellState.type != GridStaticCellType.WIDGET) {
                    throw new IllegalStateException("Cannot fetch Component from a cell with type " + this.cellState.type);
                }
                return (Component)this.cellState.connector;
            }

            public void setComponent(Component component) {
                this.removeComponentIfPresent();
                component.setParent((HasComponents)this.row.section.grid);
                this.cellState.connector = component;
                this.cellState.type = GridStaticCellType.WIDGET;
                this.row.section.markAsDirty();
            }

            public GridStaticCellType getCellType() {
                return this.cellState.type;
            }

            public String getStyleName() {
                return this.cellState.styleName;
            }

            public void setStyleName(String styleName) {
                this.cellState.styleName = styleName;
                this.row.section.markAsDirty();
            }

            private void removeComponentIfPresent() {
                Component component = (Component)this.cellState.connector;
                if (component != null) {
                    component.setParent(null);
                    this.cellState.connector = null;
                }
            }

            protected void writeDesign(Element cellElement, DesignContext designContext) {
                switch (this.cellState.type) {
                    case TEXT: {
                        cellElement.attr("plain-text", true);
                        cellElement.appendText(this.getText());
                        break;
                    }
                    case HTML: {
                        cellElement.append(this.getHtml());
                        break;
                    }
                    case WIDGET: {
                        cellElement.appendChild((Node)designContext.createElement(this.getComponent()));
                    }
                }
            }

            protected void readDesign(Element cellElement, DesignContext designContext) {
                if (!cellElement.hasAttr("plain-text")) {
                    if (cellElement.children().size() > 0 && cellElement.child(0).tagName().contains("-")) {
                        this.setComponent(designContext.readDesign(cellElement.child(0)));
                    } else {
                        this.setHtml(cellElement.html());
                    }
                } else {
                    this.setText(DesignFormatter.decodeFromTextNode((String)cellElement.html()));
                }
            }

            void detach() {
                this.removeComponentIfPresent();
            }
        }

        @Deprecated
        public static abstract class StaticRow<CELLTYPE extends StaticCell>
        implements Serializable {
            private GridStaticSectionState.RowState rowState = new GridStaticSectionState.RowState();
            protected StaticSection<?> section;
            private Map<Object, CELLTYPE> cells = new LinkedHashMap<Object, CELLTYPE>();
            private Map<Set<CELLTYPE>, CELLTYPE> cellGroups = new HashMap<Set<CELLTYPE>, CELLTYPE>();

            protected StaticRow(StaticSection<?> section) {
                this.section = section;
            }

            protected void addCell(Object propertyId) {
                CELLTYPE cell = this.createCell();
                ((StaticCell)cell).setColumnId(this.section.grid.getColumn((Object)propertyId).getState().id);
                this.cells.put(propertyId, cell);
                this.rowState.cells.add(((StaticCell)cell).getCellState());
            }

            protected void removeCell(Object propertyId) {
                StaticCell cell = (StaticCell)this.cells.remove(propertyId);
                if (cell != null) {
                    Set<StaticCell> cellGroupForCell = this.getCellGroupForCell(cell);
                    if (cellGroupForCell != null) {
                        this.removeCellFromGroup(cell, cellGroupForCell);
                    }
                    this.rowState.cells.remove(cell.getCellState());
                }
            }

            private void removeCellFromGroup(CELLTYPE cell, Set<CELLTYPE> cellGroup) {
                String columnId = ((StaticCell)cell).getColumnId();
                for (Set group : this.rowState.cellGroups.keySet()) {
                    if (!group.contains(columnId)) continue;
                    if (group.size() > 2) {
                        StaticCell mergedCell = (StaticCell)this.cellGroups.remove(cellGroup);
                        cellGroup.remove(cell);
                        this.cellGroups.put(cellGroup, mergedCell);
                        group.remove(columnId);
                    } else {
                        this.rowState.cellGroups.remove(group);
                        this.cellGroups.remove(cellGroup);
                    }
                    return;
                }
            }

            protected abstract CELLTYPE createCell();

            protected GridStaticSectionState.RowState getRowState() {
                return this.rowState;
            }

            public CELLTYPE getCell(Object propertyId) {
                StaticCell cell = (StaticCell)this.cells.get(propertyId);
                Set<StaticCell> cellGroup = this.getCellGroupForCell(cell);
                if (cellGroup != null) {
                    cell = (StaticCell)this.cellGroups.get(cellGroup);
                }
                return (CELLTYPE)cell;
            }

            public CELLTYPE join(Object ... propertyIds) {
                if (propertyIds.length < 2) {
                    throw new IllegalArgumentException("You need to merge at least 2 properties");
                }
                HashSet<CELLTYPE> cells = new HashSet<CELLTYPE>();
                for (int i = 0; i < propertyIds.length; ++i) {
                    cells.add(this.getCell(propertyIds[i]));
                }
                return (CELLTYPE)this.join((Set<CELLTYPE>)cells);
            }

            public CELLTYPE join(CELLTYPE ... cells) {
                if (cells.length < 2) {
                    throw new IllegalArgumentException("You need to merge at least 2 cells");
                }
                return this.join((Set<CELLTYPE>)new HashSet<CELLTYPE>(Arrays.asList(cells)));
            }

            protected CELLTYPE join(Set<CELLTYPE> cells) {
                for (StaticCell cell : cells) {
                    if (this.getCellGroupForCell(cell) != null) {
                        throw new IllegalArgumentException("Cell already merged");
                    }
                    if (this.cells.containsValue(cell)) continue;
                    throw new IllegalArgumentException("Cell does not exist on this row");
                }
                CELLTYPE newCell = this.createCell();
                HashSet<String> columnGroup = new HashSet<String>();
                for (StaticCell cell : cells) {
                    columnGroup.add(cell.getColumnId());
                }
                this.rowState.cellGroups.put(columnGroup, ((StaticCell)newCell).getCellState());
                this.cellGroups.put(cells, newCell);
                return newCell;
            }

            private Set<CELLTYPE> getCellGroupForCell(CELLTYPE cell) {
                for (Set<CELLTYPE> group : this.cellGroups.keySet()) {
                    if (!group.contains(cell)) continue;
                    return group;
                }
                return null;
            }

            public String getStyleName() {
                return this.getRowState().styleName;
            }

            public void setStyleName(String styleName) {
                this.getRowState().styleName = styleName;
            }

            protected void writeDesign(Element trElement, DesignContext designContext) {
                HashSet<CELLTYPE> visited = new HashSet<CELLTYPE>();
                block0: for (Column column : this.section.grid.getColumns()) {
                    CELLTYPE cell = this.getCell(column.getPropertyId());
                    if (visited.contains(cell)) continue;
                    visited.add(cell);
                    Element cellElement = trElement.appendElement(this.getCellTagName());
                    ((StaticCell)cell).writeDesign(cellElement, designContext);
                    for (Map.Entry<Set<CELLTYPE>, CELLTYPE> entry : this.cellGroups.entrySet()) {
                        if (entry.getValue() != cell) continue;
                        cellElement.attr("colspan", "" + entry.getKey().size());
                        continue block0;
                    }
                }
            }

            protected void readDesign(Element trElement, DesignContext designContext) throws DesignException {
                Elements cellElements = trElement.children();
                int totalColSpans = 0;
                for (int i = 0; i < cellElements.size(); ++i) {
                    Element element = (Element)cellElements.get(i);
                    if (!element.tagName().equals(this.getCellTagName())) {
                        throw new DesignException("Unexpected element in tr while expecting " + this.getCellTagName() + ": " + element.tagName());
                    }
                    int columnIndex = i + totalColSpans;
                    int colspan = (Integer)DesignAttributeHandler.readAttribute((String)"colspan", (Attributes)element.attributes(), (Object)1, Integer.TYPE);
                    HashSet<CELLTYPE> cells = new HashSet<CELLTYPE>();
                    for (int c = 0; c < colspan; ++c) {
                        cells.add(this.getCell(this.section.grid.getColumns().get(columnIndex + c).getPropertyId()));
                    }
                    if (colspan > 1) {
                        totalColSpans += colspan - 1;
                        ((StaticCell)this.join((Set<CELLTYPE>)cells)).readDesign(element, designContext);
                        continue;
                    }
                    ((StaticCell)cells.iterator().next()).readDesign(element, designContext);
                }
            }

            protected abstract String getCellTagName();

            void detach() {
                for (StaticCell cell : this.cells.values()) {
                    cell.detach();
                }
                for (StaticCell cell : this.cellGroups.values()) {
                    cell.detach();
                }
            }
        }
    }

    private class RowDataGenerator
    implements DataGenerator {
        private RowDataGenerator() {
        }

        private void put(String key, String value, JsonObject object) {
            if (value != null && !value.isEmpty()) {
                object.put(key, value);
            }
        }

        @Override
        public void generateData(Object itemId, Item item, JsonObject rowData) {
            RowReference row = new RowReference(Grid.this);
            row.set(itemId);
            if (Grid.this.rowStyleGenerator != null) {
                String style = Grid.this.rowStyleGenerator.getStyle(row);
                this.put("rs", style, rowData);
            }
            if (Grid.this.rowDescriptionGenerator != null) {
                String description = Grid.this.rowDescriptionGenerator.getDescription(row);
                this.put("rd", description, rowData);
            }
            JsonObject cellStyles = Json.createObject();
            JsonObject cellData = Json.createObject();
            JsonObject cellDescriptions = Json.createObject();
            CellReference cell = new CellReference(row);
            for (Column column : Grid.this.getColumns()) {
                cell.set(column.getPropertyId());
                this.writeData(cell, cellData);
                this.writeStyles(cell, cellStyles);
                this.writeDescriptions(cell, cellDescriptions);
            }
            if (Grid.this.cellDescriptionGenerator != null && cellDescriptions.keys().length > 0) {
                rowData.put("cd", (JsonValue)cellDescriptions);
            }
            if (Grid.this.cellStyleGenerator != null && cellStyles.keys().length > 0) {
                rowData.put("cs", (JsonValue)cellStyles);
            }
            rowData.put("d", (JsonValue)cellData);
        }

        private void writeStyles(CellReference cell, JsonObject styles) {
            if (Grid.this.cellStyleGenerator != null) {
                String style = Grid.this.cellStyleGenerator.getStyle(cell);
                this.put(Grid.this.columnKeys.key(cell.getPropertyId()), style, styles);
            }
        }

        private void writeDescriptions(CellReference cell, JsonObject descriptions) {
            if (Grid.this.cellDescriptionGenerator != null) {
                String description = Grid.this.cellDescriptionGenerator.getDescription(cell);
                this.put(Grid.this.columnKeys.key(cell.getPropertyId()), description, descriptions);
            }
        }

        private void writeData(CellReference cell, JsonObject data) {
            Column column = Grid.this.getColumn(cell.getPropertyId());
            Converter<?, ?> converter = column.getConverter();
            Renderer<?> renderer = column.getRenderer();
            Item item = cell.getItem();
            Property itemProperty = item.getItemProperty(cell.getPropertyId());
            Object modelValue = itemProperty == null ? null : itemProperty.getValue();
            data.put(Grid.this.columnKeys.key(cell.getPropertyId()), AbstractRenderer.encodeValue(modelValue, renderer, converter, Grid.this.getLocale()));
        }

        @Override
        public void destroyData(Object itemId) {
        }
    }

    @Deprecated
    public static interface CellDescriptionGenerator
    extends Serializable {
        public String getDescription(CellReference var1);
    }

    @Deprecated
    public static interface RowDescriptionGenerator
    extends Serializable {
        public String getDescription(RowReference var1);
    }

    @Deprecated
    public static interface CellStyleGenerator
    extends Serializable {
        public String getStyle(CellReference var1);
    }

    @Deprecated
    public static interface RowStyleGenerator
    extends Serializable {
        public String getStyle(RowReference var1);
    }

    @Deprecated
    public static class CellReference
    implements Serializable {
        private final RowReference rowReference;
        private Object propertyId;

        public CellReference(RowReference rowReference) {
            this.rowReference = rowReference;
        }

        public void set(Object propertyId) {
            this.propertyId = propertyId;
        }

        public Grid getGrid() {
            return this.rowReference.getGrid();
        }

        public Object getPropertyId() {
            return this.propertyId;
        }

        public Property<?> getProperty() {
            return this.getItem().getItemProperty(this.propertyId);
        }

        public Object getItemId() {
            return this.rowReference.getItemId();
        }

        public Item getItem() {
            return this.rowReference.getItem();
        }

        public Object getValue() {
            return this.getProperty().getValue();
        }
    }

    @Deprecated
    public static class RowReference
    implements Serializable {
        private final Grid grid;
        private Object itemId;

        public RowReference(Grid grid) {
            this.grid = grid;
        }

        public void set(Object itemId) {
            this.itemId = itemId;
        }

        public Grid getGrid() {
            return this.grid;
        }

        public Object getItemId() {
            return this.itemId;
        }

        public Item getItem() {
            return this.grid.getContainerDataSource().getItem(this.itemId);
        }
    }

    @Deprecated
    public static class MultiSelectionModel
    extends AbstractSelectionModel
    implements SelectionModel.Multi,
    SelectionModel.HasUserSelectionAllowed {
        public static final int DEFAULT_MAX_SELECTIONS = 1000;
        private int selectionLimit = 1000;

        @Override
        protected void extend(AbstractClientConnector target) {
            super.extend(target);
            this.registerRpc((ServerRpc)new MultiSelectionModelServerRpc(){

                public void select(List<String> rowKeys) {
                    if (!this.isUserSelectionAllowed()) {
                        throw new IllegalStateException("Client tried to select '" + rowKeys + "' although user selection is disallowed");
                    }
                    ArrayList<Object> items = new ArrayList<Object>();
                    for (String rowKey : rowKeys) {
                        items.add(this.getItemId(rowKey));
                    }
                    this.select(items, false);
                }

                public void deselect(List<String> rowKeys) {
                    if (!this.isUserSelectionAllowed()) {
                        throw new IllegalStateException("Client tried to deselect '" + rowKeys + "' although user selection is disallowed");
                    }
                    ArrayList<Object> items = new ArrayList<Object>();
                    for (String rowKey : rowKeys) {
                        items.add(this.getItemId(rowKey));
                    }
                    this.deselect(items, false);
                }

                public void selectAll() {
                    if (!this.isUserSelectionAllowed()) {
                        throw new IllegalStateException("Client tried to select all although user selection is disallowed");
                    }
                    this.selectAll(false);
                }

                public void deselectAll() {
                    if (!this.isUserSelectionAllowed()) {
                        throw new IllegalStateException("Client tried to deselect all although user selection is disallowed");
                    }
                    this.deselectAll(false);
                }
            });
        }

        @Override
        public boolean select(Object ... itemIds) throws IllegalArgumentException {
            if (itemIds != null) {
                return this.select(Arrays.asList(itemIds));
            }
            throw new IllegalArgumentException("Vararg array of itemIds may not be null");
        }

        @Override
        public boolean select(Collection<?> itemIds) throws IllegalArgumentException {
            return this.select(itemIds, true);
        }

        protected boolean select(Collection<?> itemIds, boolean refresh) {
            boolean selectionWillChange;
            if (itemIds == null) {
                throw new IllegalArgumentException("itemIds may not be null");
            }
            this.checkItemIdsExist(itemIds);
            boolean bl = selectionWillChange = !this.selection.containsAll(itemIds) && this.selection.size() < this.selectionLimit;
            if (selectionWillChange) {
                HashSet<Object> oldSelection = new HashSet<Object>(this.selection);
                if (this.selection.size() + itemIds.size() >= this.selectionLimit) {
                    Iterator<?> iterator = itemIds.iterator();
                    while (iterator.hasNext() && this.selection.size() < this.selectionLimit) {
                        this.selection.add(iterator.next());
                    }
                } else {
                    this.selection.addAll(itemIds);
                }
                this.fireSelectionEvent(oldSelection, this.selection);
            }
            this.updateAllSelectedState();
            if (refresh) {
                for (Object itemId : itemIds) {
                    this.refreshRow(itemId);
                }
            }
            return selectionWillChange;
        }

        public void setSelectionLimit(int selectionLimit) {
            if (selectionLimit < 0) {
                throw new IllegalArgumentException("The selection limit must be non-negative");
            }
            this.selectionLimit = selectionLimit;
        }

        public int getSelectionLimit() {
            return this.selectionLimit;
        }

        @Override
        public boolean deselect(Object ... itemIds) throws IllegalArgumentException {
            if (itemIds != null) {
                return this.deselect(Arrays.asList(itemIds));
            }
            throw new IllegalArgumentException("Vararg array of itemIds may not be null");
        }

        @Override
        public boolean deselect(Collection<?> itemIds) throws IllegalArgumentException {
            return this.deselect(itemIds, true);
        }

        protected boolean deselect(Collection<?> itemIds, boolean refresh) {
            boolean hasCommonElements;
            if (itemIds == null) {
                throw new IllegalArgumentException("itemIds may not be null");
            }
            boolean bl = hasCommonElements = !Collections.disjoint(itemIds, this.selection);
            if (hasCommonElements) {
                HashSet<Object> oldSelection = new HashSet<Object>(this.selection);
                this.selection.removeAll(itemIds);
                this.fireSelectionEvent(oldSelection, this.selection);
            }
            this.updateAllSelectedState();
            if (refresh) {
                for (Object itemId : itemIds) {
                    this.refreshRow(itemId);
                }
            }
            return hasCommonElements;
        }

        @Override
        public boolean selectAll() {
            return this.selectAll(true);
        }

        protected boolean selectAll(boolean refresh) {
            Container.Indexed container = this.getParentGrid().getContainerDataSource();
            if (container != null) {
                return this.select(container.getItemIds(), refresh);
            }
            if (this.selection.isEmpty()) {
                return false;
            }
            return this.deselectAll(false);
        }

        @Override
        public boolean deselectAll() {
            return this.deselectAll(true);
        }

        protected boolean deselectAll(boolean refresh) {
            return this.deselect(this.getSelectedRows(), refresh);
        }

        @Override
        public Collection<Object> getSelectedRows() {
            return super.getSelectedRows();
        }

        @Override
        public void reset() {
            this.deselectAll();
        }

        @Override
        public boolean setSelected(Collection<?> itemIds) throws IllegalArgumentException {
            Set<Object> removed;
            if (itemIds == null) {
                throw new IllegalArgumentException("itemIds may not be null");
            }
            this.checkItemIdsExist(itemIds);
            boolean changed = false;
            HashSet<Object> selectedRows = new HashSet<Object>(itemIds);
            Collection<Object> oldSelection = this.getSelectedRows();
            Set<Object> added = MultiSelectionModel.getDifference(selectedRows, this.selection);
            if (!added.isEmpty()) {
                changed = true;
                this.selection.addAll(added);
                for (Object id : added) {
                    this.refreshRow(id);
                }
            }
            if (!(removed = MultiSelectionModel.getDifference(this.selection, selectedRows)).isEmpty()) {
                changed = true;
                this.selection.removeAll(removed);
                for (Object id : removed) {
                    this.refreshRow(id);
                }
            }
            if (changed) {
                this.fireSelectionEvent(oldSelection, this.selection);
            }
            this.updateAllSelectedState();
            return changed;
        }

        private static Set<Object> getDifference(Set<Object> set1, Set<Object> set2) {
            HashSet<Object> diff = new HashSet<Object>(set1);
            diff.removeAll(set2);
            return diff;
        }

        @Override
        public boolean setSelected(Object ... itemIds) throws IllegalArgumentException {
            if (itemIds != null) {
                return this.setSelected(Arrays.asList(itemIds));
            }
            throw new IllegalArgumentException("Vararg array of itemIds may not be null");
        }

        private void updateAllSelectedState() {
            int totalRowCount = this.getParentGrid().datasource.size();
            int rows = Math.min(totalRowCount, this.selectionLimit);
            this.getState().allSelected = totalRowCount == 0 ? false : this.selection.size() >= rows;
        }

        protected MultiSelectionModelState getState() {
            return (MultiSelectionModelState)super.getState();
        }

        protected MultiSelectionModelState getState(boolean markAsDirty) {
            return (MultiSelectionModelState)super.getState(markAsDirty);
        }

        @Override
        public boolean isUserSelectionAllowed() {
            return this.getState((boolean)false).userSelectionAllowed;
        }

        @Override
        public void setUserSelectionAllowed(boolean userSelectionAllowed) {
            this.getState().userSelectionAllowed = userSelectionAllowed;
        }
    }

    @Deprecated
    public static class NoSelectionModel
    extends AbstractSelectionModel
    implements SelectionModel.None {
        @Override
        public boolean isSelected(Object itemId) {
            return false;
        }

        @Override
        public Collection<Object> getSelectedRows() {
            return Collections.emptyList();
        }

        @Override
        public void reset() {
        }
    }

    @Deprecated
    public static class SingleSelectionModel
    extends AbstractSelectionModel
    implements SelectionModel.Single,
    SelectionModel.HasUserSelectionAllowed {
        @Override
        protected void extend(AbstractClientConnector target) {
            super.extend(target);
            this.registerRpc((ServerRpc)new SingleSelectionModelServerRpc(){

                public void select(String rowKey) {
                    if (!this.isUserSelectionAllowed()) {
                        throw new IllegalStateException("Client tried to select '" + rowKey + "' although user selection is disallowed");
                    }
                    this.select(this.getItemId(rowKey), false);
                }
            });
        }

        @Override
        public boolean select(Object itemId) {
            return this.select(itemId, true);
        }

        protected boolean select(Object itemId, boolean refresh) {
            if (itemId == null) {
                return this.deselect(this.getSelectedRow());
            }
            this.checkItemIdExists(itemId);
            Object selectedRow = this.getSelectedRow();
            boolean modified = this.selection.add(itemId);
            if (modified) {
                Set<Object> deselected;
                if (selectedRow != null) {
                    this.deselectInternal(selectedRow, false, true);
                    deselected = Collections.singleton(selectedRow);
                } else {
                    deselected = Collections.emptySet();
                }
                this.fireSelectionEvent(deselected, this.selection);
            }
            if (refresh) {
                this.refreshRow(itemId);
            }
            return modified;
        }

        private boolean deselect(Object itemId) {
            return this.deselectInternal(itemId, true, true);
        }

        private boolean deselectInternal(Object itemId, boolean fireEventIfNeeded, boolean refresh) {
            boolean modified = this.selection.remove(itemId);
            if (modified) {
                if (refresh) {
                    this.refreshRow(itemId);
                }
                if (fireEventIfNeeded) {
                    this.fireSelectionEvent(Collections.singleton(itemId), Collections.emptySet());
                }
            }
            return modified;
        }

        @Override
        public Object getSelectedRow() {
            if (this.selection.isEmpty()) {
                return null;
            }
            return this.selection.iterator().next();
        }

        @Override
        public void reset() {
            this.deselect(this.getSelectedRow());
        }

        @Override
        public void setDeselectAllowed(boolean deselectAllowed) {
            this.getState().deselectAllowed = deselectAllowed;
        }

        @Override
        public boolean isDeselectAllowed() {
            return this.getState().deselectAllowed;
        }

        protected SingleSelectionModelState getState() {
            return (SingleSelectionModelState)super.getState();
        }

        protected SingleSelectionModelState getState(boolean markAsDirty) {
            return (SingleSelectionModelState)super.getState(markAsDirty);
        }

        @Override
        public boolean isUserSelectionAllowed() {
            return this.getState((boolean)false).userSelectionAllowed;
        }

        @Override
        public void setUserSelectionAllowed(boolean userSelectionAllowed) {
            this.getState().userSelectionAllowed = userSelectionAllowed;
        }
    }

    @Deprecated
    public static abstract class AbstractSelectionModel
    extends AbstractGridExtension
    implements SelectionModel,
    DataGenerator {
        protected final LinkedHashSet<Object> selection = new LinkedHashSet();

        @Override
        public boolean isSelected(Object itemId) {
            return this.selection.contains(itemId);
        }

        @Override
        public Collection<Object> getSelectedRows() {
            return new ArrayList<Object>(this.selection);
        }

        @Override
        public void setGrid(Grid grid) {
            if (grid != null) {
                this.extend((AbstractClientConnector)grid);
            }
        }

        protected void checkItemIdExists(Object itemId) throws IllegalArgumentException {
            if (!this.getParentGrid().getContainerDataSource().containsId(itemId)) {
                throw new IllegalArgumentException("Given item id (" + itemId + ") does not exist in the container");
            }
        }

        protected void checkItemIdsExist(Collection<?> itemIds) throws IllegalArgumentException {
            for (Object itemId : itemIds) {
                this.checkItemIdExists(itemId);
            }
        }

        protected void fireSelectionEvent(Collection<Object> oldSelection, Collection<Object> newSelection) {
            this.getParentGrid().fireSelectionEvent(oldSelection, newSelection);
        }

        @Override
        public void generateData(Object itemId, Item item, JsonObject rowData) {
            if (this.isSelected(itemId)) {
                rowData.put("s", true);
            }
        }

        @Override
        public void destroyData(Object itemId) {
        }

        @Override
        protected Object getItemId(String rowKey) {
            return rowKey != null ? super.getItemId(rowKey) : null;
        }
    }

    @Deprecated
    public static interface SelectionModel
    extends Serializable,
    Extension {
        public boolean isSelected(Object var1);

        public Collection<Object> getSelectedRows();

        public void setGrid(Grid var1);

        public void reset();

        @Deprecated
        public static interface None
        extends SelectionModel {
            @Override
            public boolean isSelected(Object var1);

            @Override
            public Collection<Object> getSelectedRows();
        }

        @Deprecated
        public static interface Single
        extends SelectionModel {
            public boolean select(Object var1) throws IllegalStateException, IllegalArgumentException;

            public Object getSelectedRow();

            public void setDeselectAllowed(boolean var1);

            public boolean isDeselectAllowed();
        }

        @Deprecated
        public static interface Multi
        extends SelectionModel {
            public boolean select(Object ... var1) throws IllegalArgumentException;

            public boolean select(Collection<?> var1) throws IllegalArgumentException;

            public boolean deselect(Object ... var1) throws IllegalArgumentException;

            public boolean deselect(Collection<?> var1) throws IllegalArgumentException;

            public boolean selectAll();

            public boolean deselectAll();

            public boolean setSelected(Collection<?> var1) throws IllegalArgumentException;

            public boolean setSelected(Object ... var1) throws IllegalArgumentException;
        }

        @Deprecated
        public static interface HasUserSelectionAllowed
        extends SelectionModel {
            public boolean isUserSelectionAllowed();

            public void setUserSelectionAllowed(boolean var1);
        }
    }

    @Deprecated
    public static enum SelectionMode {
        SINGLE{

            @Override
            protected SelectionModel createModel() {
                return new SingleSelectionModel();
            }
        }
        ,
        MULTI{

            @Override
            protected SelectionModel createModel() {
                return new MultiSelectionModel();
            }
        }
        ,
        NONE{

            @Override
            protected SelectionModel createModel() {
                return new NoSelectionModel();
            }
        };


        protected abstract SelectionModel createModel();
    }

    @Deprecated
    public class DefaultEditorErrorHandler
    implements EditorErrorHandler {
        @Override
        public void commitError(CommitErrorEvent event) {
            Map<Field<?>, Validator.InvalidValueException> invalidFields = event.getCause().getInvalidFields();
            if (!invalidFields.isEmpty()) {
                Object firstErrorPropertyId = null;
                Field<?> firstErrorField = null;
                FieldGroup fieldGroup = event.getCause().getFieldGroup();
                for (Column column : Grid.this.getColumns()) {
                    Object propertyId = column.getPropertyId();
                    Field<?> field = fieldGroup.getField(propertyId);
                    if (!invalidFields.keySet().contains(field)) continue;
                    event.addErrorColumn(column);
                    if (firstErrorPropertyId != null) continue;
                    firstErrorPropertyId = propertyId;
                    firstErrorField = field;
                }
                String caption = Grid.this.getColumn(firstErrorPropertyId).getHeaderCaption();
                String message = invalidFields.get(firstErrorField).getLocalizedMessage();
                event.setUserErrorMessage(caption + ": " + message);
            } else {
                ErrorEvent.findErrorHandler((ClientConnector)Grid.this).error((ErrorEvent)new ClientConnector.ConnectorErrorEvent((Connector)Grid.this, (Throwable)event.getCause()));
            }
        }

        private Object getFirstPropertyId(FieldGroup fieldGroup, Set<Field<?>> keySet) {
            for (Column c : Grid.this.getColumns()) {
                Object propertyId = c.getPropertyId();
                Field<?> f = fieldGroup.getField(propertyId);
                if (!keySet.contains(f)) continue;
                return propertyId;
            }
            return null;
        }
    }

    @Deprecated
    public static class EditorCloseEvent
    extends EditorEvent {
        public EditorCloseEvent(Grid source, Object itemID) {
            super(source, itemID);
        }
    }

    @Deprecated
    public static class EditorMoveEvent
    extends EditorEvent {
        public EditorMoveEvent(Grid source, Object itemID) {
            super(source, itemID);
        }
    }

    @Deprecated
    public static class EditorOpenEvent
    extends EditorEvent {
        public EditorOpenEvent(Grid source, Object itemID) {
            super(source, itemID);
        }
    }

    @Deprecated
    public static abstract class EditorEvent
    extends Component.Event {
        private Object itemID;

        protected EditorEvent(Grid source, Object itemID) {
            super((Component)source);
            this.itemID = itemID;
        }

        public Object getItem() {
            return this.itemID;
        }
    }

    @Deprecated
    public static interface EditorListener
    extends Serializable {
        public static final Method EDITOR_OPEN_METHOD = ReflectTools.findMethod(EditorListener.class, (String)"editorOpened", (Class[])new Class[]{EditorOpenEvent.class});
        public static final Method EDITOR_MOVE_METHOD = ReflectTools.findMethod(EditorListener.class, (String)"editorMoved", (Class[])new Class[]{EditorMoveEvent.class});
        public static final Method EDITOR_CLOSE_METHOD = ReflectTools.findMethod(EditorListener.class, (String)"editorClosed", (Class[])new Class[]{EditorCloseEvent.class});

        public void editorOpened(EditorOpenEvent var1);

        public void editorMoved(EditorMoveEvent var1);

        public void editorClosed(EditorCloseEvent var1);
    }

    @Deprecated
    public static class ColumnResizeEvent
    extends Component.Event {
        private final Column column;
        private final boolean userOriginated;

        public ColumnResizeEvent(Grid source, Column column, boolean userOriginated) {
            super((Component)source);
            this.column = column;
            this.userOriginated = userOriginated;
        }

        public Column getColumn() {
            return this.column;
        }

        public boolean isUserOriginated() {
            return this.userOriginated;
        }
    }

    @Deprecated
    public static interface ColumnResizeListener
    extends Serializable {
        public void columnResize(ColumnResizeEvent var1);
    }

    @Deprecated
    public static class ColumnReorderEvent
    extends Component.Event {
        private final boolean userOriginated;

        public ColumnReorderEvent(Grid source, boolean userOriginated) {
            super((Component)source);
            this.userOriginated = userOriginated;
        }

        public boolean isUserOriginated() {
            return this.userOriginated;
        }
    }

    @Deprecated
    public static interface ColumnReorderListener
    extends Serializable {
        public void columnReorder(ColumnReorderEvent var1);
    }

    @Deprecated
    public static class CommitErrorEvent
    extends Component.Event {
        private FieldGroup.CommitException cause;
        private Set<Column> errorColumns = new HashSet<Column>();
        private String userErrorMessage;

        public CommitErrorEvent(Grid grid, FieldGroup.CommitException cause) {
            super((Component)grid);
            this.cause = cause;
            this.userErrorMessage = cause.getLocalizedMessage();
        }

        public FieldGroup.CommitException getCause() {
            return this.cause;
        }

        public Grid getComponent() {
            return (Grid)super.getComponent();
        }

        public boolean isValidationFailure() {
            return this.cause.getCause() instanceof Validator.InvalidValueException;
        }

        public void addErrorColumn(Column column) {
            this.errorColumns.add(column);
        }

        public Collection<Column> getErrorColumns() {
            return Collections.unmodifiableCollection(this.errorColumns);
        }

        public String getUserErrorMessage() {
            return this.userErrorMessage;
        }

        public void setUserErrorMessage(String userErrorMessage) {
            this.userErrorMessage = userErrorMessage;
        }
    }

    @Deprecated
    public static class GridContextClickEvent
    extends ContextClickEvent {
        private final Object itemId;
        private final int rowIndex;
        private final Object propertyId;
        private final GridConstants.Section section;

        public GridContextClickEvent(Grid source, MouseEventDetails mouseEventDetails, GridConstants.Section section, int rowIndex, Object itemId, Object propertyId) {
            super((Component)source, mouseEventDetails);
            this.itemId = itemId;
            this.propertyId = propertyId;
            this.section = section;
            this.rowIndex = rowIndex;
        }

        public Object getItemId() {
            return this.itemId;
        }

        public Object getPropertyId() {
            return this.propertyId;
        }

        public GridConstants.Section getSection() {
            return this.section;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public Grid getComponent() {
            return (Grid)super.getComponent();
        }
    }

    @Deprecated
    public static interface EditorErrorHandler
    extends Serializable {
        public void commitError(CommitErrorEvent var1);
    }

    @Deprecated
    public static class EditorFieldFactory
    extends DefaultFieldGroupFieldFactory {
        private static final EditorFieldFactory INSTANCE = new EditorFieldFactory();

        protected EditorFieldFactory() {
        }

        public static EditorFieldFactory get() {
            return INSTANCE;
        }

        @Override
        public <T extends Field> T createField(Class<?> type, Class<T> fieldType) {
            T f = super.createField(type, fieldType);
            if (f != null) {
                f.setWidth("100%");
            }
            return f;
        }

        @Override
        protected AbstractSelect createCompatibleSelect(Class<? extends AbstractSelect> fieldType) {
            if (this.anySelect(fieldType)) {
                return super.createCompatibleSelect(ComboBox.class);
            }
            return super.createCompatibleSelect(fieldType);
        }

        @Override
        protected void populateWithEnumData(AbstractSelect select, Class<? extends Enum> enumClass) {
            EnumSet<? extends Enum> enumSet = EnumSet.allOf(enumClass);
            for (Object e : enumSet) {
                select.addItem(e);
            }
        }
    }

    private final class CustomFieldGroup
    extends FieldGroup {
        public CustomFieldGroup() {
            this.setFieldFactory(EditorFieldFactory.get());
        }

        @Override
        protected Class<?> getPropertyType(Object propertyId) throws FieldGroup.BindException {
            if (this.getItemDataSource() == null) {
                return Grid.this.datasource.getType(propertyId);
            }
            return super.getPropertyType(propertyId);
        }

        @Override
        protected <T extends Field> T build(String caption, Class<?> dataType, Class<T> fieldType) throws FieldGroup.BindException {
            T field = super.build(caption, dataType, fieldType);
            if (field instanceof CheckBox) {
                field.setCaption(null);
            }
            return field;
        }

        @Override
        protected void bindFields() {
            ArrayList fields = new ArrayList(this.getFields());
            Item itemDataSource = this.getItemDataSource();
            if (itemDataSource == null) {
                this.unbindFields(fields);
            } else {
                this.bindFields(fields, itemDataSource);
            }
        }

        private void unbindFields(List<Field<?>> fields) {
            for (Field<?> field : fields) {
                this.clearField(field);
                this.unbind(field);
                field.setParent(null);
            }
        }

        private void bindFields(List<Field<?>> fields, Item itemDataSource) {
            for (Field<?> field : fields) {
                if (itemDataSource.getItemProperty(this.getPropertyId(field)) == null) continue;
                this.bind(field, this.getPropertyId(field));
            }
        }
    }

    @Deprecated
    public static final class DetailComponentManager
    extends AbstractGridExtension
    implements DataGenerator {
        private DetailsGenerator detailsGenerator;
        private final Map<Object, Component> itemIdToDetailsComponent = new HashMap<Object, Component>();
        private final Set<Object> emptyDetails = new HashSet<Object>();
        private final Set<Object> openDetails = new HashSet<Object>();

        public DetailComponentManager(Grid grid) {
            this(grid, DetailsGenerator.NULL);
        }

        public DetailComponentManager(Grid grid, DetailsGenerator detailsGenerator) {
            super(grid);
            this.setDetailsGenerator(detailsGenerator);
        }

        private void createDetails(Object itemId) throws IllegalStateException {
            assert (itemId != null) : "itemId was null";
            if (this.itemIdToDetailsComponent.containsKey(itemId) || this.emptyDetails.contains(itemId)) {
                return;
            }
            RowReference rowReference = new RowReference(this.getParentGrid());
            rowReference.set(itemId);
            DetailsGenerator detailsGenerator = this.getParentGrid().getDetailsGenerator();
            Component details = detailsGenerator.getDetails(rowReference);
            if (details != null) {
                if (details.getParent() != null) {
                    String name = detailsGenerator.getClass().getName();
                    throw new IllegalStateException(name + " generated a details component that already " + "was attached. (itemId: " + itemId + ", component: " + details + ")");
                }
                this.itemIdToDetailsComponent.put(itemId, details);
                this.addComponentToGrid(details);
                assert (!this.emptyDetails.contains(itemId)) : "Bookeeping thinks itemId is empty even though we just created a component for it (" + itemId + ")";
            } else {
                this.emptyDetails.add(itemId);
            }
        }

        private void destroyDetails(Object itemId) {
            this.emptyDetails.remove(itemId);
            Component removedComponent = this.itemIdToDetailsComponent.remove(itemId);
            if (removedComponent == null) {
                return;
            }
            this.removeComponentFromGrid(removedComponent);
        }

        public void refreshDetails() {
            HashSet<Object> visibleItemIds = new HashSet<Object>(this.itemIdToDetailsComponent.keySet());
            for (Object e : visibleItemIds) {
                this.destroyDetails(e);
                this.createDetails(e);
                this.refreshRow(e);
            }
        }

        public void setDetailsVisible(Object itemId, boolean visible) {
            if (visible && this.openDetails.contains(itemId) || !visible && !this.openDetails.contains(itemId)) {
                return;
            }
            if (visible) {
                this.openDetails.add(itemId);
                this.refreshRow(itemId);
            } else {
                this.openDetails.remove(itemId);
                this.destroyDetails(itemId);
                this.refreshRow(itemId);
            }
        }

        @Override
        public void generateData(Object itemId, Item item, JsonObject rowData) {
            if (this.openDetails.contains(itemId) && !this.detailsGenerator.equals(DetailsGenerator.NULL)) {
                this.createDetails(itemId);
                Component detailsComponent = this.itemIdToDetailsComponent.get(itemId);
                rowData.put("dv", detailsComponent != null ? detailsComponent.getConnectorId() : "");
            }
        }

        @Override
        public void destroyData(Object itemId) {
            if (this.openDetails.contains(itemId)) {
                this.destroyDetails(itemId);
            }
        }

        public void setDetailsGenerator(DetailsGenerator detailsGenerator) throws IllegalArgumentException {
            if (detailsGenerator == null) {
                throw new IllegalArgumentException("Details generator may not be null");
            }
            if (detailsGenerator == this.detailsGenerator) {
                return;
            }
            this.detailsGenerator = detailsGenerator;
            this.refreshDetails();
        }

        public DetailsGenerator getDetailsGenerator() {
            return this.detailsGenerator;
        }

        public boolean isDetailsVisible(Object itemId) {
            return this.openDetails.contains(itemId);
        }
    }

    @Deprecated
    public static interface DetailsGenerator
    extends Serializable {
        public static final DetailsGenerator NULL = new DetailsGenerator(){

            @Override
            public Component getDetails(RowReference rowReference) {
                return null;
            }
        };

        public Component getDetails(RowReference var1);
    }

    @Deprecated
    public static class ColumnVisibilityChangeEvent
    extends Component.Event {
        private final Column column;
        private final boolean userOriginated;
        private final boolean hidden;

        public ColumnVisibilityChangeEvent(Grid source, Column column, boolean hidden, boolean isUserOriginated) {
            super((Component)source);
            this.column = column;
            this.hidden = hidden;
            this.userOriginated = isUserOriginated;
        }

        public Column getColumn() {
            return this.column;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public boolean isUserOriginated() {
            return this.userOriginated;
        }
    }

    @Deprecated
    public static interface ColumnVisibilityChangeListener
    extends Serializable {
        public void columnVisibilityChanged(ColumnVisibilityChangeEvent var1);
    }
}

