/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.event.FieldEvents;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.server.Resource;
import com.vaadin.server.VariableOwner;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.shared.ui.combobox.ComboBoxState;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.AbstractSelect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Deprecated
public class ComboBox
extends AbstractSelect
implements AbstractSelect.Filtering,
FieldEvents.BlurNotifier,
FieldEvents.FocusNotifier {
    private String inputPrompt = null;
    protected int pageLength = 10;
    private int currentPage = -1;
    private FilteringMode filteringMode = FilteringMode.STARTSWITH;
    private String filterstring;
    private String prevfilterstring;
    private int filteredSize;
    private List<Object> filteredOptions;
    private boolean optionRequest;
    private boolean isPainting;
    private boolean scrollToSelectedItem = true;
    private String suggestionPopupWidth = null;
    private boolean textInputAllowed = true;
    private ItemStyleGenerator itemStyleGenerator = null;

    public ComboBox() {
        this.initDefaults();
    }

    public ComboBox(String caption, Collection<?> options) {
        super(caption, options);
        this.initDefaults();
    }

    public ComboBox(String caption, Container dataSource) {
        super(caption, dataSource);
        this.initDefaults();
    }

    public ComboBox(String caption) {
        super(caption);
        this.initDefaults();
    }

    private void initDefaults() {
        this.setNewItemsAllowed(false);
        this.setImmediate(true);
    }

    public String getInputPrompt() {
        return this.inputPrompt;
    }

    public void setInputPrompt(String inputPrompt) {
        this.inputPrompt = inputPrompt;
        this.markAsDirty();
    }

    private boolean isFilteringNeeded() {
        return this.filterstring != null && !this.filterstring.isEmpty() && this.filteringMode != FilteringMode.OFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintContent(PaintTarget target) throws PaintException {
        this.isPainting = true;
        try {
            boolean paintNullSelection;
            if (this.inputPrompt != null) {
                target.addAttribute("prompt", this.inputPrompt);
            }
            if (!this.textInputAllowed) {
                target.addAttribute("noInput", true);
            }
            this.getCaptionChangeListener().clear();
            if (this.getTabIndex() != 0) {
                target.addAttribute("tabindex", this.getTabIndex());
            }
            if (this.isModified()) {
                target.addAttribute("modified", true);
            }
            if (this.isNewItemsAllowed()) {
                target.addAttribute("allownewitem", true);
            }
            boolean needNullSelectOption = false;
            if (this.isNullSelectionAllowed()) {
                target.addAttribute("nullselect", true);
                boolean bl = needNullSelectOption = this.getNullSelectionItemId() == null;
                if (!needNullSelectOption) {
                    target.addAttribute("nullselectitem", true);
                }
            }
            String[] selectedKeys = new String[this.getValue() == null && this.getNullSelectionItemId() == null ? 0 : 1];
            target.addAttribute("pagelength", this.pageLength);
            if (this.suggestionPopupWidth != null) {
                target.addAttribute("suggestionPopupWidth", this.suggestionPopupWidth);
            }
            target.addAttribute("filteringmode", this.getFilteringMode().toString());
            int keyIndex = 0;
            target.startTag("options");
            if (this.currentPage < 0) {
                this.optionRequest = false;
                this.currentPage = 0;
                this.filterstring = "";
            }
            boolean nullFilteredOut = this.isFilteringNeeded();
            boolean nullOptionVisible = needNullSelectOption && !nullFilteredOut;
            List<?> options = this.getOptionsWithFilter(nullOptionVisible);
            if (null == options) {
                options = this.getFilteredOptions();
                this.filteredSize = options.size();
                options = this.sanitizeList(options, nullOptionVisible);
            }
            boolean bl = paintNullSelection = needNullSelectOption && this.currentPage == 0 && !nullFilteredOut;
            if (paintNullSelection) {
                target.startTag("so");
                target.addAttribute("caption", "");
                target.addAttribute("key", "");
                this.paintItemStyle(target, null);
                target.endTag("so");
            }
            for (Object id : options) {
                if (!this.isNullSelectionAllowed() && id != null && id.equals(this.getNullSelectionItemId()) && !this.isSelected(id)) continue;
                String key = this.itemIdMapper.key(id);
                String caption = this.getItemCaption(id);
                Resource icon = this.getItemIcon(id);
                this.getCaptionChangeListener().addNotifierForItem(id);
                target.startTag("so");
                if (icon != null) {
                    target.addAttribute("icon", icon);
                }
                target.addAttribute("caption", caption);
                if (id != null && id.equals(this.getNullSelectionItemId())) {
                    target.addAttribute("nullselection", true);
                }
                target.addAttribute("key", key);
                if (keyIndex < selectedKeys.length && this.isSelected(id)) {
                    selectedKeys[keyIndex++] = key;
                }
                this.paintItemStyle(target, id);
                target.endTag("so");
            }
            target.endTag("options");
            target.addAttribute("totalitems", this.size() + (needNullSelectOption ? 1 : 0));
            if (this.filteredSize > 0 || nullOptionVisible) {
                target.addAttribute("totalMatches", this.filteredSize + (nullOptionVisible ? 1 : 0));
            }
            target.addVariable((VariableOwner)this, "selected", selectedKeys);
            if (this.getValue() != null && selectedKeys[0] == null) {
                target.addAttribute("selectedCaption", this.getItemCaption(this.getValue()));
            }
            if (this.isNewItemsAllowed()) {
                target.addVariable((VariableOwner)this, "newitem", "");
            }
            target.addVariable((VariableOwner)this, "filter", this.filterstring);
            target.addVariable((VariableOwner)this, "page", this.currentPage);
            this.currentPage = -1;
            this.optionRequest = true;
        }
        finally {
            this.isPainting = false;
        }
    }

    private void paintItemStyle(PaintTarget target, Object itemId) throws PaintException {
        String style;
        if (this.itemStyleGenerator != null && (style = this.itemStyleGenerator.getStyle(this, itemId)) != null && !style.isEmpty()) {
            target.addAttribute("style", style);
        }
    }

    public void setTextInputAllowed(boolean textInputAllowed) {
        this.textInputAllowed = textInputAllowed;
        this.markAsDirty();
    }

    public boolean isTextInputAllowed() {
        return this.textInputAllowed;
    }

    protected ComboBoxState getState() {
        return (ComboBoxState)super.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<?> getOptionsWithFilter(boolean needNullSelectOption) {
        Container container = this.getContainerDataSource();
        if (this.pageLength == 0 && !this.isFilteringNeeded()) {
            this.filteredSize = container.size();
            assert (this.filteredSize >= 0);
            return new ArrayList(container.getItemIds());
        }
        if (!(container instanceof Container.Filterable) || !(container instanceof Container.Indexed) || this.getItemCaptionMode() != ITEM_CAPTION_MODE_PROPERTY) {
            return null;
        }
        Container.Filterable filterable = (Container.Filterable)container;
        Container.Filter filter = this.buildFilter(this.filterstring, this.filteringMode);
        if (filter != null) {
            filterable.addContainerFilter(filter);
        }
        try {
            List<?> options;
            Container.Indexed indexed = (Container.Indexed)container;
            int indexToEnsureInView = -1;
            Object selection = this.getValue();
            if (this.isScrollToSelectedItem() && !this.optionRequest && selection != null) {
                indexToEnsureInView = indexed.indexOfId(selection);
            }
            this.filteredSize = container.size();
            assert (this.filteredSize >= 0);
            this.currentPage = this.adjustCurrentPage(this.currentPage, needNullSelectOption, indexToEnsureInView, this.filteredSize);
            int first = this.getFirstItemIndexOnCurrentPage(needNullSelectOption, this.filteredSize);
            int last = this.getLastItemIndexOnCurrentPage(needNullSelectOption, this.filteredSize, first);
            int lastItemToFetch = Math.min(last, this.filteredSize - 1);
            int nrOfItemsToFetch = lastItemToFetch + 1 - first;
            List<?> list = options = indexed.getItemIds(first, nrOfItemsToFetch);
            return list;
        }
        finally {
            if (filter != null) {
                filterable.removeContainerFilter(filter);
            }
        }
    }

    protected Container.Filter buildFilter(String filterString, FilteringMode filteringMode) {
        SimpleStringFilter filter = null;
        if (null != filterString && !"".equals(filterString)) {
            switch (filteringMode) {
                case OFF: {
                    break;
                }
                case STARTSWITH: {
                    filter = new SimpleStringFilter(this.getItemCaptionPropertyId(), filterString, true, true);
                    break;
                }
                case CONTAINS: {
                    filter = new SimpleStringFilter(this.getItemCaptionPropertyId(), filterString, true, false);
                }
            }
        }
        return filter;
    }

    @Override
    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        if (!this.isPainting) {
            super.containerItemSetChange(event);
        }
    }

    List<?> sanitizeList(List<?> options, boolean needNullSelectOption) {
        int totalRows = options.size() + (needNullSelectOption ? 1 : 0);
        if (this.pageLength != 0 && totalRows > this.pageLength) {
            int indexToEnsureInView = -1;
            Object selection = this.getValue();
            if (this.isScrollToSelectedItem() && !this.optionRequest && selection != null) {
                indexToEnsureInView = options.indexOf(selection);
            }
            int size = options.size();
            this.currentPage = this.adjustCurrentPage(this.currentPage, needNullSelectOption, indexToEnsureInView, size);
            int first = this.getFirstItemIndexOnCurrentPage(needNullSelectOption, size);
            int last = this.getLastItemIndexOnCurrentPage(needNullSelectOption, size, first);
            return options.subList(first, last + 1);
        }
        return options;
    }

    private int getFirstItemIndexOnCurrentPage(boolean needNullSelectOption, int size) {
        int first = this.currentPage * this.pageLength;
        if (needNullSelectOption && this.currentPage > 0) {
            --first;
        }
        return first;
    }

    private int getLastItemIndexOnCurrentPage(boolean needNullSelectOption, int size, int first) {
        int effectivePageLength = this.pageLength - (needNullSelectOption && this.currentPage == 0 ? 1 : 0);
        return this.pageLength == 0 ? size - 1 : Math.min(size - 1, first + effectivePageLength - 1);
    }

    private int adjustCurrentPage(int page, boolean needNullSelectOption, int indexToEnsureInView, int size) {
        if (indexToEnsureInView != -1) {
            int newPage;
            page = newPage = (indexToEnsureInView + (needNullSelectOption ? 1 : 0)) / this.pageLength;
        }
        if (page * this.pageLength > size) {
            page = (size + (needNullSelectOption ? 1 : 0)) / this.pageLength;
        }
        return page;
    }

    protected List<?> getFilteredOptions() {
        if (!this.isFilteringNeeded()) {
            this.prevfilterstring = null;
            this.filteredOptions = new LinkedList(this.getItemIds());
            return this.filteredOptions;
        }
        if (this.filterstring.equals(this.prevfilterstring)) {
            return this.filteredOptions;
        }
        Collection<Object> items = this.prevfilterstring != null && this.filterstring.startsWith(this.prevfilterstring) ? this.filteredOptions : this.getItemIds();
        this.prevfilterstring = this.filterstring;
        this.filteredOptions = new LinkedList<Object>();
        block3: for (Object itemId : items) {
            String caption = this.getItemCaption(itemId);
            if (caption == null || caption.equals("")) continue;
            caption = caption.toLowerCase(this.getLocale());
            switch (this.filteringMode) {
                case CONTAINS: {
                    if (caption.indexOf(this.filterstring) <= -1) continue block3;
                    this.filteredOptions.add(itemId);
                    continue block3;
                }
            }
            if (!caption.startsWith(this.filterstring)) continue;
            this.filteredOptions.add(itemId);
        }
        return this.filteredOptions;
    }

    @Override
    public void changeVariables(Object source, Map<String, Object> variables) {
        String newitem;
        String newFilter;
        if (variables.containsKey("selected")) {
            String[] ka = (String[])variables.get("selected");
            if (ka.length == 0) {
                Object current = this.getValue();
                Collection<?> visible = this.getVisibleItemIds();
                if (visible != null && visible.contains(current)) {
                    this.setValue(null, true);
                }
            } else {
                Object id = this.itemIdMapper.get(ka[0]);
                if (id != null && id.equals(this.getNullSelectionItemId())) {
                    this.setValue(null, true);
                } else {
                    this.setValue(id, true);
                }
            }
        }
        if ((newFilter = (String)variables.get("filter")) != null) {
            this.currentPage = (Integer)variables.get("page");
            this.filterstring = newFilter;
            if (this.filterstring != null) {
                this.filterstring = this.filterstring.toLowerCase(this.getLocale());
            }
            this.requestRepaint();
        } else if (this.isNewItemsAllowed() && (newitem = (String)variables.get("newitem")) != null && !newitem.isEmpty()) {
            this.getNewItemHandler().addNewItem(newitem);
            this.filterstring = null;
            this.prevfilterstring = null;
        }
        if (variables.containsKey("focus")) {
            this.fireEvent((EventObject)new FieldEvents.FocusEvent((Component)this));
        }
        if (variables.containsKey("blur")) {
            this.fireEvent((EventObject)new FieldEvents.BlurEvent((Component)this));
        }
    }

    @Override
    public void setFilteringMode(FilteringMode filteringMode) {
        this.filteringMode = filteringMode;
    }

    @Override
    public FilteringMode getFilteringMode() {
        return this.filteringMode;
    }

    @Override
    public void addBlurListener(FieldEvents.BlurListener listener) {
        this.addListener("blur", FieldEvents.BlurEvent.class, listener, FieldEvents.BlurListener.blurMethod);
    }

    @Override
    public void removeBlurListener(FieldEvents.BlurListener listener) {
        this.removeListener("blur", FieldEvents.BlurEvent.class, listener);
    }

    @Override
    public void addFocusListener(FieldEvents.FocusListener listener) {
        this.addListener("focus", FieldEvents.FocusEvent.class, listener, FieldEvents.FocusListener.focusMethod);
    }

    @Override
    public void removeFocusListener(FieldEvents.FocusListener listener) {
        this.removeListener("focus", FieldEvents.FocusEvent.class, listener);
    }

    @Override
    @Deprecated
    public void setMultiSelect(boolean multiSelect) {
        if (multiSelect) {
            throw new UnsupportedOperationException("Multiselect not supported");
        }
    }

    @Override
    @Deprecated
    public boolean isMultiSelect() {
        return false;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public String getPopupWidth() {
        return this.suggestionPopupWidth;
    }

    public void setPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.markAsDirty();
    }

    public void setPopupWidth(String width) {
        this.suggestionPopupWidth = width;
        this.markAsDirty();
    }

    public void setScrollToSelectedItem(boolean scrollToSelectedItem) {
        this.scrollToSelectedItem = scrollToSelectedItem;
    }

    public boolean isScrollToSelectedItem() {
        return this.scrollToSelectedItem;
    }

    public void setItemStyleGenerator(ItemStyleGenerator itemStyleGenerator) {
        this.itemStyleGenerator = itemStyleGenerator;
        this.markAsDirty();
    }

    public ItemStyleGenerator getItemStyleGenerator() {
        return this.itemStyleGenerator;
    }

    @Deprecated
    public static interface ItemStyleGenerator
    extends Serializable {
        public String getStyle(ComboBox var1, Object var2);
    }
}

