/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.event.FieldEvents;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.server.VariableOwner;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.LegacyComponent;
import com.vaadin.ui.declarative.DesignAttributeHandler;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.validator.DateRangeValidator;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.shared.ui.datefield.Resolution;
import com.vaadin.v7.shared.ui.datefield.TextualDateFieldState;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.Form;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.jsoup.nodes.Element;

@Deprecated
public class DateField
extends AbstractField<Date>
implements FieldEvents.BlurNotifier,
FieldEvents.FocusNotifier,
LegacyComponent {
    @Deprecated
    public static final Resolution RESOLUTION_SEC = Resolution.SECOND;
    @Deprecated
    public static final Resolution RESOLUTION_MIN = Resolution.MINUTE;
    @Deprecated
    public static final Resolution RESOLUTION_HOUR = Resolution.HOUR;
    @Deprecated
    public static final Resolution RESOLUTION_DAY = Resolution.DAY;
    @Deprecated
    public static final Resolution RESOLUTION_MONTH = Resolution.MONTH;
    @Deprecated
    public static final Resolution RESOLUTION_YEAR = Resolution.YEAR;
    private Resolution resolution = Resolution.DAY;
    private transient Calendar calendar;
    private String dateFormat;
    private boolean lenient = false;
    private String dateString = null;
    private boolean uiHasValidDateString = true;
    private boolean showISOWeekNumbers = false;
    private String currentParseErrorMessage;
    private String defaultParseErrorMessage = "Date format not recognized";
    private TimeZone timeZone = null;
    private static Map<Resolution, String> variableNameForResolution = new HashMap<Resolution, String>();
    private String dateOutOfRangeMessage = "Date is out of allowed range";
    private DateRangeValidator currentRangeValidator;
    private boolean preventValueChangeEvent = false;

    public DateField() {
    }

    public DateField(String caption) {
        this.setCaption(caption);
    }

    public DateField(String caption, Property dataSource) {
        this(dataSource);
        this.setCaption(caption);
    }

    public DateField(Property dataSource) throws IllegalArgumentException {
        if (!Date.class.isAssignableFrom(dataSource.getType())) {
            throw new IllegalArgumentException("Can't use " + dataSource.getType().getName() + " typed property as datasource");
        }
        this.setPropertyDataSource(dataSource);
    }

    public DateField(String caption, Date value) {
        this.setValue(value);
        this.setCaption(caption);
    }

    public void paintContent(PaintTarget target) throws PaintException {
        Locale l = this.getLocale();
        if (l != null) {
            target.addAttribute("locale", l.toString());
        }
        if (this.getDateFormat() != null) {
            target.addAttribute("format", this.dateFormat);
        }
        if (!this.isLenient()) {
            target.addAttribute("strict", true);
        }
        target.addAttribute("wn", this.isShowISOWeekNumbers());
        target.addAttribute("parsable", this.uiHasValidDateString);
        Calendar calendar = this.getCalendar();
        Date currentDate = (Date)this.getValue();
        for (Resolution res : Resolution.getResolutionsHigherOrEqualTo((Resolution)this.resolution)) {
            int value = -1;
            if (currentDate != null) {
                value = calendar.get(res.getCalendarField());
                if (res == Resolution.MONTH) {
                    ++value;
                }
            }
            target.addVariable((VariableOwner)this, variableNameForResolution.get(res), value);
        }
    }

    @Override
    protected boolean shouldHideErrors() {
        return super.shouldHideErrors() && this.uiHasValidDateString;
    }

    protected TextualDateFieldState getState() {
        return (TextualDateFieldState)super.getState();
    }

    protected TextualDateFieldState getState(boolean markAsDirty) {
        return (TextualDateFieldState)super.getState(markAsDirty);
    }

    public void setRangeStart(Date startDate) {
        if (startDate != null && this.getState().rangeEnd != null && startDate.after(this.getState().rangeEnd)) {
            throw new IllegalStateException("startDate cannot be later than endDate");
        }
        this.getState().rangeStart = startDate != null ? new Date(startDate.getTime()) : null;
        this.updateRangeValidator();
    }

    public void setDateOutOfRangeMessage(String dateOutOfRangeMessage) {
        this.dateOutOfRangeMessage = dateOutOfRangeMessage;
        this.updateRangeValidator();
    }

    private Date getRangeEnd(Resolution forResolution) {
        Date rangeEnd = this.getState((boolean)false).rangeEnd;
        if (rangeEnd == null) {
            return null;
        }
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(rangeEnd);
        if (forResolution == Resolution.YEAR) {
            endCal.set(endCal.get(1) + 1, 0, 1, 0, 0, 0);
        } else if (forResolution == Resolution.MONTH) {
            endCal.set(endCal.get(1), endCal.get(2) + 1, 1, 0, 0, 0);
        } else {
            endCal.set(endCal.get(1), endCal.get(2), endCal.get(5) + 1, 0, 0, 0);
        }
        endCal.set(14, -1);
        return endCal.getTime();
    }

    private Date getRangeStart(Resolution forResolution) {
        if (this.getState((boolean)false).rangeStart == null) {
            return null;
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(this.getState((boolean)false).rangeStart);
        if (forResolution == Resolution.YEAR) {
            startCal.set(startCal.get(1), 0, 1, 0, 0, 0);
        } else if (forResolution == Resolution.MONTH) {
            startCal.set(startCal.get(1), startCal.get(2), 1, 0, 0, 0);
        } else {
            startCal.set(startCal.get(1), startCal.get(2), startCal.get(5), 0, 0, 0);
        }
        startCal.set(14, 0);
        return startCal.getTime();
    }

    private void updateRangeValidator() {
        if (this.currentRangeValidator != null) {
            this.removeValidator(this.currentRangeValidator);
            this.currentRangeValidator = null;
        }
        if (this.getRangeStart() != null || this.getRangeEnd() != null) {
            this.currentRangeValidator = new DateRangeValidator(this.dateOutOfRangeMessage, this.getRangeStart(this.resolution), this.getRangeEnd(this.resolution), null);
            this.addValidator(this.currentRangeValidator);
        }
    }

    public void setRangeEnd(Date endDate) {
        if (endDate != null && this.getState().rangeStart != null && this.getState().rangeStart.after(endDate)) {
            throw new IllegalStateException("endDate cannot be earlier than startDate");
        }
        this.getState().rangeEnd = endDate != null ? new Date(endDate.getTime()) : null;
        this.updateRangeValidator();
    }

    public Date getRangeStart() {
        return this.getState((boolean)false).rangeStart;
    }

    public Date getRangeEnd() {
        return this.getState((boolean)false).rangeEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeVariables(Object source, Map<String, Object> variables) {
        if (!this.isReadOnly() && (variables.containsKey("year") || variables.containsKey("month") || variables.containsKey("day") || variables.containsKey("hour") || variables.containsKey("min") || variables.containsKey("sec") || variables.containsKey("msec") || variables.containsKey("dateString"))) {
            String newDateString;
            Date oldDate = (Date)this.getValue();
            Date newDate = null;
            this.dateString = newDateString = (String)variables.get("dateString");
            boolean hasChanges = false;
            HashMap<Resolution, Integer> calendarFieldChanges = new HashMap<Resolution, Integer>();
            for (Resolution r : Resolution.getResolutionsHigherOrEqualTo((Resolution)this.resolution)) {
                String variableName = variableNameForResolution.get(r);
                if (!variables.containsKey(variableName)) continue;
                Integer value = (Integer)variables.get(variableName);
                if (r == Resolution.MONTH) {
                    Integer n = value;
                    Integer n2 = value = Integer.valueOf(value - 1);
                }
                if (value < 0) continue;
                hasChanges = true;
                calendarFieldChanges.put(r, value);
            }
            if (!hasChanges) {
                newDate = null;
            } else {
                Calendar cal = this.getCalendar();
                for (int r = Resolution.YEAR.ordinal(); r >= 0; --r) {
                    Resolution res = Resolution.values()[r];
                    if (!calendarFieldChanges.containsKey(res)) continue;
                    Integer newValue = (Integer)calendarFieldChanges.get(res);
                    cal.set(res.getCalendarField(), newValue);
                }
                newDate = cal.getTime();
            }
            if (newDate == null && this.dateString != null && !"".equals(this.dateString)) {
                try {
                    Date parsedDate = this.handleUnparsableDateString(this.dateString);
                    this.setValue(parsedDate, true);
                    this.markAsDirty();
                }
                catch (Converter.ConversionException e) {
                    if (oldDate != null) {
                        this.preventValueChangeEvent = true;
                        try {
                            this.setValue(null);
                        }
                        finally {
                            this.preventValueChangeEvent = false;
                        }
                        this.dateString = newDateString;
                    }
                    this.currentParseErrorMessage = e.getLocalizedMessage();
                    this.uiHasValidDateString = false;
                    if (oldDate != null) {
                        this.fireValueChange(false);
                    }
                    this.notifyFormOfValidityChange();
                    this.markAsDirty();
                }
            } else if (!(newDate == oldDate || newDate != null && newDate.equals(oldDate))) {
                this.setValue(newDate, true);
            } else if (!this.uiHasValidDateString) {
                this.setValue(null);
            }
        }
        if (variables.containsKey("focus")) {
            this.fireEvent((EventObject)new FieldEvents.FocusEvent((Component)this));
        }
        if (variables.containsKey("blur")) {
            this.fireEvent((EventObject)new FieldEvents.BlurEvent((Component)this));
        }
    }

    @Override
    public void discard() {
        Property prop = this.getPropertyDataSource();
        if (prop != null) {
            Object value = prop.getValue();
            if (!this.isValid() && value == null) {
                this.setInternalValue(null);
            } else {
                super.discard();
            }
        }
    }

    @Override
    protected void fireValueChange(boolean repaintIsNotNeeded) {
        if (!this.preventValueChangeEvent) {
            super.fireValueChange(repaintIsNotNeeded);
        }
    }

    protected Date handleUnparsableDateString(String dateString) throws Converter.ConversionException {
        this.currentParseErrorMessage = null;
        throw new Converter.ConversionException(this.getParseErrorMessage());
    }

    @Override
    public Class<Date> getType() {
        return Date.class;
    }

    @Override
    protected void setValue(Date newValue, boolean repaintIsNotNeeded) throws Property.ReadOnlyException {
        if (newValue == null && !this.uiHasValidDateString) {
            this.setInternalValue(null);
            this.notifyFormOfValidityChange();
            this.markAsDirty();
            return;
        }
        super.setValue(newValue, repaintIsNotNeeded);
    }

    private void notifyFormOfValidityChange() {
        boolean formFound = false;
        for (HasComponents parenOfDateField = this.getParent(); parenOfDateField != null || formFound; parenOfDateField = parenOfDateField.getParent()) {
            if (parenOfDateField instanceof Form) {
                Form f = (Form)parenOfDateField;
                Collection<?> visibleItemProperties = f.getItemPropertyIds();
                for (Object fieldId : visibleItemProperties) {
                    Field field = f.getField(fieldId);
                    if (!this.equals(field)) continue;
                    f.markAsDirty();
                    formFound = true;
                    break;
                }
            }
            if (formFound) break;
        }
    }

    @Override
    protected void setInternalValue(Date newValue) {
        this.dateString = newValue != null ? newValue.toString() : null;
        if (!this.uiHasValidDateString) {
            this.setComponentError(null);
            this.uiHasValidDateString = true;
            this.currentParseErrorMessage = null;
        }
        super.setInternalValue(newValue);
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
        this.updateRangeValidator();
        this.markAsDirty();
    }

    private Calendar getCalendar() {
        Date currentDate;
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
            for (Resolution r : Resolution.getResolutionsLowerThan((Resolution)this.resolution)) {
                int field = r.getCalendarField();
                int min = this.calendar.getActualMinimum(field);
                this.calendar.set(field, min);
            }
            this.calendar.set(14, 0);
        }
        Calendar newCal = (Calendar)this.calendar.clone();
        TimeZone currentTimeZone = this.getTimeZone();
        if (currentTimeZone != null) {
            newCal.setTimeZone(currentTimeZone);
        }
        if ((currentDate = (Date)this.getValue()) != null) {
            newCal.setTime(currentDate);
        }
        return newCal;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.markAsDirty();
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
        this.markAsDirty();
    }

    public boolean isLenient() {
        return this.lenient;
    }

    @Override
    public void addFocusListener(FieldEvents.FocusListener listener) {
        this.addListener("focus", FieldEvents.FocusEvent.class, listener, FieldEvents.FocusListener.focusMethod);
    }

    @Override
    public void removeFocusListener(FieldEvents.FocusListener listener) {
        this.removeListener("focus", FieldEvents.FocusEvent.class, listener);
    }

    @Override
    public void addBlurListener(FieldEvents.BlurListener listener) {
        this.addListener("blur", FieldEvents.BlurEvent.class, listener, FieldEvents.BlurListener.blurMethod);
    }

    @Override
    public void removeBlurListener(FieldEvents.BlurListener listener) {
        this.removeListener("blur", FieldEvents.BlurEvent.class, listener);
    }

    public boolean isShowISOWeekNumbers() {
        return this.showISOWeekNumbers;
    }

    public void setShowISOWeekNumbers(boolean showWeekNumbers) {
        this.showISOWeekNumbers = showWeekNumbers;
        this.markAsDirty();
    }

    @Override
    public void validate() throws Validator.InvalidValueException {
        if (!this.uiHasValidDateString) {
            throw new UnparsableDateString(this.currentParseErrorMessage);
        }
        super.validate();
    }

    public String getParseErrorMessage() {
        return this.defaultParseErrorMessage;
    }

    public void setParseErrorMessage(String parsingErrorMessage) {
        this.defaultParseErrorMessage = parsingErrorMessage;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.markAsDirty();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void readDesign(Element design, DesignContext designContext) {
        super.readDesign(design, designContext);
        if (design.hasAttr("value") && !design.attr("value").isEmpty()) {
            Date date = (Date)DesignAttributeHandler.getFormatter().parse(design.attr("value"), Date.class);
            if (date == null) {
                Logger.getLogger(DateField.class.getName()).info("cannot parse " + design.attr("value") + " as date");
            }
            this.setValue(date, false, true);
        }
    }

    @Override
    public void writeDesign(Element design, DesignContext designContext) {
        super.writeDesign(design, designContext);
        if (this.getValue() != null) {
            design.attr("value", DesignAttributeHandler.getFormatter().format(this.getValue()));
        }
    }

    public String getDateOutOfRangeMessage() {
        return this.dateOutOfRangeMessage;
    }

    static {
        variableNameForResolution.put(Resolution.SECOND, "sec");
        variableNameForResolution.put(Resolution.MINUTE, "min");
        variableNameForResolution.put(Resolution.HOUR, "hour");
        variableNameForResolution.put(Resolution.DAY, "day");
        variableNameForResolution.put(Resolution.MONTH, "month");
        variableNameForResolution.put(Resolution.YEAR, "year");
    }

    @Deprecated
    public static class UnparsableDateString
    extends Validator.InvalidValueException {
        public UnparsableDateString(String message) {
            super(message);
        }
    }
}

