/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.event.Action;
import com.vaadin.event.ActionManager;
import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.CompositeErrorMessage;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.server.UserError;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.LegacyComponent;
import com.vaadin.v7.data.Buffered;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.util.BeanItem;
import com.vaadin.v7.shared.form.FormState;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.AbstractLegacyComponent;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.DefaultFieldFactory;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.FormFieldFactory;
import com.vaadin.v7.ui.ListSelect;
import com.vaadin.v7.ui.Select;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

@Deprecated
public class Form
extends AbstractField<Object>
implements Item.Editor,
Item,
Action.Notifier,
HasComponents,
LegacyComponent {
    private Object propertyValue;
    private Item itemDatasource;
    private final LinkedList<Object> propertyIds = new LinkedList();
    private Buffered.SourceException currentBufferedSourceException = null;
    private boolean buffered = false;
    private final Map<Object, Field<?>> fields = new HashMap();
    private final Map<Object, Property<?>> ownProperties = new HashMap();
    private FormFieldFactory fieldFactory;
    private Collection<?> visibleItemProperties;
    private final Property.ValueChangeListener fieldValueChangeListener = new Property.ValueChangeListener(){

        @Override
        public void valueChange(Property.ValueChangeEvent event) {
            Form.this.markAsDirty();
        }
    };
    private boolean validationVisibleOnCommit = true;
    private int gridlayoutCursorX = -1;
    private int gridlayoutCursorY = -1;
    private ActionManager ownActionManager = new ActionManager((Component)this);

    public Form() {
        this(null);
        this.setValidationVisible(false);
    }

    public Form(Layout formLayout) {
        this(formLayout, DefaultFieldFactory.get());
    }

    public Form(Layout formLayout, FormFieldFactory fieldFactory) {
        this.setLayout(formLayout);
        this.setFooter((Layout)new HorizontalLayout());
        this.setFormFieldFactory(fieldFactory);
        this.setValidationVisible(false);
        this.setWidth(100.0f, UNITS_PERCENTAGE);
    }

    protected FormState getState() {
        return (FormState)super.getState();
    }

    protected FormState getState(boolean markAsDirty) {
        return (FormState)super.getState(markAsDirty);
    }

    public void paintContent(PaintTarget target) throws PaintException {
        if (this.ownActionManager != null) {
            this.ownActionManager.paintActions(null, target);
        }
    }

    public void changeVariables(Object source, Map<String, Object> variables) {
        if (this.ownActionManager != null) {
            this.ownActionManager.handleActions(variables, (Action.Container)this);
        }
    }

    @Override
    public ErrorMessage getErrorMessage() {
        ErrorMessage validationError = null;
        if (this.isValidationVisible()) {
            for (Object e : this.propertyIds) {
                Field<?> f = this.fields.get(e);
                if (!(f instanceof AbstractComponent)) continue;
                AbstractComponent field = (AbstractComponent)f;
                validationError = field.getErrorMessage();
                if (validationError != null) {
                    if (!"".equals(validationError.toString())) break;
                    validationError = new UserError(field.getCaption());
                    break;
                }
                if (!(f instanceof Field) || f.isValid()) continue;
                validationError = new UserError(field.getCaption());
                break;
            }
        }
        if (this.getComponentError() == null && validationError == null && this.currentBufferedSourceException == null) {
            return null;
        }
        return new CompositeErrorMessage(new ErrorMessage[]{this.getComponentError(), validationError, AbstractErrorMessage.getErrorMessageForException((Throwable)this.currentBufferedSourceException)});
    }

    public void setValidationVisibleOnCommit(boolean makeVisible) {
        this.validationVisibleOnCommit = makeVisible;
    }

    public boolean isValidationVisibleOnCommit() {
        return this.validationVisibleOnCommit;
    }

    @Override
    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        Buffered.SourceException sourceException;
        LinkedList<Buffered.SourceException> problems = null;
        if (!this.isInvalidCommitted() && !this.isValid()) {
            if (this.validationVisibleOnCommit) {
                this.setValidationVisible(true);
            }
            this.validate();
        }
        for (Object e : this.propertyIds) {
            try {
                Field<?> f = this.fields.get(e);
                if (f.isReadOnly()) continue;
                f.commit();
            }
            catch (Buffered.SourceException e2) {
                if (problems == null) {
                    problems = new LinkedList<Buffered.SourceException>();
                }
                problems.add(e2);
            }
        }
        if (problems == null) {
            if (this.currentBufferedSourceException != null) {
                this.currentBufferedSourceException = null;
                this.markAsDirty();
            }
            return;
        }
        Throwable[] causes = problems.toArray(new Throwable[problems.size()]);
        this.currentBufferedSourceException = sourceException = new Buffered.SourceException(this, causes);
        this.markAsDirty();
        throw sourceException;
    }

    @Override
    public void discard() throws Buffered.SourceException {
        Buffered.SourceException sourceException;
        LinkedList<Buffered.SourceException> problems = null;
        for (Object e : this.propertyIds) {
            try {
                this.fields.get(e).discard();
            }
            catch (Buffered.SourceException e2) {
                if (problems == null) {
                    problems = new LinkedList<Buffered.SourceException>();
                }
                problems.add(e2);
            }
        }
        if (problems == null) {
            if (this.currentBufferedSourceException != null) {
                this.currentBufferedSourceException = null;
                this.markAsDirty();
            }
            return;
        }
        Throwable[] causes = problems.toArray(new Throwable[problems.size()]);
        this.currentBufferedSourceException = sourceException = new Buffered.SourceException(this, causes);
        this.markAsDirty();
        throw sourceException;
    }

    @Override
    public boolean isModified() {
        for (Object e : this.propertyIds) {
            Field<?> f = this.fields.get(e);
            if (f == null || !f.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setBuffered(boolean buffered) {
        if (buffered != this.buffered) {
            this.buffered = buffered;
            for (Object e : this.propertyIds) {
                this.fields.get(e).setBuffered(buffered);
            }
        }
    }

    @Override
    public boolean addItemProperty(Object id, Property property) {
        if (id == null || property == null) {
            throw new NullPointerException("Id and property must be non-null");
        }
        if (this.propertyIds.contains(id)) {
            return false;
        }
        this.propertyIds.add(id);
        this.ownProperties.put(id, property);
        Field<?> field = this.fieldFactory.createField(this, id, (Component)this);
        if (field == null) {
            return false;
        }
        this.bindPropertyToField(id, property, field);
        this.addField(id, field);
        return true;
    }

    public void addField(Object propertyId, Field<?> field) {
        this.registerField(propertyId, field);
        this.attachField(propertyId, field);
        this.markAsDirty();
    }

    private void registerField(Object propertyId, Field<?> field) {
        if (propertyId == null || field == null) {
            return;
        }
        this.fields.put(propertyId, field);
        field.addListener(this.fieldValueChangeListener);
        if (!this.propertyIds.contains(propertyId)) {
            this.propertyIds.addLast(propertyId);
        }
        field.setBuffered(this.buffered);
        if (this.isImmediate() && field instanceof AbstractLegacyComponent) {
            ((AbstractLegacyComponent)((Object)field)).setImmediate(true);
        }
    }

    protected void attachField(Object propertyId, Field field) {
        if (propertyId == null || field == null) {
            return;
        }
        Layout layout = this.getLayout();
        if (layout instanceof CustomLayout) {
            ((CustomLayout)layout).addComponent((Component)field, propertyId.toString());
        } else {
            layout.addComponent((Component)field);
        }
    }

    @Override
    public Property getItemProperty(Object id) {
        Field<?> field = this.fields.get(id);
        if (field == null) {
            return this.ownProperties.get(id);
        }
        Property property = field.getPropertyDataSource();
        if (property != null) {
            return property;
        }
        return field;
    }

    public Field getField(Object propertyId) {
        return this.fields.get(propertyId);
    }

    @Override
    public Collection<?> getItemPropertyIds() {
        return Collections.unmodifiableCollection(this.propertyIds);
    }

    @Override
    public boolean removeItemProperty(Object id) {
        this.ownProperties.remove(id);
        Field<?> field = this.fields.get(id);
        if (field != null) {
            this.propertyIds.remove(id);
            this.fields.remove(id);
            this.detachField(field);
            field.removeListener(this.fieldValueChangeListener);
            return true;
        }
        return false;
    }

    protected void detachField(Field field) {
        HasComponents p = field.getParent();
        if (p instanceof ComponentContainer) {
            ((ComponentContainer)p).removeComponent((Component)field);
        }
    }

    public boolean removeAllProperties() {
        boolean success = true;
        for (Object property : this.propertyIds.toArray()) {
            if (this.removeItemProperty(property)) continue;
            success = false;
        }
        return success;
    }

    @Override
    public Item getItemDataSource() {
        return this.itemDatasource;
    }

    @Override
    public void setItemDataSource(Item newDataSource) {
        this.setItemDataSource(newDataSource, newDataSource != null ? newDataSource.getItemPropertyIds() : null);
    }

    public void setItemDataSource(Item newDataSource, Collection<?> propertyIds) {
        if (this.getLayout() instanceof GridLayout) {
            GridLayout gl = (GridLayout)this.getLayout();
            if (this.gridlayoutCursorX == -1) {
                this.gridlayoutCursorX = gl.getCursorX();
                this.gridlayoutCursorY = gl.getCursorY();
            } else {
                gl.setCursorX(this.gridlayoutCursorX);
                gl.setCursorY(this.gridlayoutCursorY);
            }
        }
        this.removeAllProperties();
        this.itemDatasource = newDataSource;
        if (this.itemDatasource == null) {
            this.markAsDirty();
            return;
        }
        for (Object id : propertyIds) {
            Field<?> f;
            Property property = this.itemDatasource.getItemProperty(id);
            if (id == null || property == null || (f = this.fieldFactory.createField(this.itemDatasource, id, (Component)this)) == null) continue;
            this.bindPropertyToField(id, property, f);
            this.addField(id, f);
        }
    }

    protected void bindPropertyToField(Object propertyId, Property property, Field field) {
        boolean hasFilterProperty;
        boolean bl = hasFilterProperty = field.getPropertyDataSource() != null && field.getPropertyDataSource() instanceof Property.Viewer;
        if (hasFilterProperty) {
            ((Property.Viewer)((Object)field.getPropertyDataSource())).setPropertyDataSource(property);
        } else {
            field.setPropertyDataSource(property);
        }
    }

    public Layout getLayout() {
        return (Layout)this.getState((boolean)false).layout;
    }

    public void setLayout(Layout layout) {
        if (layout == null) {
            layout = new FormLayout();
        }
        this.gridlayoutCursorX = -1;
        this.gridlayoutCursorY = -1;
        if (this.getLayout() != null) {
            for (Object e : this.propertyIds) {
                Field f = this.getField(e);
                this.detachField(f);
                if (layout instanceof CustomLayout) {
                    ((CustomLayout)layout).addComponent((Component)f, e.toString());
                    continue;
                }
                layout.addComponent((Component)f);
            }
            this.getLayout().setParent(null);
        }
        layout.setParent((HasComponents)this);
        this.getState().layout = layout;
    }

    public AbstractSelect replaceWithSelect(Object propertyId, Object[] values, Object[] descriptions) {
        if (propertyId == null || values == null || descriptions == null) {
            throw new NullPointerException("All parameters must be non-null");
        }
        if (values.length != descriptions.length) {
            throw new IllegalArgumentException("Value and description list are of different size");
        }
        Field<?> oldField = this.fields.get(propertyId);
        if (oldField == null) {
            throw new IllegalArgumentException("Field with given propertyid '" + propertyId + "' can not be found.");
        }
        Object value = oldField.getPropertyDataSource() == null ? oldField.getValue() : oldField.getPropertyDataSource().getValue();
        boolean found = false;
        boolean isMultiselect = false;
        for (int i = 0; i < values.length && !found; ++i) {
            if (values[i] != value && (value == null || !value.equals(values[i]))) continue;
            found = true;
        }
        if (value != null && !found) {
            if (value instanceof Collection) {
                for (Object val : (Collection)value) {
                    found = false;
                    for (int i = 0; i < values.length && !found; ++i) {
                        if (values[i] != val && (val == null || !val.equals(values[i]))) continue;
                        found = true;
                    }
                    if (found) continue;
                    throw new IllegalArgumentException("Currently selected value '" + val + "' of property '" + propertyId + "' was not found");
                }
                isMultiselect = true;
            } else {
                throw new IllegalArgumentException("Current value '" + value + "' of property '" + propertyId + "' was not found");
            }
        }
        AbstractSelect newField = isMultiselect ? new ListSelect() : new Select();
        newField.setCaption(oldField.getCaption());
        newField.setReadOnly(oldField.isReadOnly());
        newField.setBuffered(oldField.isBuffered());
        newField.addContainerProperty("desc", String.class, "");
        newField.setItemCaptionPropertyId("desc");
        for (int i = 0; i < values.length; ++i) {
            Item item;
            Object id = values[i];
            if (id == null) {
                id = newField.addItem();
                item = newField.getItem(id);
                newField.setNullSelectionItemId(id);
            } else {
                item = newField.addItem(id);
            }
            if (item == null) continue;
            item.getItemProperty("desc").setValue(descriptions[i].toString());
        }
        Property property = oldField.getPropertyDataSource();
        oldField.setPropertyDataSource(null);
        newField.setPropertyDataSource(property);
        this.getLayout().replaceComponent(oldField, (Component)newField);
        this.fields.put(propertyId, newField);
        newField.addListener(this.fieldValueChangeListener);
        oldField.removeListener(this.fieldValueChangeListener);
        return newField;
    }

    @Override
    public void validate() throws Validator.InvalidValueException {
        super.validate();
        for (Object e : this.propertyIds) {
            this.fields.get(e).validate();
        }
    }

    @Override
    public boolean isInvalidAllowed() {
        return true;
    }

    @Override
    public void setInvalidAllowed(boolean invalidValueAllowed) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        for (Object e : this.propertyIds) {
            this.fields.get(e).setReadOnly(readOnly);
        }
    }

    public void setFormFieldFactory(FormFieldFactory fieldFactory) {
        this.fieldFactory = fieldFactory;
    }

    public FormFieldFactory getFormFieldFactory() {
        return this.fieldFactory;
    }

    @Override
    public Class<?> getType() {
        if (this.getPropertyDataSource() != null) {
            return this.getPropertyDataSource().getType();
        }
        return Object.class;
    }

    @Override
    protected void setInternalValue(Object newValue) {
        Object oldValue = this.propertyValue;
        super.setInternalValue(newValue);
        this.propertyValue = newValue;
        if (oldValue != newValue) {
            this.setFormDataSource(newValue, this.getVisibleItemProperties());
        }
    }

    private Field<?> getFirstFocusableField() {
        Collection<?> itemPropertyIds = this.getItemPropertyIds();
        if (itemPropertyIds != null && !itemPropertyIds.isEmpty()) {
            for (Object id : itemPropertyIds) {
                Field field;
                if (id == null || !(field = this.getField(id)).isConnectorEnabled() || field.isReadOnly()) continue;
                return field;
            }
            Object id = itemPropertyIds.iterator().next();
            if (id != null) {
                return this.getField(id);
            }
        }
        return null;
    }

    protected void setFormDataSource(Object data, Collection<?> properties) {
        BeanItem<Object> item = null;
        if (data instanceof Item) {
            item = (BeanItem<Object>)data;
        } else if (data != null) {
            item = new BeanItem<Object>(data);
        }
        if (item != null && properties != null) {
            this.setItemDataSource(item, properties);
        } else {
            this.setItemDataSource(item);
        }
    }

    public Collection<?> getVisibleItemProperties() {
        return this.visibleItemProperties;
    }

    public void setVisibleItemProperties(Collection<?> visibleProperties) {
        this.visibleItemProperties = visibleProperties;
        Object value = this.getValue();
        if (value == null) {
            value = this.itemDatasource;
        }
        this.setFormDataSource(value, this.getVisibleItemProperties());
    }

    public void setVisibleItemProperties(Object ... visibleProperties) {
        LinkedList<Object> v = new LinkedList<Object>();
        for (int i = 0; i < visibleProperties.length; ++i) {
            v.add(visibleProperties[i]);
        }
        this.setVisibleItemProperties(v);
    }

    @Override
    public void focus() {
        Field<?> f = this.getFirstFocusableField();
        if (f != null) {
            f.focus();
        }
    }

    @Override
    public void setTabIndex(int tabIndex) {
        super.setTabIndex(tabIndex);
        for (Object id : this.getItemPropertyIds()) {
            this.getField(id).setTabIndex(tabIndex);
        }
    }

    @Override
    public void setImmediate(boolean immediate) {
        super.setImmediate(immediate);
        for (Field<?> f : this.fields.values()) {
            if (!(f instanceof AbstractLegacyComponent)) continue;
            ((AbstractLegacyComponent)((Object)f)).setImmediate(immediate);
        }
    }

    @Override
    public boolean isEmpty() {
        for (Field<?> f : this.fields.values()) {
            if (!(f instanceof AbstractField) || ((AbstractField)f).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        for (Field<?> f : this.fields.values()) {
            if (!(f instanceof AbstractField)) continue;
            ((AbstractField)f).clear();
        }
    }

    @Override
    public void addValidator(Validator validator) {
        throw new UnsupportedOperationException();
    }

    public Layout getFooter() {
        return (Layout)this.getState((boolean)false).footer;
    }

    public void setFooter(Layout footer) {
        if (this.getFooter() != null) {
            this.getFooter().setParent(null);
        }
        this.getState().footer = footer;
        if (footer != null) {
            footer.setParent((HasComponents)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getParent() != null && !this.getParent().isEnabled()) {
            return;
        }
        this.getLayout().markAsDirtyRecursive();
    }

    protected ActionManager getOwnActionManager() {
        if (this.ownActionManager == null) {
            this.ownActionManager = new ActionManager((Component)this);
        }
        return this.ownActionManager;
    }

    public void addActionHandler(Action.Handler actionHandler) {
        this.getOwnActionManager().addActionHandler(actionHandler);
    }

    public void removeActionHandler(Action.Handler actionHandler) {
        if (this.ownActionManager != null) {
            this.ownActionManager.removeActionHandler(actionHandler);
        }
    }

    public void removeAllActionHandlers() {
        if (this.ownActionManager != null) {
            this.ownActionManager.removeAllActionHandlers();
        }
    }

    public <T extends Action> void addAction(T action) {
        this.getOwnActionManager().addAction(action);
    }

    public <T extends Action> void removeAction(T action) {
        if (this.ownActionManager != null) {
            this.ownActionManager.removeAction(action);
        }
    }

    public Iterator<Component> iterator() {
        return new ComponentIterator();
    }

    @Deprecated
    public Iterator<Component> getComponentIterator() {
        return this.iterator();
    }

    public int getComponentCount() {
        int count = 0;
        if (this.getLayout() != null) {
            ++count;
        }
        if (this.getFooter() != null) {
            ++count;
        }
        return count;
    }

    private class ComponentIterator
    implements Iterator<Component>,
    Serializable {
        int i = 0;

        private ComponentIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < Form.this.getComponentCount();
        }

        @Override
        public Component next() {
            if (!this.hasNext()) {
                return null;
            }
            ++this.i;
            if (this.i == 1) {
                if (Form.this.getLayout() != null) {
                    return Form.this.getLayout();
                }
                if (Form.this.getFooter() != null) {
                    return Form.this.getFooter();
                }
            } else if (this.i == 2 && Form.this.getFooter() != null) {
                return Form.this.getFooter();
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.i == 1) {
                if (Form.this.getLayout() != null) {
                    Form.this.setLayout(null);
                    this.i = 0;
                } else {
                    Form.this.setFooter(null);
                }
            } else if (this.i == 2) {
                Form.this.setFooter(null);
            }
        }
    }
}

