/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.osgi.compatibility.themes;

import com.vaadin.osgi.resources.OsgiVaadinResources;
import com.vaadin.osgi.resources.VaadinResourceService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpService;

@Component(immediate=true)
public class LegacyThemeContributions {
    private static final String[] LEGACY_THEMES = new String[]{"base", "chameleon", "reindeer", "runo"};
    private HttpService httpService;

    @Activate
    void startup() throws Exception {
        VaadinResourceService service = OsgiVaadinResources.getService();
        for (String themeName : LEGACY_THEMES) {
            service.publishTheme(themeName, this.httpService);
        }
    }

    @Reference
    void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }
}

