/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.crud;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.crud.Crud;
import com.vaadin.flow.component.crud.CrudFilter;
import com.vaadin.flow.component.crud.CrudI18nUpdatedEvent;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.util.List;

public class CrudGrid<E>
extends Grid<E> {
    private final Class<E> beanType;
    private final boolean autogenerated;
    private final CrudFilter filter = new CrudFilter();
    private DataProvider<E, ?> dataProvider;

    public CrudGrid(Class<E> beanType, boolean enableDefaultFilters) {
        this(beanType, enableDefaultFilters, false);
    }

    CrudGrid(Class<E> beanType, boolean enableDefaultFilters, boolean autogenerated) {
        super(beanType);
        this.beanType = beanType;
        this.autogenerated = autogenerated;
        if (enableDefaultFilters) {
            this.setupFiltering();
        }
        this.setupSorting();
        Crud.addEditColumn(this);
        this.setSelectionMode(Grid.SelectionMode.NONE);
        ComponentUtil.addListener((Component)this, CrudI18nUpdatedEvent.class, (ComponentEventListener & Serializable)event -> {
            if (Crud.hasEditColumn(this)) {
                Crud.removeEditColumn(this);
                Crud.addEditColumn(this, event.getI18n());
            }
        });
    }

    private void setupFiltering() {
        HeaderRow filterRow = this.appendHeaderRow();
        this.getColumns().forEach(column -> {
            TextField field = new TextField();
            field.getElement().setAttribute("crud-role", "Search");
            field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                this.filter.getConstraints().remove(column.getKey());
                if (!field.isEmpty()) {
                    this.filter.getConstraints().put(column.getKey(), (String)event.getValue());
                }
                super.getDataProvider().refreshAll();
            });
            field.setValueChangeMode(ValueChangeMode.EAGER);
            ((HeaderRow.HeaderCell)filterRow.getCell(column)).setComponent((Component)field);
            field.setSizeFull();
            field.setPlaceholder("Filter");
        });
    }

    private void setupSorting() {
        this.setMultiSort(true);
        this.addSortListener((ComponentEventListener & Serializable)event -> {
            this.filter.getSortOrders().clear();
            event.getSortOrder().forEach(e -> this.filter.getSortOrders().put(e.getSorted().getKey(), e.getDirection()));
            super.getDataProvider().refreshAll();
        });
    }

    public CrudFilter getFilter() {
        return this.filter;
    }

    public DataProvider<E, ?> getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DataProvider<E, ?> dataProvider) throws IllegalArgumentException {
        try {
            ConfigurableFilterDataProvider provider = dataProvider.withConfigurableFilter();
            provider.setFilter((Object)this.filter);
            super.setDataProvider((DataProvider)provider);
            this.dataProvider = dataProvider;
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("DataProvider<" + this.beanType.getSimpleName() + ", CrudFilter> expected", ex);
        }
    }

    void addCrudThemeVariants(List<String> variantNames) {
        if (this.autogenerated) {
            this.getThemeNames().addAll(variantNames);
        }
    }

    void removeCrudThemeVariants(List<String> variantNames) {
        if (this.autogenerated) {
            this.getThemeNames().removeAll(variantNames);
        }
    }
}

