/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.customfield;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;

class FieldValidationUtil {
    private FieldValidationUtil() {
    }

    static <T> void disableClientValidation(CustomField<T> component) {
        if (!component.isAttached()) {
            throw new IllegalStateException(String.format("Component %s is not attached. Client side validation should be disabled when the component is attached, thus this method needs to be called from the onAttach method of the component.", new Object[]{component}));
        }
        component.getUI().ifPresent(ui -> ui.beforeClientResponse((Component)component, (SerializableConsumer & Serializable)executionContext -> FieldValidationUtil.overrideClientValidation(component)));
    }

    private static <T> void overrideClientValidation(CustomField<T> component) {
        StringBuilder expression = new StringBuilder("this.validate = function () {return this.checkValidity();};");
        if (component.isInvalid()) {
            expression.append("this.invalid = true;");
        }
        component.getElement().executeJs(expression.toString(), new Serializable[0]);
    }
}

