/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.datepicker.FieldValidationUtil;
import com.vaadin.flow.component.datepicker.GeneratedVaadinDatePicker;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

@JsModule(value="./datepickerConnector.js")
public class DatePicker
extends GeneratedVaadinDatePicker<DatePicker, LocalDate>
implements HasSize,
HasValidation,
HasHelper {
    private static final String PROP_AUTO_OPEN_DISABLED = "autoOpenDisabled";
    private DatePickerI18n i18n;
    private static final SerializableFunction<String, LocalDate> PARSER = (SerializableFunction & Serializable)s -> s == null || s.isEmpty() ? null : LocalDate.parse(s);
    private static final SerializableFunction<LocalDate, String> FORMATTER = (SerializableFunction & Serializable)d -> d == null ? "" : d.toString();
    private Locale locale;
    private String languageTag;
    private LocalDate max;
    private LocalDate min;
    private boolean required;

    public DatePicker() {
        this((LocalDate)null, true);
    }

    public DatePicker(LocalDate initialDate) {
        this(initialDate, false);
    }

    private DatePicker(LocalDate initialDate, boolean isInitialValueOptional) {
        super(initialDate, null, String.class, PARSER, FORMATTER, isInitialValueOptional);
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
    }

    public DatePicker(String label) {
        this();
        this.setLabel(label);
    }

    public DatePicker(String label, LocalDate initialDate) {
        this(initialDate);
        this.setLabel(label);
    }

    public DatePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public DatePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public DatePicker(LocalDate initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(initialDate);
        this.addValueChangeListener(listener);
    }

    public DatePicker(String label, LocalDate initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(initialDate);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    public DatePicker(LocalDate initialDate, Locale locale) {
        this(initialDate);
        this.setLocale(locale);
    }

    public void setMin(LocalDate min) {
        this.setMinAsString((String)FORMATTER.apply((Object)min));
        this.min = min;
    }

    public LocalDate getMin() {
        return (LocalDate)PARSER.apply((Object)this.getMinAsStringString());
    }

    public void setMax(LocalDate max) {
        this.setMaxAsString((String)FORMATTER.apply((Object)max));
        this.max = max;
    }

    public LocalDate getMax() {
        return (LocalDate)PARSER.apply((Object)this.getMaxAsStringString());
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        this.locale = locale;
        this.languageTag = !locale.toLanguageTag().contains("lvariant") ? locale.toLanguageTag() : (locale.getCountry().isEmpty() ? locale.getLanguage() : locale.getLanguage() + "-" + locale.getCountry());
        this.getUI().ifPresent(ui -> this.setLocaleWithJS());
    }

    private void setLocaleWithJS() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setLocale", new Serializable[]{this.languageTag}));
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        if (this.locale == null) {
            this.getUI().ifPresent(ui -> this.setLocale(ui.getLocale()));
        } else if (this.languageTag != null) {
            this.setLocaleWithJS();
        }
        if (this.i18n != null) {
            this.setI18nWithJS();
        }
        FieldValidationUtil.disableClientValidation(this);
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("window.Vaadin.Flow.datepickerConnector.initLazy($0)", new Serializable[]{this.getElement()}));
    }

    public DatePickerI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(DatePickerI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.getUI().ifPresent(ui -> this.setI18nWithJS());
    }

    private void setI18nWithJS() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
            for (String key : i18nObject.keys()) {
                if (i18nObject.get(key).getType() != JsonType.NULL) continue;
                i18nObject.remove(key);
            }
            this.getElement().executeJs("this.i18n = Object.assign({}, this.i18n, $0);", new Serializable[]{i18nObject});
        });
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            super.setErrorMessage("");
        } else {
            super.setErrorMessage(errorMessage);
        }
    }

    public String getErrorMessage() {
        return this.getErrorMessageString();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    private boolean isInvalid(LocalDate value) {
        boolean isRequiredButEmpty = this.required && Objects.equals(this.getEmptyValue(), value);
        boolean isGreaterThanMax = value != null && this.max != null && value.isAfter(this.max);
        boolean isSmallerThenMin = value != null && this.min != null && value.isBefore(this.min);
        return isRequiredButEmpty || isGreaterThanMax || isSmallerThenMin;
    }

    @Override
    public void setClearButtonVisible(boolean clearButtonVisible) {
        super.setClearButtonVisible(clearButtonVisible);
    }

    public boolean isClearButtonVisible() {
        return super.isClearButtonVisibleBoolean();
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    public void setInitialPosition(LocalDate initialPosition) {
        this.setInitialPosition((String)FORMATTER.apply((Object)initialPosition));
    }

    public LocalDate getInitialPosition() {
        return (LocalDate)PARSER.apply((Object)this.getInitialPositionString());
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
        this.required = required;
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
        this.required = required;
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        super.setShowWeekNumbers(weekNumbersVisible);
    }

    public boolean isWeekNumbersVisible() {
        return this.isShowWeekNumbersBoolean();
    }

    @Override
    public void setOpened(boolean opened) {
        super.setOpened(opened);
    }

    @Override
    public void open() {
        super.setOpened(true);
    }

    @Override
    protected void close() {
        super.setOpened(false);
    }

    public boolean isOpened() {
        return this.isOpenedBoolean();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public String getName() {
        return this.getNameString();
    }

    public void setAutoOpen(boolean autoOpen) {
        this.getElement().setProperty(PROP_AUTO_OPEN_DISABLED, !autoOpen);
    }

    public boolean isAutoOpen() {
        return !this.getElement().getProperty(PROP_AUTO_OPEN_DISABLED, false);
    }

    protected void validate() {
        this.setInvalid(this.isInvalid((LocalDate)this.getValue()));
    }

    @Override
    public Registration addOpenedChangeListener(ComponentEventListener<GeneratedVaadinDatePicker.OpenedChangeEvent<DatePicker>> listener) {
        return super.addOpenedChangeListener(listener);
    }

    @Override
    public Registration addInvalidChangeListener(ComponentEventListener<GeneratedVaadinDatePicker.InvalidChangeEvent<DatePicker>> listener) {
        return super.addInvalidChangeListener(listener);
    }

    public static class DatePickerI18n
    implements Serializable {
        private List<String> monthNames;
        private List<String> weekdays;
        private List<String> weekdaysShort;
        private int firstDayOfWeek;
        private String week;
        private String calendar;
        private String clear;
        private String today;
        private String cancel;

        public List<String> getMonthNames() {
            return this.monthNames;
        }

        public DatePickerI18n setMonthNames(List<String> monthNames) {
            this.monthNames = monthNames;
            return this;
        }

        public List<String> getWeekdays() {
            return this.weekdays;
        }

        public DatePickerI18n setWeekdays(List<String> weekdays) {
            this.weekdays = weekdays;
            return this;
        }

        public List<String> getWeekdaysShort() {
            return this.weekdaysShort;
        }

        public DatePickerI18n setWeekdaysShort(List<String> weekdaysShort) {
            this.weekdaysShort = weekdaysShort;
            return this;
        }

        public int getFirstDayOfWeek() {
            return this.firstDayOfWeek;
        }

        public DatePickerI18n setFirstDayOfWeek(int firstDayOfWeek) {
            this.firstDayOfWeek = firstDayOfWeek;
            return this;
        }

        public String getWeek() {
            return this.week;
        }

        public DatePickerI18n setWeek(String week) {
            this.week = week;
            return this;
        }

        public String getCalendar() {
            return this.calendar;
        }

        public DatePickerI18n setCalendar(String calendar) {
            this.calendar = calendar;
            return this;
        }

        public String getClear() {
            return this.clear;
        }

        public DatePickerI18n setClear(String clear) {
            this.clear = clear;
            return this;
        }

        public String getToday() {
            return this.today;
        }

        public DatePickerI18n setToday(String today) {
            this.today = today;
            return this;
        }

        public String getCancel() {
            return this.cancel;
        }

        public DatePickerI18n setCancel(String cancel) {
            this.cancel = cancel;
            return this;
        }
    }
}

