/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.stats;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.base.devserver.stats.JsonHelpers;
import com.vaadin.base.devserver.stats.StatisticsContainer;
import com.vaadin.base.devserver.stats.StatisticsStorage;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsSender {
    private static final String FAILED_TO_READ = "Failed to read ";
    private StatisticsStorage storage;

    public StatisticsSender(StatisticsStorage storage) {
        this.storage = storage;
    }

    public String getReportingUrl() {
        return "https://tools.vaadin.com/usage-stats/v2/submit";
    }

    String getLastServerMessage(ObjectNode json) {
        return json.has("serverMessage") ? json.get("serverMessage").asText() : null;
    }

    boolean isIntervalElapsed(ObjectNode json) {
        long interval;
        long now = System.currentTimeMillis();
        long lastSend = this.getLastSendTime(json);
        return lastSend + (interval = this.getInterval(json)) * 1000L < now;
    }

    long getInterval(ObjectNode json) {
        try {
            long interval = json.get("reportInterval").asLong();
            return StatisticsSender.normalizeInterval(interval);
        }
        catch (Exception e) {
            StatisticsSender.getLogger().debug("Failed to read reportInterval", (Throwable)e);
            return 86400L;
        }
    }

    private static long normalizeInterval(long intervalSec) {
        if (intervalSec < 43200L) {
            return 43200L;
        }
        return Math.min(intervalSec, 2592000L);
    }

    long getLastSendTime(ObjectNode json) {
        try {
            return json.get("lastSent").asLong();
        }
        catch (Exception e) {
            StatisticsSender.getLogger().debug("Failed to read lastSent", (Throwable)e);
            return -1L;
        }
    }

    String getLastSendStatus(ObjectNode json) {
        try {
            return json.get("lastSendStatus").asText();
        }
        catch (Exception e) {
            StatisticsSender.getLogger().debug("Failed to read lastSendStatus", (Throwable)e);
            return null;
        }
    }

    public void triggerSendIfNeeded(ObjectNode json) {
        if (this.isIntervalElapsed(json)) {
            CompletableFuture.runAsync(() -> {
                String message = this.sendStatistics(json);
                if (message != null && !message.trim().isEmpty()) {
                    DevModeUsageStatistics.getLogger().info(message);
                }
            });
        }
    }

    String sendStatistics(ObjectNode json) {
        String stringData;
        AtomicReference<Object> message = new AtomicReference<Object>(null);
        try {
            stringData = JsonHelpers.getJsonMapper().writeValueAsString((Object)json);
        }
        catch (JsonProcessingException e) {
            StatisticsSender.getLogger().debug("Error converting statistics to a string", (Throwable)e);
            return null;
        }
        ObjectNode response = StatisticsSender.postData(this.getReportingUrl(), stringData);
        if (response.isObject() && response.has("lastSendStatus")) {
            this.storage.update((arg_0, arg_1) -> StatisticsSender.lambda$sendStatistics$1((JsonNode)response, message, arg_0, arg_1));
            if (response.get("lastSendStatus").asText().startsWith("200:")) {
                this.storage.clearAllProjectData();
            }
        }
        return message.get();
    }

    private static ObjectNode postData(String postUrl, String data) {
        try {
            HttpPost post = new HttpPost(postUrl);
            post.addHeader("Content-Type", "application/json");
            post.setEntity((HttpEntity)new StringEntity(data));
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpResponse response = client.execute((HttpUriRequest)post);
            String responseStatus = response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase();
            JsonNode jsonResponse = null;
            if (response.getStatusLine().getStatusCode() == 200) {
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                jsonResponse = JsonHelpers.getJsonMapper().readTree(responseString);
            }
            ObjectNode result = jsonResponse != null && jsonResponse.isObject() ? (ObjectNode)jsonResponse : JsonHelpers.getJsonMapper().createObjectNode();
            result.put("lastSendStatus", responseStatus);
            return result;
        }
        catch (IOException e) {
            StatisticsSender.getLogger().debug("Failed to send statistics.", (Throwable)e);
            ObjectNode result = JsonHelpers.getJsonMapper().createObjectNode();
            result.put("lastSendStatus", "Invalid server response.");
            return result;
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(StatisticsSender.class);
    }

    private static /* synthetic */ void lambda$sendStatistics$1(JsonNode response, AtomicReference message, StatisticsContainer global, StatisticsContainer project) {
        global.setValue("lastSent", System.currentTimeMillis());
        global.setValue("lastSendStatus", response.get("lastSendStatus").asText());
        if (response.has("reportInterval") && response.get("reportInterval").isNumber()) {
            global.setValue("reportInterval", StatisticsSender.normalizeInterval(response.get("reportInterval").asLong()));
        } else {
            global.setValue("reportInterval", 86400L);
        }
        if (response.has("serverMessage") && response.get("serverMessage").isTextual()) {
            String msg = response.get("serverMessage").asText();
            global.setValue("serverMessage", msg);
            message.set(msg);
        }
    }
}

