/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.themeeditor;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBlockStmt;
import com.github.javaparser.ast.nodeTypes.NodeWithExpression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import com.github.javaparser.utils.SourceRoot;
import com.vaadin.base.devserver.editor.Editor;
import com.vaadin.base.devserver.editor.Where;
import com.vaadin.base.devserver.themeeditor.utils.LineNumberVisitor;
import com.vaadin.base.devserver.themeeditor.utils.LocalClassNameVisitor;
import com.vaadin.base.devserver.themeeditor.utils.LocalClassNamesVisitor;
import com.vaadin.base.devserver.themeeditor.utils.ThemeEditorException;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSourceModifier
extends Editor {
    public static final LineComment LOCAL_CLASSNAME_COMMENT = new LineComment("<theme-editor-local-classname>");
    private final VaadinContext context;

    public JavaSourceModifier(VaadinContext context) {
        this.context = context;
    }

    public void setLocalClassName(Integer uiId, Integer nodeId, String className) {
        assert (uiId != null && nodeId != null && className != null);
        VaadinSession session = this.getSession();
        this.getSession().access((Command & Serializable)() -> {
            Component component = this.getComponent(session, uiId, nodeId);
            this.setLocalClassName(component, className, false);
            if (this.hasOverlay(component)) {
                this.setLocalClassName(component, className, true);
            }
        });
    }

    protected void setLocalClassName(Component component, String className, boolean overlay) {
        try {
            ComponentTracker.Location createLocation = this.getCreateLocation(component);
            File sourceFile = this.getSourceFile(createLocation);
            int sourceOffset = this.modifyClass(sourceFile, cu -> {
                Editor.Modification mod;
                SimpleName scope = this.findLocalVariableOrField((CompilationUnit)cu, createLocation.lineNumber());
                Statement newNode = this.createAddClassNameStatement(scope, className, overlay);
                ExpressionStmt stmt = this.findLocalClassNameStmt((CompilationUnit)cu, component, overlay);
                if (stmt == null) {
                    Node node = this.findNode((CompilationUnit)cu, component);
                    Where where = this.findModificationWhere((CompilationUnit)cu, component);
                    mod = switch (where) {
                        default -> throw new IncompatibleClassChangeError();
                        case Where.AFTER -> Editor.Modification.insertLineAfter(node, (Node)newNode);
                        case Where.INSIDE -> Editor.Modification.insertAtEndOfBlock(node, (Node)newNode);
                        case Where.BEFORE -> Editor.Modification.insertLineBefore(node, (Node)newNode);
                    };
                } else {
                    mod = Editor.Modification.replace((Node)stmt, (Node)newNode);
                }
                return Collections.singletonList(mod);
            });
            if (sourceOffset != 0) {
                ComponentTracker.refreshLocation((ComponentTracker.Location)createLocation, (int)sourceOffset);
            }
        }
        catch (UnsupportedOperationException ex) {
            throw new ThemeEditorException(ex);
        }
    }

    public String getTag(Integer uiId, Integer nodeId) {
        assert (uiId != null && nodeId != null);
        try {
            FinalsHolder holder = new FinalsHolder();
            VaadinSession session = this.getSession();
            this.getSession().access((Command & Serializable)() -> {
                Component component = this.getComponent(session, uiId, nodeId);
                holder.tagName = component.getElement().getTag();
            }).get(5L, TimeUnit.SECONDS);
            return holder.tagName;
        }
        catch (Exception e) {
            throw new ThemeEditorException("Cannot get tag of component.", e);
        }
    }

    public String getLocalClassName(Integer uiId, Integer nodeId) {
        assert (uiId != null && nodeId != null);
        try {
            FinalsHolder holder = new FinalsHolder();
            VaadinSession session = this.getSession();
            this.getSession().access((Command & Serializable)() -> {
                Component component = this.getComponent(session, uiId, nodeId);
                CompilationUnit cu = this.getCompilationUnit(component);
                ExpressionStmt localClassNameStmt = this.findLocalClassNameStmt(cu, component, false);
                if (localClassNameStmt != null) {
                    holder.className = localClassNameStmt.getExpression().asMethodCallExpr().getArgument(0).asStringLiteralExpr().asString();
                }
            }).get(5L, TimeUnit.SECONDS);
            return holder.className;
        }
        catch (Exception e) {
            throw new ThemeEditorException("Cannot get local classname.", e);
        }
    }

    public void removeLocalClassName(Integer uiId, Integer nodeId) {
        assert (uiId != null && nodeId != null);
        VaadinSession session = this.getSession();
        try {
            this.getSession().access((Command & Serializable)() -> {
                Component component = this.getComponent(session, uiId, nodeId);
                this.removeLocalClassName(component, false);
                if (this.hasOverlay(component)) {
                    this.removeLocalClassName(component, true);
                }
            }).get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new ThemeEditorException("Cannot remove local classname.", e);
        }
    }

    public void removeLocalClassName(Component component, boolean overlay) {
        ComponentTracker.Location createLocation = this.getCreateLocation(component);
        File sourceFile = this.getSourceFile(createLocation);
        int sourceOffset = this.modifyClass(sourceFile, cu -> {
            ExpressionStmt localClassNameStmt = this.findLocalClassNameStmt((CompilationUnit)cu, component, overlay);
            if (localClassNameStmt != null) {
                return Collections.singletonList(Editor.Modification.remove((Node)localClassNameStmt));
            }
            throw new ThemeEditorException("Local classname not present.");
        });
        if (sourceOffset != 0) {
            ComponentTracker.refreshLocation((ComponentTracker.Location)createLocation, (int)sourceOffset);
        }
    }

    public boolean isAccessible(Integer uiId, Integer nodeId) {
        assert (uiId != null && nodeId != null);
        FinalsHolder holder = new FinalsHolder();
        try {
            VaadinSession session = this.getSession();
            this.getSession().access((Command & Serializable)() -> {
                try {
                    Component component = this.getComponent(session, uiId, nodeId);
                    CompilationUnit cu = this.getCompilationUnit(component);
                    this.findModificationWhere(cu, component);
                    holder.accessible = true;
                }
                catch (Exception ex) {
                    JavaSourceModifier.getLogger().warn(ex.getMessage(), (Throwable)ex);
                    holder.accessible = false;
                }
            }).get(5L, TimeUnit.SECONDS);
            return holder.accessible;
        }
        catch (Exception e) {
            throw new ThemeEditorException("Cannot generate metadata.", e);
        }
    }

    public String getSuggestedClassName(Integer uiId, Integer nodeId) {
        assert (uiId != null && nodeId != null);
        FinalsHolder holder = new FinalsHolder();
        try {
            VaadinSession session = this.getSession();
            this.getSession().access((Command & Serializable)() -> {
                Component component = this.getComponent(session, uiId, nodeId);
                ComponentTracker.Location createLocation = this.getCreateLocation(component);
                String fileName = SharedUtil.upperCamelCaseToDashSeparatedLowerCase((String)createLocation.filename().substring(0, createLocation.filename().indexOf(".")));
                String tagName = component.getElement().getTag().replace("vaadin-", "");
                CompilationUnit cu = this.getCompilationUnit(component);
                LocalClassNamesVisitor visitor = new LocalClassNamesVisitor();
                cu.accept((GenericVisitor)visitor, null);
                List<String> existingClassNames = visitor.getArguments();
                String suggestion = fileName + "-" + tagName + "-";
                holder.suggestedClassName = IntStream.range(1, 100).mapToObj(i -> suggestion + i).filter(i -> !existingClassNames.contains(i)).findFirst().orElse(null);
            }).get(5L, TimeUnit.SECONDS);
            return holder.suggestedClassName;
        }
        catch (Exception e) {
            throw new ThemeEditorException("Cannot generate metadata.", e);
        }
    }

    protected ComponentTracker.Location getCreateLocation(Component c) {
        ComponentTracker.Location location = ComponentTracker.findCreate((Component)c);
        if (location == null) {
            throw new ThemeEditorException("Unable to find the location where the component " + c.getClass().getName() + " was created");
        }
        return location;
    }

    protected VaadinSession getSession() {
        return VaadinSession.getCurrent();
    }

    protected File getSourceFolder(ComponentTracker.Location location) {
        Path javaSourceFolder = ApplicationConfiguration.get((VaadinContext)this.context).getJavaSourceFolder().toPath();
        String[] splitted = location.className().split("\\.");
        return Path.of(javaSourceFolder.toString(), Arrays.copyOf(splitted, splitted.length - 1)).toFile();
    }

    protected Statement createAddClassNameStatement(SimpleName scope, String className, boolean overlay) {
        MethodCallExpr methodCallExpr = new MethodCallExpr(overlay ? "setOverlayClassName" : "addClassName", new Expression[0]);
        if (scope != null) {
            methodCallExpr.setScope((Expression)new NameExpr(scope));
        }
        methodCallExpr.getArguments().add((Node)new StringLiteralExpr(className));
        ExpressionStmt statement = new ExpressionStmt((Expression)methodCallExpr);
        statement.setComment((Comment)LOCAL_CLASSNAME_COMMENT);
        return statement;
    }

    protected File getSourceFile(ComponentTracker.Location createLocation) {
        File sourceFolder = this.getSourceFolder(createLocation);
        return new File(sourceFolder, createLocation.filename());
    }

    protected Component getComponent(VaadinSession session, int uiId, int nodeId) {
        Element element = session.findElement(uiId, nodeId);
        Optional c = element.getComponent();
        if (c.isEmpty()) {
            throw new ThemeEditorException("Only component locations are tracked. The given node id refers to an element and not a component.");
        }
        return (Component)c.get();
    }

    protected CompilationUnit getCompilationUnit(Component component) {
        ComponentTracker.Location createLocation = this.getCreateLocation(component);
        File sourceFolder = this.getSourceFolder(createLocation);
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        parserConfiguration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
        SourceRoot root = new SourceRoot(sourceFolder.toPath(), parserConfiguration);
        return (CompilationUnit)LexicalPreservingPrinter.setup((Node)root.parse("", createLocation.filename()));
    }

    protected ExpressionStmt findLocalClassNameStmt(CompilationUnit cu, Component component, boolean overlay) {
        ComponentTracker.Location createLocation = this.getCreateLocation(component);
        SimpleName scope = this.findLocalVariableOrField(cu, createLocation.lineNumber());
        Node parentBlockNode = this.findParentBlockNode(cu, component);
        return (ExpressionStmt)parentBlockNode.accept((GenericVisitor)new LocalClassNameVisitor(overlay), (Object)(scope != null ? scope.getIdentifier() : null));
    }

    protected Node findParentBlockNode(CompilationUnit cu, Component component) {
        ComponentTracker.Location createLocation = this.getCreateLocation(component);
        Node node = (Node)cu.accept((GenericVisitor)new LineNumberVisitor(), (Object)createLocation.lineNumber());
        if (node instanceof BlockStmt) {
            return node;
        }
        while (node.getParentNode().isPresent()) {
            if (!((node = (Node)node.getParentNode().get()) instanceof BlockStmt)) continue;
            BlockStmt blockStmt = (BlockStmt)node;
            return blockStmt;
        }
        return cu;
    }

    protected Where findModificationWhere(CompilationUnit cu, Component component) {
        NodeWithExpression expr;
        Node node = this.findNode(cu, component);
        if (node instanceof NodeWithBlockStmt) {
            return Where.INSIDE;
        }
        if (node instanceof NodeWithExpression && ((expr = (NodeWithExpression)node).getExpression().isAssignExpr() || expr.getExpression().isVariableDeclarationExpr())) {
            return Where.AFTER;
        }
        throw new ThemeEditorException("Cannot apply classname for " + node);
    }

    protected Node findNode(CompilationUnit cu, Component component) {
        ComponentTracker.Location createLocation = this.getCreateLocation(component);
        Node node = (Node)cu.accept((GenericVisitor)new LineNumberVisitor(), (Object)createLocation.lineNumber());
        if (node == null) {
            throw new ThemeEditorException("Cannot find component.");
        }
        return node;
    }

    protected boolean hasOverlay(Component component) {
        try {
            component.getClass().getMethod("setOverlayClassName", String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(JavaSourceModifier.class);
    }

    private static class FinalsHolder {
        boolean accessible;
        String className;
        String suggestedClassName;
        String tagName;

        private FinalsHolder() {
        }
    }
}

