/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.server.Platform;
import com.vaadin.flow.server.Version;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ServerInfo
implements Serializable {
    private List<NameAndVersion> versions = new ArrayList<NameAndVersion>();

    public ServerInfo() {
        if (EndpointRequestUtil.isHillaAvailable()) {
            this.versions.add(new NameAndVersion("Hilla", ServerInfo.fetchHillaVersion()));
        }
        this.versions.add(new NameAndVersion("Flow", Version.getFullVersion()));
        if (ServerInfo.isVaadinAvailable()) {
            this.versions.add(new NameAndVersion("Vaadin", ServerInfo.fetchVaadinVersion()));
        }
        this.versions.add(new NameAndVersion("Java", ServerInfo.fetchJavaVersion()));
        this.versions.add(new NameAndVersion("OS", ServerInfo.fetchOperatingSystem()));
    }

    public static String fetchJavaVersion() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        return vendor + " " + version;
    }

    public static String fetchOperatingSystem() {
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        return arch + " " + name + " " + version;
    }

    public static String fetchVaadinVersion() {
        return ServerInfo.isVaadinAvailable() ? Platform.getVaadinVersion().orElse("?") : "-";
    }

    public static String fetchHillaVersion() {
        return EndpointRequestUtil.isHillaAvailable() ? Platform.getHillaVersion().orElse("?") : "-";
    }

    public List<NameAndVersion> getVersions() {
        return this.versions;
    }

    private static boolean isVaadinAvailable() {
        return Thread.currentThread().getContextClassLoader().getResource("META-INF/maven/com.vaadin/vaadin-core/pom.properties") != null;
    }

    public record NameAndVersion(String name, String version) implements Serializable
    {
    }
}

