/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.grid.Grid;
import java.util.Objects;
import java.util.Optional;

@DomEvent(value="grid-cell-focus")
public class CellFocusEvent<T>
extends ComponentEvent<Grid<T>> {
    private final transient T item;
    private final Grid.Column<T> column;
    private final GridSection section;

    public CellFocusEvent(Grid<T> source, boolean fromClient, @EventData(value="event.detail.itemKey") String itemKey, @EventData(value="event.detail.internalColumnId") String internalColumnId, @EventData(value="event.detail.section") String sectionName) {
        super(source, fromClient);
        this.item = source.getDataCommunicator().getKeyMapper().get(itemKey);
        this.column = source.getColumnByInternalId(internalColumnId);
        this.section = GridSection.ofClientSideName(sectionName);
    }

    public boolean isBodyCell() {
        return this.section == GridSection.BODY;
    }

    public boolean isHeaderCell() {
        return this.section == GridSection.HEADER;
    }

    public boolean isFooterCell() {
        return this.section == GridSection.FOOTER;
    }

    public GridSection getSection() {
        return this.section;
    }

    public Optional<T> getItem() {
        return Optional.ofNullable(this.item);
    }

    public Optional<Grid.Column<T>> getColumn() {
        return Optional.ofNullable(this.column);
    }

    public static enum GridSection {
        HEADER("header"),
        BODY("body"),
        FOOTER("footer");

        private final String clientSideName;

        private GridSection(String clientSideName) {
            this.clientSideName = clientSideName;
        }

        public static GridSection ofClientSideName(String clientSideName) {
            for (GridSection section : GridSection.values()) {
                if (!Objects.equals(clientSideName, section.getClientSideName())) continue;
                return section;
            }
            throw new IllegalArgumentException("Unknown section client side section name: " + clientSideName);
        }

        public String getClientSideName() {
            return this.clientSideName;
        }
    }
}

