/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.theme.lumo;

import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.theme.AbstractTheme;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

@NpmPackage.Container(value={@NpmPackage(value="@vaadin/vaadin-themable-mixin", version="24.5.9"), @NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.5.9"), @NpmPackage(value="@vaadin/vaadin-lumo-styles", version="24.5.9")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/color-global.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/typography-global.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/sizing.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/spacing.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/style.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/vaadin-iconset.js")})
public class Lumo
implements AbstractTheme {
    public static final String LIGHT = "light";
    public static final String DARK = "dark";

    public String getBaseUrl() {
        return "src/";
    }

    public String getThemeUrl() {
        return "theme/lumo/";
    }

    public Map<String, String> getHtmlAttributes(String variant) {
        if (variant.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        switch (variant) {
            case "light": {
                attributes.put("theme", LIGHT);
                break;
            }
            case "dark": {
                attributes.put("theme", DARK);
                break;
            }
            default: {
                LoggerFactory.getLogger((String)Lumo.class.getName()).warn("Lumo theme variant not recognized: '{}'. Using no variant.", (Object)variant);
            }
        }
        return attributes;
    }
}

