/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.events;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.map.Map;
import com.vaadin.flow.component.map.configuration.Feature;
import com.vaadin.flow.component.map.configuration.layer.VectorLayer;
import com.vaadin.flow.component.map.configuration.source.VectorSource;
import com.vaadin.flow.component.map.events.FeatureEventDetails;
import com.vaadin.flow.component.map.events.MapEventUtil;
import com.vaadin.flow.component.map.events.MouseEventDetails;

@DomEvent(value="map-feature-click")
public class MapFeatureClickEvent
extends ComponentEvent<Map> {
    private final Feature feature;
    private final VectorLayer layer;
    private final VectorSource vectorSource;
    private final MouseEventDetails details;

    public MapFeatureClickEvent(Map source, boolean fromClient, @EventData(value="event.detail.feature.id") String featureId, @EventData(value="event.detail.layer.id") String layerId, @EventData(value="event.detail.originalEvent.pageX") int pageX, @EventData(value="event.detail.originalEvent.pageY") int pageY, @EventData(value="event.detail.originalEvent.altKey") boolean altKey, @EventData(value="event.detail.originalEvent.ctrlKey") boolean ctrlKey, @EventData(value="event.detail.originalEvent.metaKey") boolean metaKey, @EventData(value="event.detail.originalEvent.shiftKey") boolean shiftKey, @EventData(value="event.detail.originalEvent.button") int button) {
        super((Component)source, fromClient);
        FeatureEventDetails featureEventDetails = MapEventUtil.getFeatureEventDetails(source.getRawConfiguration(), layerId, featureId);
        this.layer = featureEventDetails.getLayer();
        this.vectorSource = featureEventDetails.getSource();
        this.feature = featureEventDetails.getFeature();
        this.details = new MouseEventDetails();
        this.details.setAbsoluteX(pageX);
        this.details.setAbsoluteY(pageY);
        this.details.setButton(MouseEventDetails.MouseButton.of(button));
        this.details.setAltKey(altKey);
        this.details.setCtrlKey(ctrlKey);
        this.details.setMetaKey(metaKey);
        this.details.setShiftKey(shiftKey);
    }

    public Feature getFeature() {
        return this.feature;
    }

    public VectorLayer getLayer() {
        return this.layer;
    }

    public VectorSource getVectorSource() {
        return this.vectorSource;
    }

    public MouseEventDetails getMouseDetails() {
        return this.details;
    }
}

