/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.maven;

import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.hilla.engine.BrowserCallableFinderException;
import com.vaadin.hilla.engine.EngineAutoConfiguration;
import com.vaadin.hilla.engine.GeneratorException;
import com.vaadin.hilla.engine.GeneratorProcessor;
import com.vaadin.hilla.engine.ParserException;
import com.vaadin.hilla.engine.ParserProcessor;
import com.vaadin.hilla.maven.Configurable;
import com.vaadin.hilla.maven.EngineGenerateMojoException;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class EngineGenerateMojo
extends AbstractMojo
implements Configurable {
    @Parameter(property="frontendDirectory", defaultValue="${project.basedir}/src/main/frontend/")
    private File frontend;
    @Parameter(property="generatedTsFolder")
    private File generated;
    @Parameter(property="nodeCommand", defaultValue="node")
    private String node;
    @Parameter(property="mainClass")
    private String mainClass;

    public void execute() throws EngineGenerateMojoException {
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        if (!FlowModeAbstractMojo.isHillaAvailable((MavenProject)project)) {
            this.getLog().warn((CharSequence)"The 'generate' goal is only meant to be used in Hilla projects with endpoints.\n".stripIndent());
            return;
        }
        try {
            EngineAutoConfiguration conf = this.configure();
            ParserProcessor parserProcessor = new ParserProcessor(conf);
            GeneratorProcessor generatorProcessor = new GeneratorProcessor(conf);
            List browserCallables = conf.getBrowserCallableFinder().find(conf);
            parserProcessor.process(browserCallables);
            generatorProcessor.process();
        }
        catch (BrowserCallableFinderException | GeneratorException | ParserException e) {
            throw new EngineGenerateMojoException("Execution failed", e);
        }
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Override
    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public File getFrontend() {
        return this.frontend;
    }

    @Override
    public File getGenerated() {
        return this.generated;
    }
}

