/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.orderedlayout;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import java.util.Arrays;

@Tag(value="div")
public class FlexLayout
extends Component
implements FlexComponent,
ClickNotifier<FlexLayout> {
    public FlexLayout() {
        this.getStyle().set("display", "flex");
    }

    public FlexLayout(Component ... children) {
        this();
        this.add(children);
    }

    public void setFlexWrap(FlexWrap flexWrap) {
        if (flexWrap == null) {
            throw new IllegalArgumentException("The 'flexWrap' argument can not be null");
        }
        this.getElement().getStyle().set("flexWrap", flexWrap.getFlexValue());
    }

    public FlexWrap getFlexWrap() {
        return FlexWrap.toFlexWrap(this.getElement().getStyle().get("flexWrap"), FlexWrap.NOWRAP);
    }

    public void setAlignContent(ContentAlignment alignment) {
        if (alignment == null) {
            this.getStyle().remove("alignContent");
        } else {
            this.getStyle().set("alignContent", alignment.getFlexValue());
        }
    }

    public ContentAlignment getAlignContent() {
        return ContentAlignment.toAlignment(this.getElement().getStyle().get("alignContent"), ContentAlignment.STRETCH);
    }

    public void setFlexBasis(String width, HasElement ... components) {
        if (width == null) {
            for (HasElement element : components) {
                element.getElement().getStyle().remove("flexBasis");
            }
        } else {
            for (HasElement element : components) {
                element.getElement().getStyle().set("flexBasis", width);
            }
        }
    }

    public String getFlexBasis(HasElement component) {
        return component.getElement().getStyle().get("flexBasis");
    }

    public void setFlexDirection(FlexDirection flexDirection) {
        if (flexDirection == null) {
            this.getElement().getStyle().remove("flexDirection");
        } else {
            this.getElement().getStyle().set("flexDirection", flexDirection.getDirectionValue());
        }
    }

    public FlexDirection getFlexDirection() {
        return FlexDirection.toFlexDirection(this.getElement().getStyle().get("flexDirection"), FlexDirection.ROW);
    }

    public void setOrder(int order, HasElement component) {
        if (order == 0) {
            component.getElement().getStyle().remove("order");
        }
        component.getElement().getStyle().set("order", String.valueOf(order));
    }

    public int getOrder(HasElement component) {
        String order = component.getElement().getStyle().get("order");
        if (order == null || order.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(order);
        }
        catch (Exception e) {
            throw new IllegalStateException("The order property of the component is not parseable to integer: " + order, e);
        }
    }

    public static enum FlexWrap {
        NOWRAP("nowrap"),
        WRAP("wrap"),
        WRAP_REVERSE("wrap-reverse");

        private final String flexValue;

        private FlexWrap(String flexValue) {
            this.flexValue = flexValue;
        }

        String getFlexValue() {
            return this.flexValue;
        }

        static FlexWrap toFlexWrap(String flexValue, FlexWrap defaultValue) {
            return Arrays.stream(FlexWrap.values()).filter(flexWrap -> flexWrap.getFlexValue().equals(flexValue)).findFirst().orElse(defaultValue);
        }
    }

    public static enum ContentAlignment {
        START("flex-start"),
        END("flex-end"),
        CENTER("center"),
        STRETCH("stretch"),
        SPACE_BETWEEN("space-between"),
        SPACE_AROUND("space-around");

        private final String flexValue;

        private ContentAlignment(String flexValue) {
            this.flexValue = flexValue;
        }

        String getFlexValue() {
            return this.flexValue;
        }

        static ContentAlignment toAlignment(String flexValue, ContentAlignment defaultValue) {
            return Arrays.stream(ContentAlignment.values()).filter(alignment -> alignment.getFlexValue().equals(flexValue)).findFirst().orElse(defaultValue);
        }
    }

    public static enum FlexDirection {
        ROW("row"),
        ROW_REVERSE("row-reverse"),
        COLUMN("column"),
        COLUMN_REVERSE("column-reverse");

        private final String directionValue;

        private FlexDirection(String directionValue) {
            this.directionValue = directionValue;
        }

        String getDirectionValue() {
            return this.directionValue;
        }

        static FlexDirection toFlexDirection(String flexValue, FlexDirection defaultValue) {
            return Arrays.stream(FlexDirection.values()).filter(flexDirection -> flexDirection.getDirectionValue().equals(flexValue)).findFirst().orElse(defaultValue);
        }
    }
}

