/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.radiobutton;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.radiobutton.GeneratedVaadinRadioGroup;
import com.vaadin.flow.component.radiobutton.RadioButton;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.binder.HasItemsAndComponents;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.dom.PropertyChangeEvent;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@NpmPackage(value="@vaadin/vaadin-radio-button", version="1.2.4")
public class RadioButtonGroup<T>
extends GeneratedVaadinRadioGroup<RadioButtonGroup<T>, T>
implements HasItemsAndComponents<T>,
SingleSelect<RadioButtonGroup<T>, T>,
HasDataProvider<T>,
HasValidation {
    private final KeyMapper<T> keyMapper = new KeyMapper();
    private DataProvider<T, ?> dataProvider = DataProvider.ofItems((Object[])new Object[0]);
    private SerializablePredicate<T> itemEnabledProvider = (SerializablePredicate & Serializable)item -> this.isEnabled();
    private ComponentRenderer<? extends Component, T> itemRenderer = new TextRenderer();
    private boolean isReadOnly;
    private final PropertyChangeListener validationListener = this::validateSelectionEnabledState;
    private Registration validationRegistration;
    private Registration dataProviderListenerRegistration;

    private static <T> T presentationToModel(RadioButtonGroup<T> radioButtonGroup, String presentation) {
        if (!radioButtonGroup.keyMapper.containsKey(presentation)) {
            return null;
        }
        return (T)radioButtonGroup.keyMapper.get(presentation);
    }

    private static <T> String modelToPresentation(RadioButtonGroup<T> radioButtonGroup, T model) {
        if (!radioButtonGroup.keyMapper.has(model)) {
            return null;
        }
        return radioButtonGroup.keyMapper.key(model);
    }

    public RadioButtonGroup() {
        super(null, null, String.class, RadioButtonGroup::presentationToModel, RadioButtonGroup::modelToPresentation);
        this.registerValidation();
    }

    protected boolean hasValidValue() {
        String selectedKey = this.getElement().getProperty("value");
        return this.itemEnabledProvider.test(this.keyMapper.get(selectedKey));
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider = dataProvider;
        this.reset();
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> {
            if (event instanceof DataChangeEvent.DataRefreshEvent) {
                this.resetRadioButton(((DataChangeEvent.DataRefreshEvent)event).getItem());
            } else {
                this.reset();
            }
        });
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider;
    }

    public SerializablePredicate<T> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    public void setItemEnabledProvider(SerializablePredicate<T> itemEnabledProvider) {
        this.itemEnabledProvider = Objects.requireNonNull(itemEnabledProvider);
        this.refreshButtons();
    }

    public ComponentRenderer<? extends Component, T> getItemRenderer() {
        return this.itemRenderer;
    }

    public void setRenderer(ComponentRenderer<? extends Component, T> renderer) {
        this.itemRenderer = Objects.requireNonNull(renderer);
        this.refreshButtons();
    }

    public void onEnabledStateChanged(boolean enabled) {
        if (this.isReadOnly()) {
            this.setDisabled(true);
        } else {
            this.setDisabled(!enabled);
        }
        this.refreshButtons();
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        if (this.isEnabled()) {
            this.setDisabled(readOnly);
            this.refreshButtons();
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    public boolean isRequired() {
        return super.isRequiredBoolean();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return super.getLabelString();
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    private void reset() {
        this.keyMapper.removeAll();
        this.removeAll();
        this.clear();
        this.getDataProvider().fetch(new Query()).map(this::createRadioButton).forEach(xva$0 -> this.add(new Component[]{xva$0}));
    }

    private void resetRadioButton(T item) {
        this.getRadioButtons().filter(radioButton -> this.getDataProvider().getId(radioButton.getItem()).equals(this.getDataProvider().getId(item))).findFirst().ifPresent(this::updateButton);
    }

    private Component createRadioButton(T item) {
        RadioButton<T> button = new RadioButton<T>(this.keyMapper.key(item), item);
        this.updateButton(button);
        return button;
    }

    private void refreshButtons() {
        this.getRadioButtons().forEach(this::updateButton);
    }

    private Stream<RadioButton<T>> getRadioButtons() {
        return this.getChildren().filter(RadioButton.class::isInstance).map(child -> (RadioButton)((Object)child));
    }

    private void updateButton(RadioButton<T> button) {
        this.updateEnabled(button);
        button.removeAll();
        button.add(new Component[]{this.getItemRenderer().createComponent(button.getItem())});
    }

    private void validateSelectionEnabledState(PropertyChangeEvent event) {
        if (!this.hasValidValue()) {
            T oldValue = this.getValue(event.getOldValue());
            try {
                this.validationRegistration.remove();
                this.getElement().setProperty("value", this.keyMapper.key(oldValue));
            }
            finally {
                this.registerValidation();
            }
            Optional<RadioButton> selectedButton = this.getRadioButtons().filter(button -> button.getItem() == this.getValue(event.getValue())).findFirst();
            selectedButton.ifPresent(this::updateEnabled);
        }
    }

    private void updateEnabled(RadioButton<T> button) {
        boolean disabled = this.isDisabledBoolean() || !this.getItemEnabledProvider().test(button.getItem());
        Serializable rawValue = button.getElement().getPropertyRaw("disabled");
        if (rawValue instanceof Boolean) {
            button.getElement().setProperty("disabled", disabled ? Boolean.TRUE.toString() : null);
        } else {
            button.setDisabled(disabled);
        }
    }

    private T getValue(Serializable key) {
        if (key == null) {
            return null;
        }
        return (T)this.keyMapper.get(key.toString());
    }

    private void registerValidation() {
        if (this.validationRegistration != null) {
            this.validationRegistration.remove();
        }
        this.validationRegistration = this.getElement().addPropertyChangeListener("value", this.validationListener);
    }
}

