/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.select.testbench;

import com.vaadin.testbench.HasHelper;
import com.vaadin.testbench.HasLabel;
import com.vaadin.testbench.HasPlaceholder;
import com.vaadin.testbench.HasSelectByText;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Element(value="vaadin-select")
public class SelectElement
extends TestBenchElement
implements HasSelectByText,
HasLabel,
HasPlaceholder,
HasHelper {
    public void openPopup() {
        this.setProperty("opened", true);
    }

    public void closePopup() {
        this.setProperty("opened", false);
    }

    public boolean isOpened() {
        return this.getPropertyBoolean(new String[]{"opened"});
    }

    public void selectItemByIndex(int index) {
        this.openPopup();
        this.getItems().get(index).click();
    }

    public Stream<ItemElement> getItemsStream() {
        this.openPopup();
        List elements = this.getPropertyElement(new String[]{"_overlayElement"}).findElement(By.tagName((String)"vaadin-select-list-box")).findElements(By.tagName((String)"vaadin-select-item"));
        if (elements.size() == 0) {
            return Stream.builder().build();
        }
        return elements.stream().map(item -> new ItemElement((WebElement)item, this.getCommandExecutor()));
    }

    public List<ItemElement> getItems() {
        return this.getItemsStream().collect(Collectors.toList());
    }

    public void selectByText(String text) {
        this.getItemsStream().filter(item -> text.equals(item.getPropertyString(new String[]{"textContent"}).trim())).findFirst().get().click();
    }

    public String getSelectedText() {
        return this.getSelectedItem().getText();
    }

    public ItemElement getSelectedOptionItem() {
        return this.getItemsStream().filter(element -> element.hasAttribute("selected")).findAny().orElseThrow(() -> new NoSuchElementException("No item selected from popup"));
    }

    public ItemElement getSelectedItem() {
        TestBenchElement valueElement = this.$("vaadin-select-value-button").first();
        return (ItemElement)valueElement.$(ItemElement.class).first();
    }

    @Element(value="vaadin-select-item")
    public static class ItemElement
    extends TestBenchElement {
        public ItemElement() {
        }

        ItemElement(WebElement item, TestBenchCommandExecutor commandExecutor) {
            super(item, commandExecutor);
        }
    }
}

