/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.spreadsheet.SheetOverlayWrapper;
import java.io.Serializable;

class MinimizableComponentContainer
extends Div {
    private Component content;
    private final Button minimizeButton;
    private SheetOverlayWrapper.OverlayChangeListener listener;

    public MinimizableComponentContainer(Component comp) {
        this.content = comp;
        this.minimizeButton = this.createMinimizeButton();
        this.add(new Component[]{this.minimizeButton, this.content});
    }

    public MinimizableComponentContainer() {
        this.minimizeButton = this.createMinimizeButton();
        this.add(new Component[]{this.minimizeButton});
    }

    private Button createMinimizeButton() {
        Button minimizeButton = new Button((Component)new Icon(VaadinIcon.MINUS));
        minimizeButton.addClassName("minimize-button");
        minimizeButton.addClickListener((ComponentEventListener & Serializable)event -> {
            this.content.setVisible(!this.content.isVisible());
            if (this.content.isVisible()) {
                minimizeButton.setIcon((Component)new Icon(VaadinIcon.MINUS));
            } else {
                minimizeButton.setIcon((Component)new Icon(VaadinIcon.PLUS));
            }
            this.fireMinimizeEvent();
        });
        return minimizeButton;
    }

    public boolean isMinimized() {
        return !this.content.isVisible();
    }

    public void setMinimizeListener(SheetOverlayWrapper.OverlayChangeListener listener) {
        this.listener = listener;
    }

    public void fireMinimizeEvent() {
        this.listener.overlayChanged();
    }

    public void setContent(Component newContent) {
        if (this.content != null) {
            this.removeAll();
            this.add(new Component[]{newContent});
        } else {
            this.add(new Component[]{newContent});
        }
        this.content = newContent;
    }

    public Component getContent() {
        return this.content;
    }
}

