/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.server.AmbiguousRouteConfigurationException;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.DeploymentConfigurationFactory;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinConfig;
import com.vaadin.flow.server.VaadinConfigurationException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletConfig;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.AbstractRouteRegistryInitializer;
import com.vaadin.flow.server.startup.AnnotationValidator;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.flow.server.startup.DevModeInitializer;
import com.vaadin.flow.server.startup.ServletVerifier;
import com.vaadin.flow.server.startup.VaadinAppShellInitializer;
import com.vaadin.flow.server.startup.WebComponentConfigurationRegistryInitializer;
import com.vaadin.flow.server.startup.WebComponentExporterAwareValidator;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import com.vaadin.flow.spring.SpringServlet;
import com.vaadin.flow.spring.VaadinScanPackagesRegistrar;
import com.vaadin.flow.theme.Theme;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;

public class VaadinServletContextInitializer
implements ServletContextInitializer {
    private ApplicationContext appContext;
    private ResourceLoader customLoader;
    private static final List<String> DEFAULT_WHITE_LISTED = Stream.of(Component.class.getPackage().getName(), Theme.class.getPackage().getName(), "com.vaadin.shrinkwrap").collect(Collectors.toList());
    private List<String> customWhitelist;

    public VaadinServletContextInitializer(ApplicationContext context) {
        this.appContext = context;
        String blacklistProperty = this.appContext.getEnvironment().getProperty("vaadin.blacklisted-packages");
        List<String> blacklist = blacklistProperty == null ? Collections.emptyList() : Arrays.stream(blacklistProperty.split(",")).map(String::trim).collect(Collectors.toList());
        String whitelistProperty = this.appContext.getEnvironment().getProperty("vaadin.whitelisted-packages");
        if (whitelistProperty == null) {
            this.customWhitelist = Collections.emptyList();
            this.customLoader = new CustomResourceLoader((ResourceLoader)this.appContext, blacklist);
        } else {
            this.customWhitelist = Arrays.stream(whitelistProperty.split(",")).map(whitelistedPackage -> whitelistedPackage.replace('/', '.').trim()).collect(Collectors.toList());
            this.customLoader = this.appContext;
        }
        if (!this.customWhitelist.isEmpty() && !blacklist.isEmpty()) {
            VaadinServletContextInitializer.getLogger().warn("vaadin.blacklisted-packages is ignored because both vaadin.whitelisted-packages and vaadin.blacklisted-packages have been set.");
        }
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        ServletVerifier.verifyServletVersion();
        servletContext.addListener((EventListener)((Object)new VaadinAppShellContextListener()));
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)new VaadinServletContext(servletContext));
        if (registry.getRegisteredRoutes().isEmpty()) {
            servletContext.addListener((EventListener)((Object)new RouteServletContextListener()));
        }
        servletContext.addListener((EventListener)((Object)new ErrorParameterServletContextListener()));
        servletContext.addListener((EventListener)((Object)new AnnotationValidatorServletContextListener()));
        servletContext.addListener((EventListener)((Object)new DevModeServletContextListener()));
        if (!WebComponentConfigurationRegistry.getInstance((VaadinContext)new VaadinServletContext(servletContext)).hasConfigurations()) {
            servletContext.addListener((EventListener)((Object)new WebComponentServletContextListener()));
        }
    }

    private Stream<Class<?>> findByAnnotation(Collection<String> packages, Class<? extends Annotation> ... annotations) {
        return this.findByAnnotation(packages, (ResourceLoader)this.appContext, annotations);
    }

    private Stream<Class<?>> findByAnnotation(Collection<String> packages, ResourceLoader loader, Class<? extends Annotation> ... annotations) {
        return this.findByAnnotationOrSuperType(packages, loader, Arrays.asList(annotations), Collections.emptySet());
    }

    private Stream<Class<?>> findBySuperType(Collection<String> packages, Class<?> type) {
        return this.findBySuperType(packages, (ResourceLoader)this.appContext, type);
    }

    private Stream<Class<?>> findBySuperType(Collection<String> packages, ResourceLoader loader, Class<?> type) {
        return this.findByAnnotationOrSuperType(packages, loader, Collections.emptySet(), Collections.singleton(type));
    }

    private Stream<Class<?>> findByAnnotationOrSuperType(Collection<String> packages, ResourceLoader loader, Collection<Class<? extends Annotation>> annotations, Collection<Class<?>> types) {
        ClassPathScanner scanner = new ClassPathScanner(this.appContext.getEnvironment(), loader, annotations, types);
        return packages.stream().map(arg_0 -> ((ClassPathScanner)scanner).findCandidateComponents(arg_0)).flatMap(Collection::stream).map(this::getBeanClass);
    }

    private Class<?> getBeanClass(BeanDefinition beanDefinition) {
        Class beanClass;
        AbstractBeanDefinition definition = (AbstractBeanDefinition)beanDefinition;
        if (definition.hasBeanClass()) {
            beanClass = definition.getBeanClass();
        } else {
            try {
                beanClass = definition.resolveBeanClass(this.appContext.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return beanClass;
    }

    private Collection<String> getRoutePackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getVerifiableAnnotationPackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getWebComponentPackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getErrorParameterPackages() {
        return Stream.concat(Stream.of(HasErrorParameter.class.getPackage().getName()), this.getDefaultPackages().stream()).collect(Collectors.toSet());
    }

    private List<String> getDefaultPackages() {
        List packagesList = Collections.emptyList();
        if (this.appContext.getBeanNamesForType(VaadinScanPackagesRegistrar.VaadinScanPackages.class).length > 0) {
            VaadinScanPackagesRegistrar.VaadinScanPackages packages = (VaadinScanPackagesRegistrar.VaadinScanPackages)this.appContext.getBean(VaadinScanPackagesRegistrar.VaadinScanPackages.class);
            packagesList = packages.getScanPackages();
        }
        if (!packagesList.isEmpty()) {
            VaadinServletContextInitializer.getLogger().trace("Using explicitly configured packages for scan Vaadin types at startup {}", packagesList);
        } else if (AutoConfigurationPackages.has((BeanFactory)this.appContext)) {
            packagesList = AutoConfigurationPackages.get((BeanFactory)this.appContext);
        }
        return packagesList;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VaadinServletContextInitializer.class);
    }

    protected static class SpringStubServletConfig
    implements ServletConfig {
        private final ServletContext context;
        private final ServletRegistrationBean<?> registration;
        private final ApplicationContext appContext;

        private SpringStubServletConfig(ServletContext context, ServletRegistrationBean<?> registration, ApplicationContext appContext) {
            this.context = context;
            this.registration = registration;
            this.appContext = appContext;
        }

        public String getServletName() {
            return this.registration.getServletName();
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getInitParameter(String name) {
            Environment env = (Environment)this.appContext.getBean(Environment.class);
            String propertyValue = env.getProperty("vaadin." + name);
            if (propertyValue != null) {
                return propertyValue;
            }
            return (String)this.registration.getInitParameters().get(name);
        }

        public Enumeration<String> getInitParameterNames() {
            Environment env = (Environment)this.appContext.getBean(Environment.class);
            List initParameters = SpringServlet.PROPERTY_NAMES.stream().filter(name -> env.getProperty("vaadin." + name) != null).collect(Collectors.toList());
            initParameters.addAll(this.registration.getInitParameters().keySet());
            return Collections.enumeration(initParameters);
        }

        private static DeploymentConfiguration createDeploymentConfiguration(Object listener, ServletContextEvent event, ApplicationContext appContext) {
            ServletRegistrationBean servletRegistrationBean = (ServletRegistrationBean)appContext.getBean("servletRegistrationBean", ServletRegistrationBean.class);
            if (servletRegistrationBean == null) {
                VaadinServletContextInitializer.getLogger().warn("No servlet registration found. {} will not be started!", (Object)listener.getClass().getSimpleName());
                return null;
            }
            return SpringStubServletConfig.createDeploymentConfiguration(event.getServletContext(), servletRegistrationBean, SpringServlet.class, appContext);
        }

        public static DeploymentConfiguration createDeploymentConfiguration(ServletContext context, ServletRegistrationBean<?> registration, Class<?> servletClass, ApplicationContext appContext) {
            try {
                SpringStubServletConfig servletConfig = new SpringStubServletConfig(context, registration, appContext);
                return DeploymentConfigurationFactory.createPropertyDeploymentConfiguration(servletClass, (VaadinConfig)new VaadinServletConfig((ServletConfig)servletConfig));
            }
            catch (VaadinConfigurationException e) {
                throw new IllegalStateException(String.format("Failed to get deployment configuration data for servlet with name '%s' and class '%s'", registration.getServletName(), servletClass), e);
            }
        }
    }

    private static class CustomResourceLoader
    extends PathMatchingResourcePatternResolver {
        private List<String> blackListed = Stream.of("antlr", "cglib", "ch/quos/logback", "commons-codec", "commons-fileupload", "commons-io", "commons-logging", "com/fasterxml", "com/google", "com/h2database", "com/helger", "com/vaadin/external/atmosphere", "com/vaadin/webjar", "javax/", "junit", "net/bytebuddy", "org/apache", "org/aspectj", "org/bouncycastle", "org/dom4j", "org/easymock", "org/hamcrest", "org/hibernate", "org/javassist", "org/jboss", "org/jsoup", "org/seleniumhq", "org/slf4j", "org/atmosphere", "org/springframework", "org/webjars/bowergithub", "org/yaml").collect(Collectors.toList());
        private static List<String> defaultWhiteList = VaadinServletContextInitializer.access$1100().stream().map(packageName -> packageName.replace('.', '/')).collect(Collectors.toList());
        private final ReentrantLock lock = new ReentrantLock(true);
        private Map<String, Resource[]> cache = new HashMap<String, Resource[]>();
        private Set<String> rootPaths = new HashSet<String>();

        public CustomResourceLoader(ResourceLoader resourceLoader, List<String> addedBlacklist) {
            super(resourceLoader);
            Objects.requireNonNull(addedBlacklist, "addedBlacklist shouldn't be null!");
            this.blackListed.addAll(addedBlacklist);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Resource[] getResources(String locationPattern) throws IOException {
            this.lock.lock();
            try {
                if (this.cache.containsKey(locationPattern)) {
                    Resource[] resourceArray = this.cache.get(locationPattern);
                    return resourceArray;
                }
                Resource[] resources = this.collectResources(locationPattern);
                this.cache.put(locationPattern, resources);
                Resource[] resourceArray = resources;
                return resourceArray;
            }
            finally {
                this.lock.unlock();
            }
        }

        private Resource[] collectResources(String locationPattern) throws IOException {
            ArrayList<Resource> resourcesList = new ArrayList<Resource>();
            for (Resource resource : super.getResources(locationPattern)) {
                String path = resource.getURL().getPath();
                if (path.endsWith(".jar!/")) {
                    resourcesList.add(resource);
                    continue;
                }
                if (path.endsWith("/")) {
                    this.rootPaths.add(path);
                    resourcesList.add(resource);
                    continue;
                }
                int index = path.lastIndexOf(".jar!/");
                if (index >= 0) {
                    String relativePath = path.substring(index + 6);
                    if (!this.shouldPathBeScanned(relativePath)) continue;
                    resourcesList.add(resource);
                    continue;
                }
                List parents = this.rootPaths.stream().filter(path::startsWith).collect(Collectors.toList());
                if (parents.isEmpty()) {
                    throw new IllegalStateException(String.format("Parent resource of [%s] not found in the resources!", path));
                }
                if (!parents.stream().anyMatch(parent -> this.shouldPathBeScanned(path.substring(parent.length())))) continue;
                resourcesList.add(resource);
            }
            return resourcesList.toArray(new Resource[0]);
        }

        private boolean shouldPathBeScanned(String path) {
            if (defaultWhiteList.stream().anyMatch(path::startsWith)) {
                return true;
            }
            return !this.blackListed.stream().anyMatch(path::startsWith);
        }
    }

    private class VaadinAppShellContextListener
    implements FailFastServletContextListener {
        private VaadinAppShellContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            long start = System.nanoTime();
            DeploymentConfiguration config = SpringStubServletConfig.createDeploymentConfiguration(this, event, VaadinServletContextInitializer.this.appContext);
            if (config == null || config.useV14Bootstrap()) {
                return;
            }
            Set classes = VaadinServletContextInitializer.this.findByAnnotationOrSuperType(VaadinServletContextInitializer.this.getVerifiableAnnotationPackages(), VaadinServletContextInitializer.this.customLoader, VaadinAppShellInitializer.getValidAnnotations(), VaadinAppShellInitializer.getValidSupers()).collect(Collectors.toSet());
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().info("Search for VaadinAppShell took {} ms", (Object)ms);
            VaadinAppShellInitializer.init(classes, (ServletContext)event.getServletContext(), (DeploymentConfiguration)config);
        }
    }

    private class WebComponentServletContextListener
    implements FailFastServletContextListener {
        private WebComponentServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) throws ServletException {
            WebComponentConfigurationRegistry registry = WebComponentConfigurationRegistry.getInstance((VaadinContext)new VaadinServletContext(event.getServletContext()));
            if (registry.getConfigurations() == null || registry.getConfigurations().isEmpty()) {
                WebComponentConfigurationRegistryInitializer initializer = new WebComponentConfigurationRegistryInitializer();
                Set webComponentExporters = VaadinServletContextInitializer.this.findBySuperType(VaadinServletContextInitializer.this.getWebComponentPackages(), WebComponentExporter.class).collect(Collectors.toSet());
                try {
                    initializer.process(webComponentExporters, event.getServletContext());
                }
                catch (ServletException e) {
                    throw new RuntimeException(String.format("Failed to initialize %s", WebComponentConfigurationRegistry.class.getSimpleName()), e);
                }
            }
        }
    }

    private class DevModeServletContextListener
    implements FailFastServletContextListener {
        private DevModeServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) throws ServletException {
            DeploymentConfiguration config = SpringStubServletConfig.createDeploymentConfiguration(this.getClass(), event, VaadinServletContextInitializer.this.appContext);
            if (config == null || config.isProductionMode() || !config.enableDevServer()) {
                return;
            }
            Set<String> basePackages = this.isWhitelistSet() ? new HashSet<String>(this.getWhiteListPackages()) : Collections.singleton("");
            long start = System.nanoTime();
            ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
            ArrayList superTypes = new ArrayList();
            this.collectDevModeTypes(annotations, superTypes);
            Set classes = VaadinServletContextInitializer.this.findByAnnotationOrSuperType(basePackages, VaadinServletContextInitializer.this.customLoader, annotations, superTypes).collect(Collectors.toSet());
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().info("Search for subclasses and classes with annotations took {} ms", (Object)ms);
            try {
                DevModeInitializer.initDevModeHandler(classes, (ServletContext)event.getServletContext(), (DeploymentConfiguration)config);
            }
            catch (ServletException e) {
                throw new RuntimeException("Unable to initialize Vaadin DevModeHandler", e);
            }
        }

        public void contextDestroyed(ServletContextEvent sce) {
            DevModeHandler handler = DevModeHandler.getDevModeHandler();
            if (handler != null && !handler.reuseDevServer()) {
                handler.stop();
            }
        }

        private Collection<String> getWhiteListPackages() {
            HashSet<String> npmPackages = new HashSet<String>(VaadinServletContextInitializer.this.getDefaultPackages());
            npmPackages.addAll(DEFAULT_WHITE_LISTED);
            if (VaadinServletContextInitializer.this.customWhitelist != null) {
                npmPackages.addAll(VaadinServletContextInitializer.this.customWhitelist);
            }
            return npmPackages;
        }

        private void collectDevModeTypes(List<Class<? extends Annotation>> annotations, List<Class<?>> superTypes) {
            HandlesTypes handleTypes = DevModeInitializer.class.getAnnotation(HandlesTypes.class);
            assert (handleTypes != null);
            for (Class clazz : handleTypes.value()) {
                if (clazz.isAnnotation()) {
                    annotations.add(clazz);
                    continue;
                }
                superTypes.add(clazz);
            }
        }

        private boolean isWhitelistSet() {
            return VaadinServletContextInitializer.this.customWhitelist != null && !VaadinServletContextInitializer.this.customWhitelist.isEmpty();
        }
    }

    private class AnnotationValidatorServletContextListener
    implements FailFastServletContextListener {
        private AnnotationValidatorServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            AnnotationValidator annotationValidator = new AnnotationValidator();
            this.validateAnnotations((ClassLoaderAwareServletContainerInitializer)annotationValidator, event.getServletContext(), annotationValidator.getAnnotations());
            WebComponentExporterAwareValidator extraValidator = new WebComponentExporterAwareValidator();
            this.validateAnnotations((ClassLoaderAwareServletContainerInitializer)extraValidator, event.getServletContext(), extraValidator.getAnnotations());
        }

        private void validateAnnotations(ClassLoaderAwareServletContainerInitializer initializer, ServletContext context, List<Class<?>> annotations) {
            Stream annotatedClasses = VaadinServletContextInitializer.this.findByAnnotation((Collection<String>)VaadinServletContextInitializer.this.getVerifiableAnnotationPackages(), annotations.toArray(new Class[annotations.size()]));
            Set set = annotatedClasses.collect(Collectors.toSet());
            try {
                initializer.process(set, context);
            }
            catch (ServletException exception) {
                throw new RuntimeException("Unexpected servlet exception from " + initializer.getClass() + " validator", exception);
            }
        }
    }

    private class ErrorParameterServletContextListener
    implements FailFastServletContextListener {
        private ErrorParameterServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)new VaadinServletContext(event.getServletContext()));
            Stream<Class> hasErrorComponents = VaadinServletContextInitializer.this.findBySuperType(VaadinServletContextInitializer.this.getErrorParameterPackages(), HasErrorParameter.class).filter(Component.class::isAssignableFrom).map(clazz -> clazz);
            registry.setErrorNavigationTargets(hasErrorComponents.collect(Collectors.toSet()));
        }
    }

    private class RouteServletContextListener
    extends AbstractRouteRegistryInitializer
    implements FailFastServletContextListener {
        private RouteServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)new VaadinServletContext(event.getServletContext()));
            VaadinServletContextInitializer.getLogger().debug("Servlet Context initialized. Running route discovering....");
            if (registry.getRegisteredRoutes().isEmpty()) {
                VaadinServletContextInitializer.getLogger().debug("There are no discovered routes yet. Start to collect all routes from the classpath...");
                try {
                    List routeClasses = VaadinServletContextInitializer.this.findByAnnotation((Collection<String>)VaadinServletContextInitializer.this.getRoutePackages(), new Class[]{Route.class, RouteAlias.class}).collect(Collectors.toList());
                    VaadinServletContextInitializer.getLogger().debug("Found {} route classes. Here is the list: {}", (Object)routeClasses.size(), routeClasses);
                    Set navigationTargets = this.validateRouteClasses(routeClasses.stream());
                    VaadinServletContextInitializer.getLogger().debug("There are {} navigation targets after filtering route classes: {}", (Object)navigationTargets.size(), (Object)navigationTargets);
                    RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)registry);
                    routeConfiguration.update((Command & Serializable)() -> this.setAnnotatedRoutes(routeConfiguration, navigationTargets));
                    registry.setPwaConfigurationClass(this.validatePwaClass(routeClasses.stream()));
                }
                catch (InvalidRouteConfigurationException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                VaadinServletContextInitializer.getLogger().debug("Skipped discovery as there was {} routes already in registry", (Object)registry.getRegisteredRoutes().size());
            }
        }

        private void setAnnotatedRoutes(RouteConfiguration routeConfiguration, Set<Class<? extends Component>> routes) {
            routeConfiguration.getHandledRegistry().clean();
            for (Class<? extends Component> navigationTarget : routes) {
                try {
                    routeConfiguration.setAnnotatedRoute(navigationTarget);
                }
                catch (AmbiguousRouteConfigurationException exception) {
                    if (this.handleAmbiguousRoute(routeConfiguration, exception.getConfiguredNavigationTarget(), navigationTarget)) continue;
                    throw exception;
                }
            }
        }

        private boolean handleAmbiguousRoute(RouteConfiguration routeConfiguration, Class<? extends Component> configuredNavigationTarget, Class<? extends Component> navigationTarget) {
            if (GenericTypeReflector.isSuperType(navigationTarget, configuredNavigationTarget)) {
                return true;
            }
            if (GenericTypeReflector.isSuperType(configuredNavigationTarget, navigationTarget)) {
                routeConfiguration.removeRoute(configuredNavigationTarget);
                routeConfiguration.setAnnotatedRoute(navigationTarget);
                return true;
            }
            return false;
        }
    }

    private static interface FailFastServletContextListener
    extends ServletContextListener,
    Serializable {
        public static final String ATTR = "failed-" + FailFastServletContextListener.class.getName();

        default public void contextInitialized(ServletContextEvent event) {
            if (event.getServletContext().getAttribute(ATTR) == null) {
                try {
                    this.failFastContextInitialized(event);
                }
                catch (Exception e) {
                    event.getServletContext().setAttribute(ATTR, (Object)true);
                    throw new RuntimeException("Unable to initialize " + this.getClass().getName(), e);
                }
            }
        }

        public void failFastContextInitialized(ServletContextEvent var1) throws ServletException;
    }

    private static class ClassPathScanner
    extends ClassPathScanningCandidateComponentProvider {
        private ClassPathScanner(Environment environment, ResourceLoader resourceLoader, Collection<Class<? extends Annotation>> annotations, Collection<Class<?>> types) {
            super(false, environment);
            this.setResourceLoader(resourceLoader);
            annotations.stream().map(AnnotationTypeFilter::new).forEach(arg_0 -> ((ClassPathScanner)this).addIncludeFilter(arg_0));
            types.stream().map(AssignableTypeFilter::new).forEach(arg_0 -> ((ClassPathScanner)this).addIncludeFilter(arg_0));
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return super.isCandidateComponent(beanDefinition) || beanDefinition.getMetadata().isAbstract();
        }
    }
}

