/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security.stateless;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import com.vaadin.flow.spring.security.stateless.SerializedJwtSplitCookieRepository;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SaveContextOnUpdateOrErrorResponseWrapper;
import org.springframework.security.web.context.SecurityContextRepository;

class JwtSecurityContextRepository
implements SecurityContextRepository {
    private static final String ROLES_CLAIM = "roles";
    private static final String ROLE_AUTHORITY_PREFIX = "ROLE_";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final SerializedJwtSplitCookieRepository serializedJwtSplitCookieRepository;
    private final JwtAuthenticationConverter jwtAuthenticationConverter;
    private String issuer;
    private long expiresIn = 1800L;
    private JWKSource<com.nimbusds.jose.proc.SecurityContext> jwkSource;
    private JWSAlgorithm jwsAlgorithm;
    private JwtDecoder jwtDecoder;
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();

    JwtSecurityContextRepository(SerializedJwtSplitCookieRepository serializedJwtSplitCookieRepository) {
        this.serializedJwtSplitCookieRepository = serializedJwtSplitCookieRepository;
        JwtGrantedAuthoritiesConverter grantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
        grantedAuthoritiesConverter.setAuthorityPrefix(ROLE_AUTHORITY_PREFIX);
        grantedAuthoritiesConverter.setAuthoritiesClaimName(ROLES_CLAIM);
        this.jwtAuthenticationConverter = new JwtAuthenticationConverter();
        this.jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)grantedAuthoritiesConverter);
    }

    void setJwkSource(JWKSource<com.nimbusds.jose.proc.SecurityContext> jwkSource) {
        this.jwkSource = jwkSource;
    }

    void setJwsAlgorithm(JWSAlgorithm jwsAlgorithm) {
        this.jwsAlgorithm = jwsAlgorithm;
    }

    void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
        this.serializedJwtSplitCookieRepository.setExpiresIn(expiresIn);
    }

    void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.trustResolver = trustResolver;
    }

    private JwtDecoder getJwtDecoder() {
        if (this.jwtDecoder != null) {
            return this.jwtDecoder;
        }
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWTClaimsSetVerifier((claimsSet, context) -> {});
        JWSVerificationKeySelector jwsKeySelector = new JWSVerificationKeySelector(this.jwsAlgorithm, this.jwkSource);
        jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
        NimbusJwtDecoder nimbusJwtDecoder = new NimbusJwtDecoder((JWTProcessor)jwtProcessor);
        nimbusJwtDecoder.setJwtValidator(this.issuer != null ? JwtValidators.createDefaultWithIssuer((String)this.issuer) : JwtValidators.createDefault());
        this.jwtDecoder = nimbusJwtDecoder;
        return this.jwtDecoder;
    }

    private String encodeJwt(Authentication authentication) throws JOSEException {
        if (authentication == null || this.trustResolver.isAnonymous(authentication)) {
            return null;
        }
        Date now = new Date();
        List roles = authentication.getAuthorities().stream().map(Objects::toString).filter(a -> a.startsWith(ROLE_AUTHORITY_PREFIX)).map(a -> a.substring(ROLE_AUTHORITY_PREFIX.length())).collect(Collectors.toList());
        JWSHeader jwsHeader = new JWSHeader(this.jwsAlgorithm);
        JWKSelector jwkSelector = new JWKSelector(JWKMatcher.forJWSHeader((JWSHeader)jwsHeader));
        List jwks = this.jwkSource.get(jwkSelector, null);
        JWK jwk = (JWK)jwks.get(0);
        JWSSigner signer = new DefaultJWSSignerFactory().createJWSSigner(jwk, this.jwsAlgorithm);
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(authentication.getName()).issuer(this.issuer).issueTime(now).expirationTime(new Date(now.getTime() + this.expiresIn * 1000L)).claim(ROLES_CLAIM, roles).build();
        SignedJWT signedJWT = new SignedJWT(jwsHeader, claimsSet);
        signedJWT.sign(signer);
        return signedJWT.serialize();
    }

    private Jwt decodeJwt(HttpServletRequest request) {
        String serializedJwt = this.serializedJwtSplitCookieRepository.loadSerializedJwt(request);
        if (serializedJwt == null) {
            return null;
        }
        try {
            return this.getJwtDecoder().decode(serializedJwt);
        }
        catch (JwtException e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Cannot decode JWT when loading SecurityContext", (Throwable)e);
            }
            return null;
        }
    }

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        HttpServletRequest request = requestResponseHolder.getRequest();
        Jwt jwt = this.decodeJwt(request);
        if (jwt != null) {
            AbstractAuthenticationToken authentication = this.jwtAuthenticationConverter.convert(jwt);
            context.setAuthentication((Authentication)authentication);
        }
        requestResponseHolder.setResponse((HttpServletResponse)new UpdateJwtResponseWrapper(request, requestResponseHolder.getResponse()));
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        String serializedJwt = null;
        try {
            serializedJwt = this.encodeJwt(context.getAuthentication());
        }
        catch (JOSEException e) {
            this.logger.warn((Object)"Cannot serialize SecurityContext as JWT", (Throwable)e);
        }
        finally {
            this.serializedJwtSplitCookieRepository.saveSerializedJwt(serializedJwt, request, response);
        }
    }

    public boolean containsContext(HttpServletRequest request) {
        return this.serializedJwtSplitCookieRepository.containsSerializedJwt(request);
    }

    private final class UpdateJwtResponseWrapper
    extends SaveContextOnUpdateOrErrorResponseWrapper {
        private final HttpServletRequest request;

        private UpdateJwtResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(response, true);
            this.request = request;
        }

        protected void saveContext(SecurityContext context) {
            JwtSecurityContextRepository.this.saveContext(context, this.request, (HttpServletResponse)this);
        }
    }
}

