/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.spring.SpringUtil;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class RootMappedCondition
implements Condition {
    public static final String URL_MAPPING_PROPERTY = "vaadin.urlMapping";

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String urlMapping = RootMappedCondition.getUrlMapping(context.getEnvironment());
        return RootMappedCondition.isRootMapping(urlMapping);
    }

    public static String getUrlMapping(Environment environment) {
        if (SpringUtil.isSpringBoot()) {
            try {
                return (String)Class.forName("com.vaadin.flow.spring.VaadinConfigurationProperties").getMethod("getUrlMapping", Environment.class).invoke(null, environment);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LoggerFactory.getLogger(RootMappedCondition.class).error("Unable to find urlMapping from properties", (Throwable)e);
                return null;
            }
        }
        return environment.getProperty(URL_MAPPING_PROPERTY);
    }

    public static boolean isRootMapping(String mapping) {
        if (mapping == null) {
            return true;
        }
        return mapping.trim().replaceAll("(/\\**)?$", "").isEmpty();
    }
}

