/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class CyclicObjectWorkaround {
    private static final String TEMPLATE;

    private static String readInputStream(InputStream is) throws IOException {
        try (InputStream inputStream = is;){
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String string = result.toString(StandardCharsets.UTF_8.name());
            return string;
        }
    }

    public static String get(String jsObjectName) {
        return TEMPLATE.replace("jsObject", jsObjectName);
    }

    static {
        try {
            TEMPLATE = CyclicObjectWorkaround.readInputStream(CyclicObjectWorkaround.class.getResourceAsStream("cyclic-object-workaround.js"));
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

