/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.screenshot;

import com.vaadin.testbench.screenshot.ErrorBlock;
import com.vaadin.testbench.screenshot.ImageComparisonUtil;
import com.vaadin.testbench.screenshot.ImageFileUtil;
import com.vaadin.testbench.screenshot.ImageUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;

public class ScreenShotFailureReporter {
    private final BufferedImage referenceImage;
    private final boolean[][] falseBlocks;
    private final int xBlocks;
    private final int yBlocks;

    public ScreenShotFailureReporter(BufferedImage referenceImage, boolean[][] falseBlocks) {
        this.referenceImage = referenceImage;
        this.falseBlocks = falseBlocks;
        this.xBlocks = ImageComparisonUtil.getNrBlocks(referenceImage.getWidth());
        this.yBlocks = ImageComparisonUtil.getNrBlocks(referenceImage.getHeight());
    }

    public void createErrorImageAndHTML(String fileName, BufferedImage screenshotImage) {
        try {
            ImageIO.write((RenderedImage)screenshotImage, "png", ImageFileUtil.getErrorScreenshotFile(fileName));
        }
        catch (IOException e) {
            System.err.println("Error writing screenshot to " + ImageFileUtil.getErrorScreenshotFile(fileName).getPath());
            e.printStackTrace();
        }
        List<ErrorBlock> errorAreas = this.collectErrorsToList(this.xBlocks, this.yBlocks);
        this.drawErrorsToImage(errorAreas, screenshotImage);
        this.createDiffHtml(errorAreas, fileName, screenshotImage, this.referenceImage);
    }

    private List<ErrorBlock> collectErrorsToList(int xBlocks, int yBlocks) {
        LinkedList<ErrorBlock> errorAreas = new LinkedList<ErrorBlock>();
        for (int y = 0; y < yBlocks; ++y) {
            for (int x = 0; x < xBlocks; ++x) {
                if (!this.falseBlocks[x][y]) continue;
                ErrorBlock newBlock = new ErrorBlock();
                newBlock.setX(x * 16);
                newBlock.setY(y * 16);
                int x1 = x;
                int xmin = x;
                int y1 = y;
                int maxSteps = xBlocks * yBlocks;
                int steps = 0;
                this.falseBlocks[x][y] = false;
                do {
                    if (++x1 >= xBlocks) {
                        x1 = xmin;
                    }
                    if (this.falseBlocks[x1][y1]) {
                        newBlock.addXBlock();
                        this.falseBlocks[x1][y1] = false;
                        continue;
                    }
                    if (y1 >= yBlocks) continue;
                    x1 = xmin;
                    boolean foundConnectedBlock = false;
                    for (int foundX = x1; foundX < x1 + newBlock.getXBlocks() && foundX != xBlocks && y1 + 1 != yBlocks; ++foundX) {
                        if (!this.falseBlocks[foundX][y1 + 1]) continue;
                        foundConnectedBlock = true;
                    }
                    if (foundConnectedBlock) {
                        ++y1;
                        newBlock.addYBlock();
                        if (x1 - 1 >= 0) {
                            while (this.falseBlocks[x1 - 1][y1]) {
                                this.falseBlocks[x1 - 1][y1] = false;
                                newBlock.addXBlock();
                                newBlock.setX(newBlock.getX() - 16);
                                if (--x1 != 0) continue;
                            }
                            xmin = x1;
                        }
                        x1 = x1 + newBlock.getXBlocks() - 1;
                        continue;
                    }
                    x1 = newBlock.getX() / 16;
                    y1 = newBlock.getY() / 16;
                    for (int j = 0; j < newBlock.getYBlocks(); ++j) {
                        for (int i = 0; i < newBlock.getXBlocks(); ++i) {
                            if (x1 + i >= xBlocks || y1 + j >= yBlocks) continue;
                            this.falseBlocks[x1 + i][y1 + j] = false;
                        }
                    }
                    break;
                } while (++steps != maxSteps);
                errorAreas.add(newBlock);
            }
        }
        return errorAreas;
    }

    private void drawErrorsToImage(List<ErrorBlock> errorAreas, BufferedImage screenshotImage) {
        Graphics2D drawToPicture = screenshotImage.createGraphics();
        drawToPicture.setColor(Color.MAGENTA);
        int width = screenshotImage.getWidth();
        int height = screenshotImage.getHeight();
        for (ErrorBlock error : errorAreas) {
            int offsetX = 0;
            int offsetY = 0;
            if (error.getX() > 0) {
                offsetX = 1;
            }
            if (error.getY() > 0) {
                offsetY = 1;
            }
            int toX = error.getXBlocks() * 16 + offsetX;
            int toY = error.getYBlocks() * 16 + offsetY;
            if (error.getX() + error.getXBlocks() * 16 + offsetX > width) {
                toX = width - error.getX();
            }
            if (error.getY() + error.getYBlocks() * 16 + offsetY > height) {
                toY = height - error.getY();
            }
            drawToPicture.drawRect(error.getX() - offsetX, error.getY() - offsetY, toX, toY);
        }
        drawToPicture.dispose();
    }

    private void createDiffHtml(List<ErrorBlock> blocks, String fileId, BufferedImage screenshotImage, BufferedImage referenceImage) {
        String image = ImageUtil.encodeImageToBase64(screenshotImage);
        String ref_image = ImageUtil.encodeImageToBase64(referenceImage);
        try {
            PrintWriter writer = new PrintWriter(ImageFileUtil.getErrorScreenshotFile(fileId + ".html"));
            writer.println("<html>");
            writer.println("<head>");
            writer.println("<script type=\"text/javascript\">var difference = true;function switchImage(){if(difference){difference = false;document.getElementById('reference').style.display='block';document.getElementById('diff').style.display='none';}else{difference = true;document.getElementById('reference').style.display='none';document.getElementById('diff').style.display='block';}}</script>");
            writer.println("</head>");
            writer.println("<body onclick=\"switchImage()\" style=\"-moz-user-select: none; -webkit-user-select: none; -ms-user-select: none;\">");
            writer.println("<div id=\"diff\" style=\"display: block; position: absolute; top: 0px; left: 0px;\"><img src=\"data:image/png;base64," + image + "\"/><span style=\"position: absolute; top: 0px; left: 0px; opacity:0.4; filter: alpha(opacity=40); font-weight: bold;\">Image for this run</span></div>");
            writer.println("<div id=\"reference\" style=\"display: none; position: absolute; top: 0px; left: 0px; z-index: 999;\"><img src=\"data:image/png;base64," + ref_image + "\"/></div>");
            int add = 0;
            for (ErrorBlock error : blocks) {
                int offsetX = 0;
                int offsetY = 0;
                if (error.getX() > 0) {
                    offsetX = 1;
                }
                if (error.getY() > 0) {
                    offsetY = 1;
                }
                String id = "popUpDiv_" + (error.getX() + add) + "_" + (error.getY() + add);
                writer.println("<div  onmouseover=\"document.getElementById('" + id + "').style.display='block'\"  style=\"z-index: 66;position: absolute; top: 0px; left: 0px; clip: rect(" + (error.getY() - offsetY) + "px," + (error.getX() + error.getXBlocks() * 16 + 1) + "px," + (error.getY() + error.getYBlocks() * 16 + 1) + "px," + (error.getX() - offsetX) + "px);\"><img src=\"data:image/png;base64," + image + "\"/></div>");
                writer.println("<div class=\"popUpDiv\" onclick=\"document.getElementById('reference').style.display='block'; document.getElementById('diff').style.display='none';\" onmouseout=\"this.style.display='none'\" id=\"" + id + "\"  style=\"display: none; position: absolute; top: 0px; left: 0px; clip: rect(" + (error.getY() - offsetY) + "px," + (error.getX() + error.getXBlocks() * 16 + 1) + "px," + (error.getY() + error.getYBlocks() * 16 + 1) + "px," + (error.getX() - offsetX) + "px); z-index: " + (99 + add) + ";\">");
                writer.println("<img src=\"data:image/png;base64," + ref_image + "\" />");
                writer.println("</div>");
                ++add;
            }
            writer.println("</body></html>");
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

