/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.HasCallFunction;
import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.HasElementQuery;
import com.vaadin.testbench.HasPropertySettersGetters;
import com.vaadin.testbench.HasTestBenchCommandExecutor;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.commands.CanCompareScreenshots;
import com.vaadin.testbench.commands.ScreenshotComparator;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elementsbase.Element;
import com.vaadin.testbench.parallel.BrowserUtil;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

@Element(value="*")
public class TestBenchElement
implements WrapsElement,
WebElement,
HasDriver,
CanCompareScreenshots,
HasTestBenchCommandExecutor,
HasElementQuery,
HasPropertySettersGetters,
HasCallFunction {
    private WebElement wrappedElement = null;
    private TestBenchCommandExecutor commandExecutor = null;

    protected TestBenchElement() {
    }

    protected TestBenchElement(WebElement webElement, TestBenchCommandExecutor commandExecutor) {
        this.init(webElement, commandExecutor);
    }

    protected void init(WebElement element, TestBenchCommandExecutor commandExecutor) {
        if (this.commandExecutor == null) {
            this.commandExecutor = commandExecutor;
            this.wrappedElement = element;
            this.init();
        }
    }

    protected boolean isChrome() {
        return BrowserUtil.isChrome(this.getCapabilities());
    }

    protected boolean isFirefox() {
        return BrowserUtil.isFirefox(this.getCapabilities());
    }

    protected Capabilities getCapabilities() {
        WebDriver driver = this.getDriver();
        if (driver instanceof HasCapabilities) {
            return ((HasCapabilities)driver).getCapabilities();
        }
        return null;
    }

    protected void init() {
    }

    public WebElement getWrappedElement() {
        return this.wrappedElement;
    }

    protected void waitForVaadin() {
        if (this.getCommandExecutor() != null) {
            this.getCommandExecutor().waitForVaadin();
        }
    }

    public String getId() {
        return this.getAttribute("id");
    }

    public void scroll(int scrollTop) {
        this.setProperty("scrollTop", scrollTop);
    }

    public void scrollLeft(int scrollLeft) {
        this.setProperty("scrollLeft", scrollLeft);
    }

    public boolean isFocused() {
        return this.getWrappedElement().equals(this.getDriver().switchTo().activeElement());
    }

    public void click() {
        this.focus();
        try {
            this.callFunction("click", new Object[0]);
        }
        catch (Exception e) {
            if (e.getMessage().contains("Inspected target navigated or closed")) {
                return;
            }
            this.autoScrollIntoView();
            this.waitForVaadin();
            this.wrappedElement.click();
        }
    }

    public void submit() {
        this.click();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.autoScrollIntoView();
        this.waitForVaadin();
        this.wrappedElement.sendKeys(keysToSend);
    }

    public void clear() {
        this.autoScrollIntoView();
        this.waitForVaadin();
        this.wrappedElement.clear();
    }

    public String getTagName() {
        this.waitForVaadin();
        return this.wrappedElement.getTagName();
    }

    public String getAttribute(String name) {
        this.waitForVaadin();
        return this.wrappedElement.getAttribute(name);
    }

    public @Nullable String getDomAttribute(String name) {
        this.waitForVaadin();
        return this.wrappedElement.getDomAttribute(name);
    }

    public @Nullable String getDomProperty(String name) {
        this.waitForVaadin();
        return this.wrappedElement.getDomProperty(name);
    }

    public boolean hasAttribute(String attribute) {
        return (Boolean)this.callFunction("hasAttribute", attribute);
    }

    public boolean isSelected() {
        this.autoScrollIntoView();
        this.waitForVaadin();
        return this.wrappedElement.isSelected();
    }

    public boolean isEnabled() {
        this.waitForVaadin();
        return !this.hasClassName("v-disabled") && !this.hasAttribute("disabled") && this.wrappedElement.isEnabled();
    }

    public boolean isReadOnly() {
        this.waitForVaadin();
        return this.hasAttribute("readonly");
    }

    public String getText() {
        this.autoScrollIntoView();
        this.waitForVaadin();
        return this.wrappedElement.getText();
    }

    public List<WebElement> findElements(By by) {
        return TestBenchElement.wrapElements(this.wrappedElement.findElements(by), this.getCommandExecutor());
    }

    public TestBenchElement findElement(By by) {
        this.waitForVaadin();
        return TestBenchElement.wrapElement(this.wrappedElement.findElement(by), this.getCommandExecutor());
    }

    public boolean isDisplayed() {
        this.waitForVaadin();
        return this.wrappedElement.isDisplayed();
    }

    public Point getLocation() {
        this.waitForVaadin();
        return this.wrappedElement.getLocation();
    }

    public Dimension getSize() {
        this.waitForVaadin();
        return this.wrappedElement.getSize();
    }

    public String getCssValue(String propertyName) {
        this.waitForVaadin();
        return this.wrappedElement.getCssValue(propertyName);
    }

    public void click(int x, int y, Keys ... modifiers) {
        this.autoScrollIntoView();
        this.waitForVaadin();
        Actions actions = new Actions(this.getDriver());
        actions.moveToElement(this.wrappedElement, x, y);
        for (Keys modifier : modifiers) {
            actions.keyDown((CharSequence)modifier);
        }
        actions.click();
        for (Keys modifier : modifiers) {
            actions.keyUp((CharSequence)modifier);
        }
        actions.build().perform();
    }

    public void doubleClick() {
        this.autoScrollIntoView();
        this.waitForVaadin();
        new Actions(this.getDriver()).doubleClick(this.wrappedElement).build().perform();
    }

    public void contextClick() {
        this.autoScrollIntoView();
        this.waitForVaadin();
        new Actions(this.getDriver()).contextClick(this.wrappedElement).build().perform();
    }

    public <T extends TestBenchElement> T wrap(Class<T> elementType) {
        return TestBench.wrap(this, elementType);
    }

    @Override
    public TestBenchCommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @Override
    public WebDriver getDriver() {
        return this.getCommandExecutor().getDriver();
    }

    @Override
    public SearchContext getContext() {
        return this;
    }

    public void focus() {
        this.waitForVaadin();
        this.getCommandExecutor().focusElement(this);
    }

    protected static List<TestBenchElement> wrapElements(List<WebElement> elements, TestBenchCommandExecutor commandExecutor) {
        ArrayList<TestBenchElement> wrappedList = new ArrayList<TestBenchElement>();
        for (WebElement e : elements) {
            wrappedList.add(TestBenchElement.wrapElement(e, commandExecutor));
        }
        return wrappedList;
    }

    protected static TestBenchElement wrapElement(WebElement element, TestBenchCommandExecutor commandExecutor) {
        if (element instanceof TestBenchElement) {
            return (TestBenchElement)element;
        }
        return TestBench.createElement(element, commandExecutor);
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        this.waitForVaadin();
        return (X)this.wrappedElement.getScreenshotAs(target);
    }

    public Rectangle getRect() {
        this.waitForVaadin();
        return this.wrappedElement.getRect();
    }

    public Set<String> getClassNames() {
        String classAttribute = this.getDomAttribute("class");
        HashSet<String> classes = new HashSet<String>();
        if (classAttribute == null) {
            return classes;
        }
        if ((classAttribute = classAttribute.trim()).isEmpty()) {
            return classes;
        }
        Collections.addAll(classes, classAttribute.split("[ ]+"));
        return classes;
    }

    public boolean hasClassName(String className) {
        if (className == null || className.isEmpty()) {
            return false;
        }
        return this.getClassNames().contains(className);
    }

    public boolean equals(Object obj) {
        if (this.wrappedElement == null) {
            return false;
        }
        return this.wrappedElement.equals(obj);
    }

    public int hashCode() {
        if (this.wrappedElement == null) {
            return 32;
        }
        return this.wrappedElement.hashCode();
    }

    @Override
    public boolean compareScreen(String referenceId) throws IOException {
        return ScreenshotComparator.compareScreen(referenceId, this.getCommandExecutor().getReferenceNameGenerator(), this.getCommandExecutor().getImageComparison(), (TakesScreenshot)this, (HasCapabilities)this.getDriver());
    }

    @Override
    public boolean compareScreen(File reference) throws IOException {
        return ScreenshotComparator.compareScreen(reference, this.getCommandExecutor().getImageComparison(), (TakesScreenshot)this, (HasCapabilities)this.getDriver());
    }

    @Override
    public boolean compareScreen(BufferedImage reference, String referenceName) throws IOException {
        return ScreenshotComparator.compareScreen(reference, referenceName, this.getCommandExecutor().getImageComparison(), (TakesScreenshot)this, (HasCapabilities)this.getDriver());
    }

    public void scrollIntoView() {
        this.callFunction("scrollIntoView", new Object[0]);
    }

    private void autoScrollIntoView() {
        try {
            if (this.getCommandExecutor().isAutoScrollIntoView() && !this.wrappedElement.isDisplayed()) {
                this.scrollIntoView();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected <T> T waitUntil(ExpectedCondition<T> condition, long timeoutInSeconds) {
        return (T)new WebDriverWait(this.getDriver(), Duration.ofSeconds(timeoutInSeconds)).until(condition);
    }

    protected <T> T waitUntil(ExpectedCondition<T> condition) {
        return this.waitUntil(condition, 10L);
    }

    @Override
    public void setProperty(String name, String value) {
        this.internalSetProperty(name, value);
    }

    @Override
    public void setProperty(String name, Boolean value) {
        this.internalSetProperty(name, value);
    }

    @Override
    public void setProperty(String name, Double value) {
        this.internalSetProperty(name, value);
    }

    @Override
    public void setProperty(String name, Integer value) {
        this.internalSetProperty(name, value);
    }

    @Override
    public String getPropertyString(String ... propertyNames) {
        Object value = this.getProperty(propertyNames);
        if (value == null) {
            return null;
        }
        return this.createJsonValue(value).asString();
    }

    @Override
    public Boolean getPropertyBoolean(String ... propertyNames) {
        Object value = this.getProperty(propertyNames);
        if (value == null) {
            return null;
        }
        return this.createJsonValue(value).asBoolean();
    }

    @Override
    public TestBenchElement getPropertyElement(String ... propertyNames) {
        return (TestBenchElement)this.getProperty(propertyNames);
    }

    @Override
    public List<TestBenchElement> getPropertyElements(String ... propertyNames) {
        return (List)this.getProperty(propertyNames);
    }

    @Override
    public Double getPropertyDouble(String ... propertyNames) {
        Object value = this.getProperty(propertyNames);
        if (value == null) {
            return null;
        }
        return this.createJsonValue(value).asNumber();
    }

    @Override
    public Integer getPropertyInteger(String ... propertyNames) {
        Double number = this.getPropertyDouble(propertyNames);
        return number == null ? null : Integer.valueOf(number.intValue());
    }

    private void internalSetProperty(String name, Object value) {
        if (this.isFirefox() && value instanceof Double) {
            this.executeScript("arguments[0][arguments[1]]=Number(arguments[2])", this, name, String.valueOf(value));
        } else {
            this.executeScript("arguments[0][arguments[1]]=arguments[2]", this, name, value);
        }
    }

    @Override
    public Object getProperty(String ... propertyNames) {
        String isNumberScript;
        boolean number;
        String script = "var value = arguments[0];" + TestBenchElement.createPropertyChain(propertyNames) + ";";
        Object[] jsParameters = Stream.concat(Stream.of(this), Stream.of(propertyNames)).toArray();
        if (this.isFirefox() && (number = ((Boolean)this.executeScript(isNumberScript = script + "return typeof value == 'number';", jsParameters)).booleanValue())) {
            String str = (String)this.executeScript(script + "return value.toString();", jsParameters);
            return Double.parseDouble(str);
        }
        return this.executeScript(script + "return value;", jsParameters);
    }

    private static String createPropertyChain(String[] propertyNames) {
        Object result = "";
        for (int i = 0; i < propertyNames.length; ++i) {
            result = (String)result + "if (typeof value != 'undefined') value = value[arguments[" + (i + 1) + "]];";
        }
        return result;
    }

    private JsonValue createJsonValue(Object value) {
        if (value == null) {
            return Json.createNull();
        }
        if (value instanceof String) {
            return Json.create((String)((String)value));
        }
        if (value instanceof Number) {
            return Json.create((double)((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return Json.create((boolean)((Boolean)value));
        }
        throw new IllegalArgumentException("Type of property is unsupported: " + value.getClass().getName());
    }

    protected Object executeScript(String script, Object ... args) {
        return this.getCommandExecutor().executeScript(script, args);
    }

    @Override
    public Object callFunction(String methodName, Object ... args) {
        String paramPlaceholderString = IntStream.range(1, args.length + 1).mapToObj(i -> "arguments[" + i + "]").collect(Collectors.joining(","));
        Object[] jsParameters = Stream.concat(Stream.of(this), Stream.of(args)).toArray(Object[]::new);
        return this.executeScript("return arguments[0]." + methodName + "(" + paramPlaceholderString + ")", jsParameters);
    }

    public void dispatchEvent(String eventType) {
        this.executeScript("arguments[0].dispatchEvent(new CustomEvent(arguments[1]));", this, eventType);
    }

    public void dispatchEvent(String eventType, Map<String, Object> customEventInit) {
        this.executeScript("arguments[0].dispatchEvent(new CustomEvent(arguments[1], arguments[2]));", this, eventType, customEventInit);
    }

    public TestBenchElement getParent() {
        return this.getPropertyElement("parentElement");
    }

    @Deprecated
    public SearchContext getShadowRoot() {
        throw new UnsupportedOperationException("getShadowRoot");
    }

    public List<TestBenchElement> getChildren() {
        return this.getPropertyElements("children");
    }

    public void hover() {
        Actions action = new Actions(this.getDriver());
        action.moveToElement((WebElement)this).perform();
    }
}

