/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel.setup;

import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.BrowserUtil;
import com.vaadin.testbench.parallel.setup.LocalDriver;
import com.vaadin.testbench.parallel.setup.RemoteDriver;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SetupDriver {
    private DesiredCapabilities desiredCapabilities = Browser.FIREFOX.getDesiredCapabilities();

    public WebDriver setupRemoteDriver(RemoteDriver remoteDriver, String hubURL) throws Exception {
        DesiredCapabilities capabilities = this.getDesiredCapabilities();
        this.setDesiredCapabilities(capabilities);
        WebDriver driver = remoteDriver.createDriver(hubURL, capabilities);
        return driver;
    }

    public WebDriver setupRemoteDriver(String hubURL) throws Exception {
        return this.setupRemoteDriver(new RemoteDriver(), hubURL);
    }

    public WebDriver setupLocalDriver() {
        this.setDesiredCapabilities(this.desiredCapabilities);
        return LocalDriver.createDriver(this.desiredCapabilities);
    }

    public WebDriver setupLocalDriver(Browser runLocallyBrowser, String version) {
        assert (runLocallyBrowser != null);
        DesiredCapabilities capabilities = BrowserUtil.getBrowserFactory().create(runLocallyBrowser, version);
        this.setDesiredCapabilities(capabilities);
        return LocalDriver.createDriver(capabilities);
    }

    public WebDriver setupLocalDriver(Browser runLocallyBrowser) {
        return this.setupLocalDriver(runLocallyBrowser, "");
    }

    public DesiredCapabilities getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public void setDesiredCapabilities(DesiredCapabilities desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
    }
}

