/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextFieldValidationSupport;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

@Tests(value={TextArea.class})
public class TextAreaTester<T extends TextArea>
extends ComponentTester<T> {
    public TextAreaTester(T component) {
        super(component);
    }

    public void setValue(String value) {
        this.ensureComponentIsUsable();
        if (value != null && this.hasValidation() && this.getValidationSupport().isInvalid(value)) {
            if (((TextArea)this.getComponent()).isPreventInvalidInputBoolean()) {
                throw new IllegalArgumentException("Given value doesn't pass field value validation. Check validation settings for field.");
            }
            LoggerFactory.getLogger(TextAreaTester.class).warn("Gave invalid input, but value set as invalid input is not prevented.");
        }
        ((TextArea)this.getComponent()).setValue(value);
    }

    private boolean hasValidation() {
        return this.getValidationSupport() != null;
    }

    private TextFieldValidationSupport getValidationSupport() {
        try {
            return (TextFieldValidationSupport)this.getField("validationSupport").get(this.getComponent());
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !((TextArea)this.getComponent()).isReadOnly();
    }

    @Override
    protected void notUsableReasons(Consumer<String> collector) {
        super.notUsableReasons(collector);
        if (((TextArea)this.getComponent()).isReadOnly()) {
            collector.accept("read only");
        }
    }
}

