/*
 * Decompiled with CFR 0.152.
 */
package com.viafoura.metrics.datadog.transport;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.viafoura.metrics.datadog.transport.AbstractTransportFactory;
import com.viafoura.metrics.datadog.transport.HttpTransport;
import io.dropwizard.util.Duration;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="http")
public class HttpTransportFactory
implements AbstractTransportFactory {
    @NotNull
    @JsonProperty
    private String apiKey = null;
    @JsonProperty
    private Duration connectTimeout = Duration.seconds((long)5L);
    @JsonProperty
    private Duration socketTimeout = Duration.seconds((long)5L);
    @JsonProperty
    private int proxyPort;
    @JsonProperty
    private String proxyHost;

    public HttpTransport build() {
        HttpTransport.Builder builder = new HttpTransport.Builder().withApiKey(this.apiKey).withConnectTimeout((int)this.connectTimeout.toMilliseconds()).withSocketTimeout((int)this.socketTimeout.toMilliseconds());
        if (this.proxyPort != 0 || this.proxyHost != null) {
            if (this.proxyPort == 0 || this.proxyHost == null) {
                throw new IllegalStateException("must set both proxyPort and proxyHost or neither");
            }
            builder.withProxy(this.proxyHost, this.proxyPort);
        }
        return builder.build();
    }
}

