/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.renderer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolverContext;
import com.vlkan.log4j2.logstash.layout.util.JacksonNewlineAddingPrettyPrinter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

public class TemplateRenderer {
    private final StrSubstitutor substitutor;
    private final TemplateResolverContext resolverContext;
    private final ObjectMapper objectMapper;
    private final ObjectNode templateRootNode;
    private final ObjectWriter objectWriter;
    private final Map<String, TemplateResolver> resolverByName;

    private TemplateRenderer(Builder builder) {
        this.substitutor = builder.substitutor;
        this.resolverContext = builder.resolverContext;
        this.objectMapper = this.resolverContext.getObjectMapper();
        this.objectWriter = builder.prettyPrintEnabled ? this.objectMapper.writerWithDefaultPrettyPrinter() : this.objectMapper.writer((PrettyPrinter)new JacksonNewlineAddingPrettyPrinter());
        this.templateRootNode = TemplateRenderer.readTemplate(this.objectMapper, builder.template);
        this.resolverByName = TemplateRenderer.createResolverByName(builder.resolvers);
    }

    private static ObjectNode readTemplate(ObjectMapper objectMapper, String template) {
        try {
            return (ObjectNode)objectMapper.readValue(template, ObjectNode.class);
        }
        catch (IOException error) {
            String message = String.format("failed reading template: %s", template);
            throw new RuntimeException(message, error);
        }
    }

    private static Map<String, TemplateResolver> createResolverByName(Set<TemplateResolver> resolvers) {
        HashMap<String, TemplateResolver> resolverByName = new HashMap<String, TemplateResolver>();
        for (TemplateResolver resolver : resolvers) {
            resolverByName.put(resolver.getName(), resolver);
        }
        return resolverByName;
    }

    public String render(LogEvent event) {
        return this.render(event, this.templateRootNode);
    }

    private String render(LogEvent event, ObjectNode srcRootNode) {
        JsonNode dstRootNode = this.resolveNode(event, (JsonNode)srcRootNode);
        try {
            return this.objectWriter.writeValueAsString((Object)dstRootNode);
        }
        catch (JsonProcessingException error) {
            throw new RuntimeException("failed serializing JSON", error);
        }
    }

    private JsonNode resolveNode(LogEvent event, JsonNode node) {
        JsonNodeType nodeType = node.getNodeType();
        switch (nodeType) {
            case ARRAY: {
                return this.resolveArrayNode(event, node);
            }
            case OBJECT: {
                return this.resolveObjectNode(event, node);
            }
            case STRING: {
                return this.resolveStringNode(event, node);
            }
        }
        return node;
    }

    private JsonNode resolveArrayNode(LogEvent event, JsonNode srcNode) {
        ArrayNode dstNode = this.objectMapper.createArrayNode();
        for (int nodeIndex = 0; nodeIndex < srcNode.size(); ++nodeIndex) {
            JsonNode srcChildNode = srcNode.get(nodeIndex);
            JsonNode dstChildNode = this.resolveNode(event, srcChildNode);
            if (dstChildNode == null) continue;
            dstNode.add(dstChildNode);
        }
        return dstNode.size() > 0 ? dstNode : null;
    }

    private JsonNode resolveObjectNode(LogEvent event, JsonNode srcNode) {
        ObjectNode dstNode = this.objectMapper.createObjectNode();
        Iterator srcNodeFieldIterator = srcNode.fields();
        while (srcNodeFieldIterator.hasNext()) {
            Map.Entry srcNodeField = (Map.Entry)srcNodeFieldIterator.next();
            String key = (String)srcNodeField.getKey();
            JsonNode value = (JsonNode)srcNodeField.getValue();
            JsonNode resolvedValue = this.resolveNode(event, value);
            if (resolvedValue == null) continue;
            dstNode.set(key, resolvedValue);
        }
        return dstNode.size() > 0 ? dstNode : null;
    }

    private JsonNode resolveStringNode(LogEvent event, JsonNode textNode) {
        String text = textNode.asText();
        String resolverName = TemplateRenderer.getResolverName(text);
        if (resolverName != null) {
            TemplateResolver resolver = this.resolverByName.get(resolverName);
            if (resolver != null) {
                return resolver.resolve(this.resolverContext, event);
            }
        } else {
            String replacedText = this.substitutor.replace(event, text);
            return new TextNode(replacedText);
        }
        return textNode;
    }

    private static String getResolverName(String fieldValue) {
        return fieldValue.startsWith("${json:") && fieldValue.endsWith("}") ? fieldValue.substring(7, fieldValue.length() - 1) : null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private StrSubstitutor substitutor;
        private TemplateResolverContext resolverContext;
        private boolean prettyPrintEnabled;
        private String template;
        private Set<TemplateResolver> resolvers;

        private Builder() {
        }

        public StrSubstitutor getSubstitutor() {
            return this.substitutor;
        }

        public Builder setSubstitutor(StrSubstitutor substitutor) {
            this.substitutor = substitutor;
            return this;
        }

        public TemplateResolverContext getResolverContext() {
            return this.resolverContext;
        }

        public Builder setResolverContext(TemplateResolverContext resolverContext) {
            this.resolverContext = resolverContext;
            return this;
        }

        public boolean isPrettyPrintEnabled() {
            return this.prettyPrintEnabled;
        }

        public Builder setPrettyPrintEnabled(boolean prettyPrintEnabled) {
            this.prettyPrintEnabled = prettyPrintEnabled;
            return this;
        }

        public String getTemplate() {
            return this.template;
        }

        public Builder setTemplate(String template) {
            this.template = template;
            return this;
        }

        public Set<TemplateResolver> getResolvers() {
            return this.resolvers;
        }

        public Builder setResolvers(Set<TemplateResolver> resolvers) {
            this.resolvers = resolvers;
            return this;
        }

        public TemplateRenderer build() {
            this.validate();
            return new TemplateRenderer(this);
        }

        private void validate() {
            Validate.notNull((Object)this.substitutor, (String)"substitutor", (Object[])new Object[0]);
            Validate.notNull((Object)this.resolverContext, (String)"resolverContext", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.template, (String)"template", (Object[])new Object[0]);
            Validate.notNull(this.resolvers, (String)"resolvers", (Object[])new Object[0]);
        }
    }
}

