/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolverContext;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

public class ContextDataResolver
implements TemplateResolver {
    private static final ContextDataResolver INSTANCE = new ContextDataResolver();

    private ContextDataResolver() {
    }

    public static ContextDataResolver getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "mdc";
    }

    @Override
    public JsonNode resolve(TemplateResolverContext context, LogEvent logEvent) {
        ReadOnlyStringMap contextData = logEvent.getContextData();
        if (contextData == null || contextData.isEmpty()) {
            return null;
        }
        final Pattern keyPattern = context.getMdcKeyPattern();
        final ObjectNode contextDataNode = context.getObjectMapper().createObjectNode();
        contextData.forEach((BiConsumer)new BiConsumer<String, String>(){

            public void accept(String key, String value) {
                boolean keyMatches;
                boolean bl = keyMatches = keyPattern == null || keyPattern.matcher(key).matches();
                if (keyMatches) {
                    contextDataNode.put(key, value);
                }
            }
        });
        return contextDataNode;
    }
}

