/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSRunner {
    private final ScriptableObject globalScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSRunner() {
        Context context = Context.enter();
        context.setOptimizationLevel(-1);
        try {
            this.globalScope = context.initStandardObjects();
            String[] names = new String[]{"print", "load", "readFile", "warn", "getResourceAsStream"};
            this.globalScope.defineFunctionProperties(names, JSRunner.class, 2);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evalScript(String filename) {
        if (!filename.startsWith("/")) {
            filename = "/" + filename;
        }
        InputStream inputStream = this.getClass().getResourceAsStream(filename);
        try {
            try {
                InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
                try {
                    Context context = Context.enter();
                    context.setOptimizationLevel(-1);
                    try {
                        context.evaluateReader((Scriptable)this.globalScope, (Reader)reader, filename, 0, null);
                    }
                    finally {
                        Context.exit();
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public String evalString(String scriptString) throws IOException {
        return this.evalString(scriptString, "Anonymous script", new HashMap<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evalString(String scriptString, String sourceName, Map<String, Object> objectsToPutInScope) {
        Context context = Context.enter();
        try {
            Scriptable compileScope = context.newObject((Scriptable)this.globalScope);
            compileScope.setParentScope((Scriptable)this.globalScope);
            for (String name : objectsToPutInScope.keySet()) {
                compileScope.put(name, compileScope, objectsToPutInScope.get(name));
            }
            String string = (String)context.evaluateString(compileScope, scriptString, sourceName, 0, null);
            return string;
        }
        finally {
            Context.exit();
        }
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                System.out.print(" ");
            }
            String s = Context.toString((Object)args[i]);
            System.out.print(s);
        }
        System.out.println();
    }

    public static void warn(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String message = Context.toString((Object)args[0]);
        int line = (int)Context.toNumber((Object)args[1]);
        String source = Context.toString((Object)args[2]);
        int column = (int)Context.toNumber((Object)args[3]);
        cx.getErrorReporter().warning(message, null, line, source, column);
    }

    public String readFile(String path) {
        try {
            return IOUtil.toString((InputStream)JSRunner.getResourceAsStream(path));
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new RuntimeException("wrap: " + exc.getMessage(), exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (Object element : args) {
            String filename = Context.toString((Object)element);
            InputStreamReader in = null;
            try {
                in = new InputStreamReader(JSRunner.getResourceAsStream(filename));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                cx.evaluateReader(thisObj, (Reader)in, filename, 1, null);
            }
            catch (WrappedException we) {
                System.err.println(we.getWrappedException().toString());
                we.printStackTrace();
            }
            catch (EvaluatorException ee) {
                System.err.println("js: " + ee.getMessage());
            }
            catch (JavaScriptException jse) {
                System.err.println("js: " + jse.getMessage());
            }
            catch (IOException ioe) {
                System.err.println(ioe.toString());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    System.err.println(ioe.toString());
                }
            }
        }
    }

    public static InputStream getResourceAsStream(String path) {
        File file = new File(path);
        if (file.exists()) {
            try {
                return new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        return JSRunner.class.getClassLoader().getResourceAsStream(path);
    }
}

