/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew;

import com.voltvoodoo.brew.compile.CoffeeScriptCompiler;
import com.voltvoodoo.brew.compile.FileTreeCompiler;
import com.voltvoodoo.brew.compile.HamlCompiler;
import com.voltvoodoo.brew.compile.RawCopyCompiler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMojo
extends AbstractMojo {
    private List<File> testSourceDirs;
    private File testWorkDir;
    private String[] includes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.includes == null) {
            this.includes = new String[]{"*/*Test.*", "*/Test.*"};
        }
        this.compile(this.includes, this.getTestSourceDirs(), this.testWorkDir);
        this.runTests(this.testWorkDir, this.includes);
    }

    private List<File> getTestSourceDirs() {
        return this.testSourceDirs == null ? new ArrayList() : this.testSourceDirs;
    }

    private void compile(String[] includes, List<File> sourceDirs, File outputDir) {
        FileTreeCompiler compiler = new FileTreeCompiler();
        compiler.addDefinition("**/*.coffee", new CoffeeScriptCompiler());
        compiler.addDefinition("**/*.haml", new HamlCompiler());
        compiler.addDefinition("**/*", new RawCopyCompiler());
        compiler.compile(sourceDirs, outputDir);
    }

    private void runTests(File workDir, String[] includes) {
        DirectoryScanner scanner = new DirectoryScanner();
        if (!workDir.exists()) {
            workDir.mkdirs();
        }
        scanner.setBasedir(workDir);
        scanner.setIncludes(includes);
        scanner.scan();
        for (String path : scanner.getIncludedFiles()) {
            System.out.println(path);
        }
    }
}

