/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew.compile;

import com.voltvoodoo.brew.compile.CoffeeScriptCompileException;
import com.voltvoodoo.brew.compile.CoffeeScriptOption;
import com.voltvoodoo.brew.compile.CoffeeScriptOptions;
import com.voltvoodoo.brew.compile.Compiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoffeeScriptCompiler
implements Compiler {
    private final Scriptable globalScope;
    private final CoffeeScriptOptions options;

    public CoffeeScriptCompiler() {
        this(Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoffeeScriptCompiler(Collection<CoffeeScriptOption> options) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/jcoffeescript/coffee-script.js");
        try {
            try {
                InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
                try {
                    Context context = Context.enter();
                    context.setOptimizationLevel(-1);
                    try {
                        this.globalScope = context.initStandardObjects();
                        context.evaluateReader(this.globalScope, (Reader)reader, "coffee-script.js", 0, null);
                    }
                    finally {
                        Context.exit();
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        this.options = new CoffeeScriptOptions(options);
    }

    public String compile(String coffeeScriptSource) {
        Context context = Context.enter();
        try {
            Scriptable compileScope = context.newObject(this.globalScope);
            compileScope.setParentScope(this.globalScope);
            compileScope.put("coffeeScriptSource", compileScope, (Object)coffeeScriptSource);
            try {
                String string = (String)context.evaluateString(compileScope, String.format("CoffeeScript.compile(coffeeScriptSource, %s);", this.options.toJavaScript()), "JCoffeeScriptCompiler", 0, null);
                return string;
            }
            catch (JavaScriptException e) {
                throw new CoffeeScriptCompileException(e);
            }
        }
        finally {
            Context.exit();
        }
    }

    public void compile(File source, File target) throws CoffeeScriptCompileException, IOException {
        if (target.exists()) {
            target.delete();
        }
        target.getParentFile().mkdirs();
        target.createNewFile();
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        String compiled = this.compile(IOUtil.toString((InputStream)in));
        IOUtil.copy((String)compiled, (OutputStream)out);
        in.close();
        out.close();
    }

    @Override
    public void compile(List<String> files, File sourceDir, File targetDir) {
        try {
            for (String path : files) {
                String newPath = path.substring(0, path.lastIndexOf(46)) + ".js";
                this.compile(new File(sourceDir, path), new File(targetDir, newPath));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

