/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew.compile;

import com.google.common.collect.Lists;
import com.voltvoodoo.brew.compile.Compiler;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTreeCompiler {
    Map<String, Compiler> compilers = new TreeMap<String, Compiler>();

    public void addDefinition(String filePattern, Compiler compiler) {
        this.compilers.put(filePattern, compiler);
    }

    public void compile(List<File> sourceDirs, File outputDir) {
        for (String pattern : this.compilers.keySet()) {
            for (File sourceDir : sourceDirs) {
                this.compile(pattern, sourceDir, outputDir, this.compilers.get(pattern));
            }
        }
    }

    private void compile(String pattern, File sourceDir, File outputDir, Compiler compiler) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setIncludes(new String[]{pattern});
        scanner.scan();
        compiler.compile(Lists.newArrayList((Object[])scanner.getIncludedFiles()), sourceDir, outputDir);
    }
}

