/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class AccessorVisibilityChecker {
    private final Map<PropertyAccessor, JsonAutoDetect.Visibility> minLevels;
    public static final JsonAutoDetect DEFAULT_VISIBILITY = VisibilityChecker.Std.class.getAnnotation(JsonAutoDetect.class);
    public static final AccessorVisibilityChecker DEFAULT_CHECKER = new AccessorVisibilityChecker(DEFAULT_VISIBILITY);

    private AccessorVisibilityChecker(Map<PropertyAccessor, JsonAutoDetect.Visibility> minLevels) {
        this.minLevels = minLevels;
    }

    public AccessorVisibilityChecker(JsonAutoDetect annotation) {
        this(AccessorVisibilityChecker.createMap(annotation.getterVisibility(), annotation.isGetterVisibility(), annotation.setterVisibility(), annotation.creatorVisibility(), annotation.fieldVisibility()));
    }

    public AccessorVisibilityChecker with(JsonAutoDetect annotation) {
        return new AccessorVisibilityChecker(AccessorVisibilityChecker.createMap((annotation.getterVisibility() == JsonAutoDetect.Visibility.DEFAULT ? DEFAULT_VISIBILITY : annotation).getterVisibility(), (annotation.isGetterVisibility() == JsonAutoDetect.Visibility.DEFAULT ? DEFAULT_VISIBILITY : annotation).isGetterVisibility(), (annotation.setterVisibility() == JsonAutoDetect.Visibility.DEFAULT ? DEFAULT_VISIBILITY : annotation).setterVisibility(), (annotation.creatorVisibility() == JsonAutoDetect.Visibility.DEFAULT ? DEFAULT_VISIBILITY : annotation).creatorVisibility(), (annotation.fieldVisibility() == JsonAutoDetect.Visibility.DEFAULT ? DEFAULT_VISIBILITY : annotation).fieldVisibility()));
    }

    public AccessorVisibilityChecker withVisibility(PropertyAccessor method, JsonAutoDetect.Visibility level) {
        return new AccessorVisibilityChecker(AccessorVisibilityChecker.changeMap(this.minLevels, method, level));
    }

    public JsonAutoDetect.Visibility getVisibility(PropertyAccessor method) {
        return this.minLevels.get(method);
    }

    private static Map<PropertyAccessor, JsonAutoDetect.Visibility> createMap(JsonAutoDetect.Visibility getterLevel, JsonAutoDetect.Visibility isGetterLevel, JsonAutoDetect.Visibility setterLevel, JsonAutoDetect.Visibility creatorLevel, JsonAutoDetect.Visibility fieldLevel) {
        EnumMap<PropertyAccessor, JsonAutoDetect.Visibility> levels = new EnumMap<PropertyAccessor, JsonAutoDetect.Visibility>(PropertyAccessor.class);
        levels.put(PropertyAccessor.GETTER, getterLevel);
        levels.put(PropertyAccessor.IS_GETTER, isGetterLevel);
        levels.put(PropertyAccessor.SETTER, setterLevel);
        levels.put(PropertyAccessor.CREATOR, creatorLevel);
        levels.put(PropertyAccessor.FIELD, fieldLevel);
        return Collections.unmodifiableMap(levels);
    }

    private static Map<PropertyAccessor, JsonAutoDetect.Visibility> changeMap(Map<PropertyAccessor, JsonAutoDetect.Visibility> original, PropertyAccessor method, JsonAutoDetect.Visibility level) {
        EnumMap<PropertyAccessor, JsonAutoDetect.Visibility> levels = new EnumMap<PropertyAccessor, JsonAutoDetect.Visibility>(PropertyAccessor.class);
        if (method == PropertyAccessor.ALL) {
            return AccessorVisibilityChecker.createMap(level, level, level, level, level);
        }
        levels.putAll(original);
        levels.put(method, level);
        return Collections.unmodifiableMap(levels);
    }
}

