/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.defaultimpl;

import com.onlinepayments.Authenticator;
import com.onlinepayments.CallContext;
import com.onlinepayments.CommunicationException;
import com.onlinepayments.Communicator;
import com.onlinepayments.Connection;
import com.onlinepayments.Marshaller;
import com.onlinepayments.MetaDataProvider;
import com.onlinepayments.MultipartFormDataObject;
import com.onlinepayments.MultipartFormDataRequest;
import com.onlinepayments.NotFoundException;
import com.onlinepayments.ParamRequest;
import com.onlinepayments.PooledConnection;
import com.onlinepayments.RequestHeader;
import com.onlinepayments.RequestParam;
import com.onlinepayments.ResponseException;
import com.onlinepayments.ResponseHandler;
import com.onlinepayments.ResponseHeader;
import com.onlinepayments.logging.CommunicatorLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.utils.URIBuilder;

public class DefaultCommunicator
implements Communicator {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final URI apiEndpoint;
    private final Connection connection;
    private final Authenticator authenticator;
    private final MetaDataProvider metaDataProvider;
    private final Marshaller marshaller;

    public DefaultCommunicator(URI apiEndpoint, Connection connection, Authenticator authenticator, MetaDataProvider metaDataProvider, Marshaller marshaller) {
        if (apiEndpoint == null) {
            throw new IllegalArgumentException("apiEndpoint is required");
        }
        if (apiEndpoint.getPath() != null && !apiEndpoint.getPath().isEmpty()) {
            throw new IllegalArgumentException("apiEndpoint should not contain a path");
        }
        if (apiEndpoint.getUserInfo() != null || apiEndpoint.getQuery() != null || apiEndpoint.getFragment() != null) {
            throw new IllegalArgumentException("apiEndpoint should not contain user info, query or fragment");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection is required");
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("authenticator is required");
        }
        if (metaDataProvider == null) {
            throw new IllegalArgumentException("metaDataProvider is required");
        }
        if (marshaller == null) {
            throw new IllegalArgumentException("marshaller is required");
        }
        this.apiEndpoint = apiEndpoint;
        this.connection = connection;
        this.authenticator = authenticator;
        this.metaDataProvider = metaDataProvider;
        this.marshaller = marshaller;
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    @Override
    public <O> O get(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, Class<O> responseType, CallContext context) {
        List<RequestParam> requestParameterList = requestParameters == null ? null : requestParameters.toRequestParameters();
        URI uri = this.toAbsoluteURI(relativePath, requestParameterList);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        this.addGenericHeaders("GET", uri, requestHeaders, context);
        return this.connection.get(uri, requestHeaders, this.getDefaultResponseHandler(relativePath, responseType, context));
    }

    @Override
    public <O> O delete(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, Class<O> responseType, CallContext context) {
        List<RequestParam> requestParameterList = requestParameters == null ? null : requestParameters.toRequestParameters();
        URI uri = this.toAbsoluteURI(relativePath, requestParameterList);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        this.addGenericHeaders("DELETE", uri, requestHeaders, context);
        return this.connection.delete(uri, requestHeaders, this.getDefaultResponseHandler(relativePath, responseType, context));
    }

    @Override
    public <O> O post(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, Object requestBody, Class<O> responseType, CallContext context) {
        if (requestBody instanceof MultipartFormDataObject) {
            return this.post(relativePath, requestHeaders, requestParameters, (MultipartFormDataObject)requestBody, responseType, context);
        }
        if (requestBody instanceof MultipartFormDataRequest) {
            MultipartFormDataObject multipart = ((MultipartFormDataRequest)requestBody).toMultipartFormDataObject();
            return this.post(relativePath, requestHeaders, requestParameters, multipart, responseType, context);
        }
        List<RequestParam> requestParameterList = requestParameters == null ? null : requestParameters.toRequestParameters();
        URI uri = this.toAbsoluteURI(relativePath, requestParameterList);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        String requestJson = this.prepareBody(requestHeaders, requestBody);
        this.addGenericHeaders("POST", uri, requestHeaders, context);
        return this.connection.post(uri, requestHeaders, requestJson, this.getDefaultResponseHandler(relativePath, responseType, context));
    }

    private <O> O post(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, MultipartFormDataObject multipart, Class<O> responseType, CallContext context) {
        List<RequestParam> requestParameterList = requestParameters == null ? null : requestParameters.toRequestParameters();
        URI uri = this.toAbsoluteURI(relativePath, requestParameterList);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        requestHeaders.add(new RequestHeader("Content-Type", multipart.getContentType()));
        this.addGenericHeaders("POST", uri, requestHeaders, context);
        return this.connection.post(uri, requestHeaders, multipart, this.getDefaultResponseHandler(relativePath, responseType, context));
    }

    @Override
    public <O> O put(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, Object requestBody, Class<O> responseType, CallContext context) {
        List<RequestParam> requestParameterList = requestParameters == null ? null : requestParameters.toRequestParameters();
        URI uri = this.toAbsoluteURI(relativePath, requestParameterList);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        String requestJson = this.prepareBody(requestHeaders, requestBody);
        this.addGenericHeaders("PUT", uri, requestHeaders, context);
        return this.connection.put(uri, requestHeaders, requestJson, this.getDefaultResponseHandler(relativePath, responseType, context));
    }

    public URI getApiEndpoint() {
        return this.apiEndpoint;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public MetaDataProvider getMetaDataProvider() {
        return this.metaDataProvider;
    }

    @Override
    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    protected URI toAbsoluteURI(String relativePath, List<RequestParam> requestParameters) {
        if (this.apiEndpoint.getPath() != null && !this.apiEndpoint.getPath().isEmpty()) {
            throw new IllegalStateException("apiEndpoint should not contain a path");
        }
        if (this.apiEndpoint.getUserInfo() != null || this.apiEndpoint.getQuery() != null || this.apiEndpoint.getFragment() != null) {
            throw new IllegalStateException("apiEndpoint should not contain user info, query or fragment");
        }
        String absolutePath = relativePath.startsWith("/") ? relativePath : "/" + relativePath;
        URIBuilder uriBuilder = new URIBuilder().setScheme(this.apiEndpoint.getScheme()).setHost(this.apiEndpoint.getHost()).setPort(this.apiEndpoint.getPort()).setPath(absolutePath);
        if (requestParameters != null) {
            for (RequestParam nvp : requestParameters) {
                uriBuilder.addParameter(nvp.getName(), nvp.getValue());
            }
        }
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to construct URI", e);
        }
    }

    private String prepareBody(List<RequestHeader> requestHeaders, Object requestBody) {
        String requestJson = null;
        if (requestBody != null) {
            requestHeaders.add(new RequestHeader("Content-Type", "application/json"));
            requestJson = this.marshaller.marshal(requestBody);
        }
        return requestJson;
    }

    protected void addGenericHeaders(String httpMethod, URI uri, List<RequestHeader> requestHeaders, CallContext context) {
        requestHeaders.addAll(this.metaDataProvider.getServerMetaDataHeaders());
        requestHeaders.add(new RequestHeader("Date", this.getHeaderDateString()));
        if (context != null && context.getIdempotenceKey() != null) {
            requestHeaders.add(new RequestHeader("X-GCS-Idempotence-Key", context.getIdempotenceKey()));
        }
        String authenticationSignature = this.authenticator.createSimpleAuthenticationSignature(httpMethod, uri, requestHeaders);
        requestHeaders.add(new RequestHeader("Authorization", authenticationSignature));
    }

    protected String getHeaderDateString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(calendar.getTime());
    }

    private <O> ResponseHandler<O> getDefaultResponseHandler(final String relativePath, final Class<O> responseType, final CallContext context) {
        return new ResponseHandler<O>(){

            @Override
            public O handleResponse(int statusCode, InputStream bodyStream, List<ResponseHeader> headers) {
                return DefaultCommunicator.this.processResponse(statusCode, bodyStream, headers, responseType, relativePath, context);
            }
        };
    }

    protected <O> O processResponse(int statusCode, InputStream bodyStream, List<ResponseHeader> headers, Class<O> responseType, String requestPath, CallContext context) {
        if (context != null) {
            this.updateContext(headers, context);
        }
        this.throwExceptionIfNecessary(statusCode, bodyStream, headers, requestPath);
        return this.marshaller.unmarshal(bodyStream, responseType);
    }

    protected void updateContext(List<ResponseHeader> headers, CallContext context) {
        String idempotenceRequestTimestampValue = ResponseHeader.getHeaderValue(headers, "X-GCS-Idempotence-Request-Timestamp");
        if (idempotenceRequestTimestampValue != null) {
            Long idempotenceRequestTimestamp = Long.valueOf(idempotenceRequestTimestampValue);
            context.setIdempotenceRequestTimestamp(idempotenceRequestTimestamp);
        } else {
            context.setIdempotenceRequestTimestamp(null);
        }
    }

    protected void throwExceptionIfNecessary(int statusCode, InputStream bodyStream, List<ResponseHeader> headers, String requestPath) {
        if (statusCode < 200 || statusCode >= 300) {
            String body = this.toString(bodyStream);
            if (!body.isEmpty() && !this.isJson(headers)) {
                ResponseException cause = new ResponseException(statusCode, body, headers);
                if (statusCode == 404) {
                    throw new NotFoundException("The requested resource was not found; invalid path: " + requestPath, cause);
                }
                throw new CommunicationException(cause);
            }
            throw new ResponseException(statusCode, body, headers);
        }
    }

    private String toString(InputStream bodyStream) {
        try {
            int len;
            InputStreamReader reader = new InputStreamReader(bodyStream, CHARSET);
            StringBuilder body = new StringBuilder();
            char[] buffer = new char[4096];
            while ((len = reader.read(buffer)) != -1) {
                body.append(buffer, 0, len);
            }
            return body.toString();
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    private boolean isJson(List<ResponseHeader> headers) {
        String contentType = ResponseHeader.getHeaderValue(headers, "Content-Type");
        return contentType == null || "application/json".equalsIgnoreCase(contentType) || contentType.toLowerCase().startsWith("application/json");
    }

    @Override
    public void closeIdleConnections(long idleTime, TimeUnit timeUnit) {
        if (this.connection instanceof PooledConnection) {
            ((PooledConnection)this.connection).closeIdleConnections(idleTime, timeUnit);
        }
    }

    @Override
    public void closeExpiredConnections() {
        if (this.connection instanceof PooledConnection) {
            ((PooledConnection)this.connection).closeExpiredConnections();
        }
    }

    @Override
    public void enableLogging(CommunicatorLogger communicatorLogger) {
        this.connection.enableLogging(communicatorLogger);
    }

    @Override
    public void disableLogging() {
        this.connection.disableLogging();
    }
}

