/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.hostedtokenization;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ResponseException;
import com.onlinepayments.domain.CreateHostedTokenizationRequest;
import com.onlinepayments.domain.CreateHostedTokenizationResponse;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.GetHostedTokenizationResponse;
import com.onlinepayments.merchant.hostedtokenization.HostedTokenizationClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class HostedTokenizationClient
extends ApiResource
implements HostedTokenizationClientInterface {
    public HostedTokenizationClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public CreateHostedTokenizationResponse createHostedTokenization(CreateHostedTokenizationRequest body) {
        return this.createHostedTokenization(body, null);
    }

    @Override
    public CreateHostedTokenizationResponse createHostedTokenization(CreateHostedTokenizationRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/hostedtokenizations", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, CreateHostedTokenizationResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public GetHostedTokenizationResponse getHostedTokenization(String hostedTokenizationId) {
        return this.getHostedTokenization(hostedTokenizationId, null);
    }

    @Override
    public GetHostedTokenizationResponse getHostedTokenization(String hostedTokenizationId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("hostedTokenizationId", hostedTokenizationId);
        String uri = this.instantiateUri("/v2/{merchantId}/hostedtokenizations/{hostedTokenizationId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, GetHostedTokenizationResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

