/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import org.cheffo.jeplite.JEP;
import org.cheffo.jeplite.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Calc {
    public static void main(String[] args) {
        String expr = "2 + 2 * x";
        String[] varnames = new String[]{"x"};
        String[] varvalues = new String[]{"20"};
        System.out.println(Calc.evalExpression(expr, "0", varnames, varvalues));
        System.out.println(Calc.evalExpression("sin(pi)", "0.00", null, null));
        expr = "(2 + 2 * x^x) % 2";
        System.out.println(Calc.evalExpression(expr, null, varnames, varvalues));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", "20");
        map.put("b", "30");
        String calcString = "\"$x * 3 + $y * 40\",\"%.2f\",~a,~b";
        System.out.println(Calc.evalCalc(calcString, map));
        calcString = "\"$x * $x\",\"%.2f\",~a,~b";
        System.out.println(Calc.evalCalc(calcString, map));
        calcString = "\"$x + $y\",\"%.2f\",$a,$b";
        System.out.println(Calc.evalCalc(calcString, map));
        map.put("c", "40");
        calcString = "\"$x + $y + $z\",$a,$b,$c";
        System.out.println(Calc.evalCalc(calcString, map));
    }

    public static String evalCalc(String calc, Map<String, Object> vars) {
        int quote4;
        int quote1 = calc.indexOf("\"");
        if (quote1 < 0) {
            return null;
        }
        int quote2 = calc.indexOf("\"", quote1 + 1);
        if (quote2 < 0) {
            return null;
        }
        String expr = calc.substring(quote1 + 1, quote2);
        int argStart = quote2 + 1;
        String fmt = null;
        int quote3 = calc.indexOf("\"", quote2 + 1);
        if (quote3 > 0 && (quote4 = calc.indexOf("\"", quote3 + 1)) > 0) {
            fmt = calc.substring(quote3 + 1, quote4);
            argStart = quote4 + 1;
        }
        String[] varNames = Calc.parseVarNames(expr);
        String[] varValues = null;
        String jepExpr = expr;
        if (varNames != null) {
            int closeParen;
            jepExpr = jepExpr.replaceAll("\\$", "V");
            int comma = calc.indexOf(",", argStart);
            if (comma > 0) {
                argStart = comma + 1;
            }
            if ((closeParen = calc.indexOf(")", argStart)) < 0) {
                closeParen = calc.length();
            }
            varValues = Calc.grokVarValues(calc.substring(argStart, closeParen), vars);
        }
        try {
            return Calc.evalExpression(jepExpr, fmt, varNames, varValues);
        }
        catch (NumberFormatException e) {
            StringBuilder input = new StringBuilder();
            if (varValues != null) {
                for (int i = 0; i < varValues.length; ++i) {
                    if (i > 0) {
                        input.append(",");
                    }
                    input.append((String)varValues[i]);
                }
            }
            return "[error evaluating expression - '" + expr + "' - input (" + input + ") must be numeric]";
        }
    }

    private static String[] grokVarValues(String list, Map<String, Object> vars) {
        String[] tokens = list.split(",");
        if (tokens == null) {
            return null;
        }
        String[] values = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            Object value;
            String key = tokens[i];
            if ((key = key.trim()).startsWith("~") || key.startsWith("$")) {
                key = key.substring(1);
            }
            if (!((value = vars.get(key)) instanceof String)) continue;
            values[i] = (String)value;
        }
        return values;
    }

    private static String[] parseVarNames(String expr) {
        String[] varNames = null;
        ArrayList<String> names = null;
        int varMarker = expr.indexOf("$");
        while (varMarker > -1) {
            String name;
            int endOfName = varMarker + 1;
            char c = expr.charAt(endOfName);
            while (Calc.isLegalNameChar(c) && ++endOfName < expr.length()) {
                c = expr.charAt(endOfName);
            }
            if (names == null) {
                names = new ArrayList<String>();
            }
            if (!names.contains(name = "V" + expr.substring(varMarker + 1, endOfName))) {
                names.add(name);
            }
            varMarker = expr.indexOf("$", endOfName);
        }
        if (names == null || names.size() == 0) {
            return null;
        }
        varNames = new String[names.size()];
        return names.toArray(varNames);
    }

    private static boolean isLegalNameChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c == '_') {
            return true;
        }
        return c >= '0' && c <= '9';
    }

    public static String evalExpression(String expr, String fmt, String[] varNames, String[] varValues) {
        JEP jep = new JEP();
        jep.addStandardConstants();
        jep.addStandardFunctions();
        if (varNames != null && varValues != null && varNames.length <= varValues.length) {
            for (int i = 0; i < varNames.length; ++i) {
                String var = varNames[i];
                if (var == null) continue;
                String val = varValues[i];
                double v = 0.0;
                if (val != null) {
                    v = Double.parseDouble(val);
                }
                jep.addVariable(var, v);
            }
        }
        try {
            jep.parseExpression(expr);
            double result = jep.getValue();
            if (fmt == null) {
                return Double.toString(result);
            }
            try {
                if (fmt.startsWith("%")) {
                    return String.format(fmt, result);
                }
                DecimalFormat formatter = new DecimalFormat(fmt);
                return formatter.format(result);
            }
            catch (NumberFormatException e) {
                return Double.toString(result);
            }
            catch (IllegalFormatException e) {
                return Double.toString(result);
            }
        }
        catch (ParseException e) {
            e.printStackTrace(System.err);
            return e.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return e.getMessage();
        }
    }
}

