/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.pherialize;

import de.ailis.pherialize.MixedArray;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class Mixed
implements Serializable,
Comparable<Object> {
    private static final long serialVersionUID = -599069055376420973L;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_CHAR = 0;
    public static final int TYPE_BYTE = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_LONG = 4;
    public static final int TYPE_FLOAT = 5;
    public static final int TYPE_DOUBLE = 6;
    public static final int TYPE_BOOLEAN = 7;
    public static final int TYPE_STRING = 8;
    public static final int TYPE_ARRAY = 9;
    private Object value;
    private final int type;

    public Mixed(Object value) {
        this.type = Mixed.getTypeOf(value);
        switch (this.type) {
            case 8: {
                this.value = value.toString();
                break;
            }
            case 9: {
                if (value instanceof MixedArray) {
                    this.value = value;
                    break;
                }
                if (value instanceof List) {
                    this.value = new MixedArray((List)value);
                    break;
                }
                this.value = new MixedArray((Map<?, ?>)((Map)value));
                break;
            }
            default: {
                this.value = value;
            }
        }
    }

    public Mixed(char value) {
        this.value = Character.valueOf(value);
        this.type = 0;
    }

    public Mixed(byte value) {
        this.value = value;
        this.type = 1;
    }

    public Mixed(short value) {
        this.value = value;
        this.type = 2;
    }

    public Mixed(int value) {
        this.value = value;
        this.type = 3;
    }

    public Mixed(long value) {
        this.value = value;
        this.type = 4;
    }

    public Mixed(float value) {
        this.value = Float.valueOf(value);
        this.type = 5;
    }

    public Mixed(double value) {
        this.value = value;
        this.type = 6;
    }

    public Mixed(boolean value) {
        this.value = value;
        this.type = 7;
    }

    public static int getTypeOf(Object value) {
        if (value instanceof String || value != null && value.getClass().isEnum()) {
            return 8;
        }
        if (value instanceof Integer) {
            return 3;
        }
        if (value instanceof List) {
            return 9;
        }
        if (value instanceof Map) {
            return 9;
        }
        if (value instanceof Character) {
            return 0;
        }
        if (value instanceof Byte) {
            return 1;
        }
        if (value instanceof Short) {
            return 2;
        }
        if (value instanceof Integer) {
            return 3;
        }
        if (value instanceof Long) {
            return 4;
        }
        if (value instanceof Float) {
            return 5;
        }
        if (value instanceof Double) {
            return 6;
        }
        if (value instanceof Boolean) {
            return 7;
        }
        return -1;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof Mixed) {
            return this.toString().equals(other.toString());
        }
        return this.toString().equals(other.toString());
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public Object toType(int type) {
        if (this.type == type) {
            return this.value;
        }
        switch (type) {
            case 7: {
                return this.toBoolean();
            }
            case 1: {
                return this.toByte();
            }
            case 0: {
                return Character.valueOf(this.toChar());
            }
            case 6: {
                return (double)this.toFloat();
            }
            case 5: {
                return Float.valueOf(this.toFloat());
            }
            case 3: {
                return this.toInt();
            }
            case 4: {
                return this.toLong();
            }
            case 9: {
                return this.toArray();
            }
            case 2: {
                return this.toShort();
            }
            case 8: {
                return this.toString();
            }
        }
        return this.value;
    }

    public char toChar() {
        if (this.value == null) {
            return '\u0000';
        }
        if (this.isArray()) {
            return (char)(((MixedArray)this.value).size() != 0 ? 1 : 0);
        }
        if (this.toString().length() > 0) {
            return this.toString().charAt(0);
        }
        return '\u0000';
    }

    public short toShort() {
        if (this.value == null) {
            return 0;
        }
        if (this.isBoolean()) {
            return this.toBoolean() ? (short)1 : 0;
        }
        if (this.isArray()) {
            return (short)(((MixedArray)this.value).size() != 0 ? 1 : 0);
        }
        try {
            return (short)this.toLong();
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public byte toByte() {
        if (this.value == null) {
            return 0;
        }
        if (this.isBoolean()) {
            return this.toBoolean() ? (byte)1 : 0;
        }
        if (this.isArray()) {
            return (byte)(((MixedArray)this.value).size() != 0 ? 1 : 0);
        }
        try {
            return (byte)this.toLong();
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int toInt() {
        if (this.value == null) {
            return 0;
        }
        if (this.isBoolean()) {
            return this.toBoolean() ? 1 : 0;
        }
        if (this.isArray()) {
            return ((MixedArray)this.value).size() == 0 ? 0 : 1;
        }
        try {
            return (int)this.toLong();
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public long toLong() {
        if (this.value == null) {
            return 0L;
        }
        if (this.isBoolean()) {
            return this.toBoolean() ? 1L : 0L;
        }
        if (this.isArray()) {
            return ((MixedArray)this.value).size() == 0 ? 0L : 1L;
        }
        try {
            return (long)this.toDouble();
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public float toFloat() {
        if (this.value == null) {
            return 0.0f;
        }
        if (this.isBoolean()) {
            return this.toBoolean() ? 1.0f : 0.0f;
        }
        if (this.isArray()) {
            return ((MixedArray)this.value).size() == 0 ? 0.0f : 1.0f;
        }
        try {
            return Float.parseFloat(this.value.toString());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public MixedArray toArray() {
        if (this.value == null) {
            return null;
        }
        if (this.isArray()) {
            return (MixedArray)this.value;
        }
        return null;
    }

    public double toDouble() {
        if (this.value == null) {
            return 0.0;
        }
        if (this.isBoolean()) {
            return this.toBoolean() ? 1.0 : 0.0;
        }
        if (this.isArray()) {
            return ((MixedArray)this.value).size() == 0 ? 0.0 : 1.0;
        }
        try {
            return Double.parseDouble(this.value.toString());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public boolean toBoolean() {
        if (this.value == null) {
            return false;
        }
        if (this.isBoolean()) {
            return (Boolean)this.value;
        }
        if (this.isString()) {
            return this.toString().length() > 0;
        }
        if (this.isNumber()) {
            return this.toDouble() != 0.0;
        }
        if (this.isChar()) {
            return this.toChar() != '\u0000';
        }
        if (this.isArray()) {
            return this.toArray().size() > 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object other) {
        if (other instanceof Mixed) {
            return ((Comparable)this.value).compareTo(((Mixed)other).value);
        }
        return ((Comparable)this.value).compareTo(other);
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isChar() {
        return this.type == 0;
    }

    public boolean isByte() {
        return this.type == 1;
    }

    public boolean isShort() {
        return this.type == 2;
    }

    public boolean isInt() {
        return this.type == 3;
    }

    public boolean isLong() {
        return this.type == 4;
    }

    public boolean isFloat() {
        return this.type == 5;
    }

    public boolean isDouble() {
        return this.type == 6;
    }

    public boolean isBoolean() {
        return this.type == 7;
    }

    public boolean isNumber() {
        return this.isFloat() || this.isDouble() || this.isByte() || this.isShort() || this.isInt() || this.isLong();
    }

    public boolean isString() {
        return this.type == 8;
    }

    public boolean isArray() {
        return this.type == 9;
    }
}

