/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.pherialize;

import de.ailis.pherialize.Mixed;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MixedArray
extends LinkedHashMap<Object, Object> {
    private static final long serialVersionUID = -194078593900457504L;

    public MixedArray(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public MixedArray(int initialCapacity) {
        super(initialCapacity);
    }

    public MixedArray() {
    }

    public MixedArray(Map<?, ?> map) {
        super(map);
    }

    public MixedArray(Collection<?> list) {
        int i = 0;
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.put(new Mixed(i), iterator.next());
            ++i;
        }
    }

    @Override
    public Object get(Object key) {
        if (key instanceof Mixed) {
            return super.get(key);
        }
        return super.get(new Mixed(key));
    }

    public Mixed getMixed(Object key) {
        return (Mixed)this.get(key);
    }

    public String getString(Object key) {
        return this.getMixed(key).toString();
    }

    public boolean getBooolean(Object key) {
        return this.getMixed(key).toBoolean();
    }

    public byte getByte(Object key) {
        return this.getMixed(key).toByte();
    }

    public char getChar(Object key) {
        return this.getMixed(key).toChar();
    }

    public double getDouble(Object key) {
        return this.getMixed(key).toDouble();
    }

    public float getFloat(Object key) {
        return this.getMixed(key).toFloat();
    }

    public int getInt(Object key) {
        return this.getMixed(key).toInt();
    }

    public boolean getBoolean(Object key) {
        return this.getMixed(key).toBoolean();
    }

    public MixedArray getArray(Object key) {
        return this.getMixed(key).toArray();
    }

    public long getLong(Object key) {
        return this.getMixed(key).toLong();
    }

    public short getShort(Object key) {
        return this.getMixed(key).toShort();
    }

    public Object getType(Object key, int type) {
        return this.getMixed(key).toType(type);
    }

    @Override
    public Object put(Object key, Object value) {
        Mixed mixedKey = !(key instanceof Mixed) ? new Mixed(key) : (Mixed)key;
        Mixed mixedValue = !(value instanceof Mixed) ? new Mixed(value) : (Mixed)value;
        return super.put(mixedKey, mixedValue);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Mixed) {
            return super.containsKey(key);
        }
        return super.containsKey(new Mixed(key));
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Mixed) {
            return super.containsValue(value);
        }
        return super.containsValue(new Mixed(value));
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof Mixed) {
            return super.remove(key);
        }
        return super.remove(new Mixed(key));
    }

    public Object get(int index) {
        return this.get(new Mixed(index));
    }

    public Mixed getMixed(int index) {
        return (Mixed)this.get(index);
    }

    public String getString(int index) {
        return this.getMixed(index).toString();
    }

    public boolean getBooolean(int index) {
        return this.getMixed(index).toBoolean();
    }

    public byte getByte(int index) {
        return this.getMixed(index).toByte();
    }

    public char getChar(int index) {
        return this.getMixed(index).toChar();
    }

    public double getDouble(int index) {
        return this.getMixed(index).toDouble();
    }

    public float getFloat(int index) {
        return this.getMixed(index).toFloat();
    }

    public int getInt(int index) {
        return this.getMixed(index).toInt();
    }

    public boolean getBoolean(int index) {
        return this.getMixed(index).toBoolean();
    }

    public MixedArray getArray(int index) {
        return this.getMixed(index).toArray();
    }

    public long getLong(int index) {
        return this.getMixed(index).toLong();
    }

    public short getShort(int index) {
        return this.getMixed(index).toShort();
    }

    public Object getType(int index, int type) {
        return this.getMixed(index).toType(type);
    }
}

