/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.security.checks.prefab;

import com.yahoo.elide.security.ChangeSpec;
import com.yahoo.elide.security.RequestScope;
import com.yahoo.elide.security.checks.CommitCheck;
import java.util.Collection;
import java.util.Optional;

public class Collections {
    private Collections() {
    }

    private static boolean collectionIsSuperset(Collection<?> baseCollection, Collection<?> potentialSuperset) {
        return potentialSuperset.size() >= baseCollection.size() && potentialSuperset.containsAll(baseCollection);
    }

    private static boolean changeSpecIsCollection(Optional<ChangeSpec> changeSpec) {
        return changeSpec.isPresent() && changeSpec.get().getModified() instanceof Collection;
    }

    public static class RemoveOnly<T>
    extends CommitCheck<T> {
        @Override
        public boolean ok(T record, RequestScope requestScope, Optional<ChangeSpec> changeSpec) {
            if (!Collections.changeSpecIsCollection(changeSpec)) {
                return false;
            }
            Collection originalCollection = (Collection)changeSpec.get().getOriginal();
            Collection modifiedCollection = (Collection)changeSpec.get().getModified();
            return Collections.collectionIsSuperset(modifiedCollection, originalCollection);
        }
    }

    public static class AppendOnly<T>
    extends CommitCheck<T> {
        @Override
        public boolean ok(T record, RequestScope requestScope, Optional<ChangeSpec> changeSpec) {
            if (!Collections.changeSpecIsCollection(changeSpec)) {
                return false;
            }
            Collection originalCollection = (Collection)changeSpec.get().getOriginal();
            Collection modifiedCollection = (Collection)changeSpec.get().getModified();
            return Collections.collectionIsSuperset(originalCollection, modifiedCollection);
        }
    }
}

