/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.export.formatter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.opendevl.JFlat;
import com.yahoo.elide.Elide;
import com.yahoo.elide.async.export.formatter.JSONExportFormatter;
import com.yahoo.elide.async.export.formatter.TableExportFormatter;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.EntityProjection;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVExportFormatter
implements TableExportFormatter {
    private static final Logger log = LoggerFactory.getLogger(CSVExportFormatter.class);
    private static final String COMMA = ",";
    private static final String DOUBLE_QUOTES = "\"";
    private boolean skipCSVHeader = false;
    private ObjectMapper mapper;

    public CSVExportFormatter(Elide elide, boolean skipCSVHeader) {
        this.skipCSVHeader = skipCSVHeader;
        this.mapper = elide.getMapper().getObjectMapper();
    }

    @Override
    public String format(PersistentResource resource, Integer recordNumber) {
        if (resource == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        try {
            String jsonStr = JSONExportFormatter.resourceToJSON(this.mapper, resource);
            JFlat flat = new JFlat(jsonStr);
            List json2Csv = flat.json2Sheet().headerSeparator("_").getJsonAsSheet();
            int index = 0;
            for (Object[] obj : json2Csv) {
                if (index++ == 0) continue;
                String objString = Arrays.toString(obj);
                objString = objString.substring(1, objString.length() - 1);
                str.append(objString);
            }
        }
        catch (Exception e) {
            log.error("Exception while converting to CSV: {}", (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
        return str.toString();
    }

    private String generateCSVHeader(EntityProjection projection) {
        if (projection.getAttributes() == null) {
            return "";
        }
        return projection.getAttributes().stream().map(this::toHeader).collect(Collectors.joining(COMMA));
    }

    @Override
    public String preFormat(EntityProjection projection, TableExport query) {
        if (projection == null || this.skipCSVHeader) {
            return null;
        }
        return this.generateCSVHeader(projection);
    }

    @Override
    public String postFormat(EntityProjection projection, TableExport query) {
        return null;
    }

    private String toHeader(Attribute attribute) {
        if (attribute.getArguments() == null || attribute.getArguments().size() == 0) {
            return this.quote(attribute.getName());
        }
        StringBuilder header = new StringBuilder();
        header.append(attribute.getName());
        header.append("(");
        header.append(attribute.getArguments().stream().map(arg -> arg.getName() + "=" + arg.getValue()).collect(Collectors.joining(" ")));
        header.append(")");
        return this.quote(header.toString());
    }

    private String quote(String toQuote) {
        return DOUBLE_QUOTES + toQuote + DOUBLE_QUOTES;
    }
}

