/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.models.security;

import com.yahoo.elide.annotation.SecurityCheck;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.RequestScope;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.core.security.checks.FilterExpressionCheck;
import com.yahoo.elide.core.security.checks.OperationCheck;
import com.yahoo.elide.core.security.checks.UserCheck;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import java.security.Principal;
import java.util.Collections;
import java.util.Optional;

public class AsyncAPIInlineChecks {
    private static final String PRINCIPAL_NAME = "principalName";

    private static FilterPredicate getPredicateOfPrincipalName(String principalName, Type entityClass) {
        Path.PathElement path = new Path.PathElement(entityClass, (Type)ClassType.STRING_TYPE, PRINCIPAL_NAME);
        return new FilterPredicate(path, Operator.IN, Collections.singletonList(principalName));
    }

    private static FilterPredicate getPredicateOfPrincipalNameNull(Type entityClass) {
        Path.PathElement path = new Path.PathElement(entityClass, (Type)ClassType.STRING_TYPE, PRINCIPAL_NAME);
        return new FilterPredicate(path, Operator.ISNULL, Collections.emptyList());
    }

    @SecurityCheck(value="value is Queued")
    public static class AsyncAPIStatusQueuedValue
    extends OperationCheck<AsyncAPI> {
        public static final String VALUE_IS_QUEUED = "value is Queued";

        public boolean ok(AsyncAPI object, RequestScope requestScope, Optional<ChangeSpec> changeSpec) {
            return changeSpec.get().getModified().toString().equals(QueryStatus.QUEUED.name());
        }
    }

    @SecurityCheck(value="value is Cancelled")
    public static class AsyncAPIStatusValue
    extends OperationCheck<AsyncAPI> {
        public static final String VALUE_IS_CANCELLED = "value is Cancelled";

        public boolean ok(AsyncAPI object, RequestScope requestScope, Optional<ChangeSpec> changeSpec) {
            return changeSpec.get().getModified().toString().equals(QueryStatus.CANCELLED.name());
        }
    }

    @SecurityCheck(value="Principal is Admin")
    public static class AsyncAPIAdmin
    extends UserCheck {
        public static final String PRINCIPAL_IS_ADMIN = "Principal is Admin";

        public boolean ok(User user) {
            if (user != null && user.getPrincipal() != null) {
                return user.isInRole("admin");
            }
            return false;
        }
    }

    @SecurityCheck(value="Principal is Owner")
    public static class AsyncAPIOwner<T>
    extends FilterExpressionCheck<T> {
        public static final String PRINCIPAL_IS_OWNER = "Principal is Owner";

        public FilterExpression getFilterExpression(Type entityClass, RequestScope requestScope) {
            Principal principal = requestScope.getUser().getPrincipal();
            if (principal == null || principal.getName() == null) {
                return AsyncAPIInlineChecks.getPredicateOfPrincipalNameNull(entityClass);
            }
            return AsyncAPIInlineChecks.getPredicateOfPrincipalName(principal.getName(), entityClass);
        }
    }
}

